/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.v13.campaignmanagement.ArrayOfPriceTableRow;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.PriceQualifier;
import com.microsoft.bingads.v13.campaignmanagement.PriceTableRow;
import com.microsoft.bingads.v13.campaignmanagement.PriceUnit;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.List;

class PriceTableRowHelper {
    public static final int MaxNumberOfPriceTableRows = 8;

    PriceTableRowHelper() {
    }

    public static void addRowValuesFromPriceTableRows(ArrayOfPriceTableRow arrayOfPriceTableRow, RowValues rowValues, Long id) {
        List<PriceTableRow> priceTableRows = arrayOfPriceTableRow.getPriceTableRows();
        for (int i = 1; i <= priceTableRows.size(); ++i) {
            rowValues.put("Currency Code " + i, priceTableRows.get(i - 1).getCurrencyCode());
            rowValues.put("Price Description " + i, priceTableRows.get(i - 1).getDescription());
            rowValues.put("Header " + i, priceTableRows.get(i - 1).getHeader());
            rowValues.put("Final Mobile Url " + i, StringExtensions.writeUrls("; ", priceTableRows.get(i - 1).getFinalMobileUrls(), id));
            rowValues.put("Final Url " + i, StringExtensions.writeUrls("; ", priceTableRows.get(i - 1).getFinalUrls(), id));
            rowValues.put("Price " + i, StringExtensions.toBulkString(priceTableRows.get(i - 1).getPrice()));
            rowValues.put("Price Qualifier " + i, priceTableRows.get(i - 1).getPriceQualifier().value());
            rowValues.put("Price Unit " + i, priceTableRows.get(i - 1).getPriceUnit().value());
        }
    }

    public static void addPriceTableRowsFromRowValues(RowValues values, ArrayOfPriceTableRow arrayOfPriceTableRow) {
        List<PriceTableRow> priceTableRows = arrayOfPriceTableRow.getPriceTableRows();
        for (int i = 1; i <= 8; ++i) {
            String currencyCode = values.tryGet("Currency Code " + i);
            String priceDescription = values.tryGet("Price Description " + i);
            String header = values.tryGet("Header " + i);
            String finalMobileUrl = values.tryGet("Final Mobile Url " + i);
            String finalUrl = values.tryGet("Final Url " + i);
            String price = values.tryGet("Price " + i);
            String priceQualifier = values.tryGet("Price Qualifier " + i);
            String priceUnit = values.tryGet("Price Unit " + i);
            if (price == null || price.isEmpty() || priceQualifier == null || priceQualifier.isEmpty() || priceUnit == null || priceUnit.isEmpty()) continue;
            PriceTableRow priceTableRow = new PriceTableRow();
            priceTableRow.setCurrencyCode(currencyCode);
            priceTableRow.setDescription(priceDescription);
            priceTableRow.setHeader(header);
            ArrayOfstring finalMobileUrls = new ArrayOfstring();
            List<String> urls = StringExtensions.parseUrls(finalMobileUrl);
            if (urls == null) {
                finalMobileUrls = null;
            } else {
                finalMobileUrls.getStrings().addAll(urls);
            }
            priceTableRow.setFinalMobileUrls(finalMobileUrls);
            ArrayOfstring finalUrls = new ArrayOfstring();
            urls = StringExtensions.parseUrls(finalUrl);
            if (urls == null) {
                finalUrls = null;
            } else {
                finalUrls.getStrings().addAll(urls);
            }
            priceTableRow.setFinalUrls(finalUrls);
            priceTableRow.setPrice(StringExtensions.nullOrDouble(price));
            priceTableRow.setPriceQualifier(PriceQualifier.fromValue(priceQualifier));
            priceTableRow.setPriceUnit(PriceUnit.fromValue(priceUnit));
            priceTableRows.add(priceTableRow);
        }
    }
}

