/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.GenderCriterion;
import com.microsoft.bingads.v13.campaignmanagement.GenderType;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupGenderCriterion
extends BulkAdGroupBiddableCriterion {
    private static final List<BulkMapping<BulkAdGroupGenderCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    protected Criterion createCriterion() {
        return new GenderCriterion();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupGenderCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupGenderCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkAdGroupGenderCriterion, String>("Target", new Function<BulkAdGroupGenderCriterion, String>(){

            @Override
            public String apply(BulkAdGroupGenderCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof GenderCriterion) {
                    GenderType genderType = ((GenderCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getGenderType();
                    return genderType == null ? null : genderType.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupGenderCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupGenderCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof GenderCriterion) {
                    ((GenderCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setGenderType(StringExtensions.parseOptional(v, new Function<String, GenderType>(){

                        @Override
                        public GenderType apply(String s) {
                            return GenderType.fromValue(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

