/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.ReviewAdExtension;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkReviewAdExtension
extends BulkAdExtension<ReviewAdExtension> {
    private static final List<BulkMapping<BulkReviewAdExtension>> MAPPINGS;

    public ReviewAdExtension getReviewAdExtension() {
        return (ReviewAdExtension)this.getAdExtension();
    }

    public void setReviewAdExtension(ReviewAdExtension reviewAdExtension) {
        this.setAdExtension(reviewAdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        ReviewAdExtension extension = new ReviewAdExtension();
        extension.setType("ReviewAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getReviewAdExtension(), "ReviewAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkReviewAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkReviewAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkReviewAdExtension, String>("Is Exact", new Function<BulkReviewAdExtension, String>(){

            @Override
            public String apply(BulkReviewAdExtension c) {
                return StringExtensions.toBooleanBulkString(((ReviewAdExtension)c.getAdExtension()).getIsExact());
            }
        }, new BiConsumer<String, BulkReviewAdExtension>(){

            @Override
            public void accept(String v, BulkReviewAdExtension c) {
                c.getReviewAdExtension().setIsExact(Boolean.parseBoolean(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkReviewAdExtension, String>("Text", new Function<BulkReviewAdExtension, String>(){

            @Override
            public String apply(BulkReviewAdExtension c) {
                return ((ReviewAdExtension)c.getAdExtension()).getText();
            }
        }, new BiConsumer<String, BulkReviewAdExtension>(){

            @Override
            public void accept(String v, BulkReviewAdExtension c) {
                c.getReviewAdExtension().setText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkReviewAdExtension, String>("Source", new Function<BulkReviewAdExtension, String>(){

            @Override
            public String apply(BulkReviewAdExtension c) {
                return ((ReviewAdExtension)c.getAdExtension()).getSource();
            }
        }, new BiConsumer<String, BulkReviewAdExtension>(){

            @Override
            public void accept(String v, BulkReviewAdExtension c) {
                c.getReviewAdExtension().setSource(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkReviewAdExtension, String>("Url", new Function<BulkReviewAdExtension, String>(){

            @Override
            public String apply(BulkReviewAdExtension c) {
                return ((ReviewAdExtension)c.getAdExtension()).getUrl();
            }
        }, new BiConsumer<String, BulkReviewAdExtension>(){

            @Override
            public void accept(String v, BulkReviewAdExtension c) {
                c.getReviewAdExtension().setUrl(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

