/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.PromotionAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.PromotionDiscountModifier;
import com.microsoft.bingads.v13.campaignmanagement.PromotionOccasion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkPromotionAdExtension
extends BulkAdExtension<PromotionAdExtension> {
    private static final List<BulkMapping<BulkPromotionAdExtension>> MAPPINGS;
    private String actionText;

    public PromotionAdExtension getPromotionAdExtension() {
        return (PromotionAdExtension)this.getAdExtension();
    }

    public void setPromotionAdExtension(PromotionAdExtension PromotionAdExtension2) {
        this.setAdExtension(PromotionAdExtension2);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        PromotionAdExtension extension = new PromotionAdExtension();
        extension.setType("PromotionAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getPromotionAdExtension(), "PromotionAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public String getActionText() {
        return this.actionText;
    }

    public void setActionText(String actionText) {
        this.actionText = actionText;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkPromotionAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkPromotionAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Currency Code", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return t.getPromotionAdExtension().getCurrencyCode();
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setCurrencyCode(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Language", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return t.getPromotionAdExtension().getLanguage();
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setLanguage(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Promotion Code", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return StringExtensions.toOptionalBulkString(t.getPromotionAdExtension().getPromotionCode(), t.getPromotionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setPromotionCode(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Promotion Target", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return t.getPromotionAdExtension().getPromotionItem();
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setPromotionItem(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Promotion Start", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return StringExtensions.toScheduleDateBulkString(t.getPromotionAdExtension().getPromotionStartDate(), t.getPromotionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                try {
                    c.getPromotionAdExtension().setPromotionStartDate(StringExtensions.parseDate(v));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Promotion End", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return StringExtensions.toScheduleDateBulkString(t.getPromotionAdExtension().getPromotionEndDate(), t.getPromotionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                try {
                    c.getPromotionAdExtension().setPromotionEndDate(StringExtensions.parseDate(v));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Money Amount Off", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return StringExtensions.toBulkString(t.getPromotionAdExtension().getMoneyAmountOff());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setMoneyAmountOff(StringExtensions.parseOptional(v, new Function<String, Double>(){

                    @Override
                    public Double apply(String value) {
                        return Double.parseDouble(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Orders Over Amount", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return StringExtensions.toBulkString(t.getPromotionAdExtension().getOrdersOverAmount());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setOrdersOverAmount(StringExtensions.parseOptional(v, new Function<String, Double>(){

                    @Override
                    public Double apply(String value) {
                        return Double.parseDouble(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Percent Off", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return StringExtensions.toBulkString(t.getPromotionAdExtension().getPercentOff());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setPercentOff(StringExtensions.parseOptional(v, new Function<String, Double>(){

                    @Override
                    public Double apply(String value) {
                        return Double.parseDouble(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Discount Modifier", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                if (t.getPromotionAdExtension().getDiscountModifier() == null) {
                    return null;
                }
                return StringExtensions.toBulkString(t.getPromotionAdExtension().getDiscountModifier().value());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setDiscountModifier(StringExtensions.parseOptional(v, new Function<String, PromotionDiscountModifier>(){

                    @Override
                    public PromotionDiscountModifier apply(String value) {
                        return PromotionDiscountModifier.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Occasion", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                if (t.getPromotionAdExtension().getPromotionOccasion() == null) {
                    return null;
                }
                return StringExtensions.toBulkString(t.getPromotionAdExtension().getPromotionOccasion().value());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setPromotionOccasion(StringExtensions.parseOptional(v, new Function<String, PromotionOccasion>(){

                    @Override
                    public PromotionOccasion apply(String value) {
                        return PromotionOccasion.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Final Url", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension c) {
                return StringExtensions.writeUrls("; ", c.getPromotionAdExtension().getFinalUrls(), c.getPromotionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getPromotionAdExtension().setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Mobile Final Url", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension c) {
                return StringExtensions.writeUrls("; ", c.getPromotionAdExtension().getFinalMobileUrls(), c.getPromotionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getPromotionAdExtension().setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Tracking Template", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension t) {
                return StringExtensions.toOptionalBulkString(t.getPromotionAdExtension().getTrackingUrlTemplate(), t.getPromotionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                c.getPromotionAdExtension().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Custom Parameter", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension c) {
                return StringExtensions.toCustomParaBulkString(c.getPromotionAdExtension().getUrlCustomParameters(), c.getPromotionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                try {
                    c.getPromotionAdExtension().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkPromotionAdExtension, String>("Final Url Suffix", new Function<BulkPromotionAdExtension, String>(){

            @Override
            public String apply(BulkPromotionAdExtension c) {
                return StringExtensions.toOptionalBulkString(((PromotionAdExtension)c.getAdExtension()).getFinalUrlSuffix(), ((PromotionAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkPromotionAdExtension>(){

            @Override
            public void accept(String v, BulkPromotionAdExtension c) {
                ((PromotionAdExtension)c.getAdExtension()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

