/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class BulkAccount
extends SingleRecordBulkEntity {
    private long id;
    private long customerId;
    private Calendar syncTime;
    private Boolean MSCLKIDAutoTaggingEnabled;
    private Boolean includeViewThroughConversions;
    private Boolean profileExpansionEnabled;
    private String trackingUrlTemplate;
    private String finalUrlSuffix;
    private Boolean adClickParallelTracking;
    private Map<String, Boolean> autoApplyRecommendations;
    private Boolean allowImageAutoRetrieve;
    private List<String> businessAttributes;
    private static final List<BulkMapping<BulkAccount>> MAPPINGS;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(long customerId) {
        this.customerId = customerId;
    }

    public Calendar getSyncTime() {
        return this.syncTime;
    }

    public void setSyncTime(Calendar syncTime) {
        this.syncTime = syncTime;
    }

    public Boolean getMSCLKIDAutoTaggingEnabled() {
        return this.MSCLKIDAutoTaggingEnabled;
    }

    public void setMSCLKIDAutoTaggingEnabled(Boolean msclkAutoTagEnabled) {
        this.MSCLKIDAutoTaggingEnabled = msclkAutoTagEnabled;
    }

    public Boolean getIncludeViewThroughConversions() {
        return this.includeViewThroughConversions;
    }

    public void setIncludeViewThroughConversions(Boolean includeViewThroughConversions) {
        this.includeViewThroughConversions = includeViewThroughConversions;
    }

    public Boolean getProfileExpansionEnabled() {
        return this.profileExpansionEnabled;
    }

    public void setProfileExpansionEnabled(Boolean profileExpansionEnabled) {
        this.profileExpansionEnabled = profileExpansionEnabled;
    }

    public String getTrackingUrlTemplate() {
        return this.trackingUrlTemplate;
    }

    public void setTrackingUrlTemplate(String trackingTemplate) {
        this.trackingUrlTemplate = trackingTemplate;
    }

    public String getFinalUrlSuffix() {
        return this.finalUrlSuffix;
    }

    public void setFinalUrlSuffix(String finalUrlSuffix) {
        this.finalUrlSuffix = finalUrlSuffix;
    }

    public Boolean getAdClickParallelTracking() {
        return this.adClickParallelTracking;
    }

    public void setAdClickParallelTracking(Boolean adClickParallelTracking) {
        this.adClickParallelTracking = adClickParallelTracking;
    }

    public Map<String, Boolean> getAutoApplyRecommendations() {
        return this.autoApplyRecommendations;
    }

    public void setAutoApplyRecommendations(Map<String, Boolean> autoApplyRecommendations) {
        this.autoApplyRecommendations = autoApplyRecommendations;
    }

    public List<String> getBusinessAttributes() {
        return this.businessAttributes;
    }

    public void setBusinessAttributes(List<String> businessAttributes) {
        this.businessAttributes = businessAttributes;
    }

    public Boolean getAllowImageAutoRetrieve() {
        return this.allowImageAutoRetrieve;
    }

    public void setAllowImageAutoRetrieve(Boolean allowImageAutoRetrieve) {
        this.allowImageAutoRetrieve = allowImageAutoRetrieve;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAccount, Object>> m = new ArrayList<SimpleBulkMapping<BulkAccount, Object>>();
        m.add(new SimpleBulkMapping<BulkAccount, Long>("Id", new Function<BulkAccount, Long>(){

            @Override
            public Long apply(BulkAccount t) {
                return t.getId();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, Long>("Parent Id", new Function<BulkAccount, Long>(){

            @Override
            public Long apply(BulkAccount t) {
                return t.getCustomerId();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setCustomerId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, String>("Sync Time", new Function<BulkAccount, String>(){

            @Override
            public String apply(BulkAccount t) {
                if (t.getSyncTime() == null) {
                    return null;
                }
                SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.format(t.getSyncTime().getTime());
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setSyncTime(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, Boolean>("MSCLKID Auto Tagging Enabled", new Function<BulkAccount, Boolean>(){

            @Override
            public Boolean apply(BulkAccount t) {
                return t.getMSCLKIDAutoTaggingEnabled();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setMSCLKIDAutoTaggingEnabled(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, String>("Tracking Template", new Function<BulkAccount, String>(){

            @Override
            public String apply(BulkAccount t) {
                return t.getTrackingUrlTemplate();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, String>("Final Url Suffix", new Function<BulkAccount, String>(){

            @Override
            public String apply(BulkAccount c) {
                return StringExtensions.toOptionalBulkString(c.getFinalUrlSuffix(), c.getId());
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, Boolean>("Include View Through Conversions", new Function<BulkAccount, Boolean>(){

            @Override
            public Boolean apply(BulkAccount t) {
                return t.getIncludeViewThroughConversions();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setIncludeViewThroughConversions(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, Boolean>("Profile Expansion Enabled", new Function<BulkAccount, Boolean>(){

            @Override
            public Boolean apply(BulkAccount t) {
                return t.getProfileExpansionEnabled();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setProfileExpansionEnabled(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, Boolean>("Ad Click Parallel Tracking", new Function<BulkAccount, Boolean>(){

            @Override
            public Boolean apply(BulkAccount t) {
                return t.getAdClickParallelTracking();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setAdClickParallelTracking(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, String>("Auto Apply Recommendations", new Function<BulkAccount, String>(){

            @Override
            public String apply(BulkAccount t) {
                return StringExtensions.writeAutoApplyRecommendations(";", t.getAutoApplyRecommendations());
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setAutoApplyRecommendations(StringExtensions.parseAutoApplyRecommendations(v, ";"));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, String>("Business Attributes", new Function<BulkAccount, String>(){

            @Override
            public String apply(BulkAccount t) {
                return StringExtensions.writeBusinessAttributes(";", t.getBusinessAttributes());
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setBusinessAttributes(StringExtensions.parseBusinessAttributes(v, ";"));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, Boolean>("Allow Image Auto Retrieve", new Function<BulkAccount, Boolean>(){

            @Override
            public Boolean apply(BulkAccount t) {
                return t.getAllowImageAutoRetrieve();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setAllowImageAutoRetrieve(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

