/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.SharedEntityAssociation;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAccountPlacementInclusionListAssociation
extends SingleRecordBulkEntity {
    private Status status;
    private SharedEntityAssociation sharedEntityAssociation;
    private static final List<BulkMapping<BulkAccountPlacementInclusionListAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setSharedEntityAssociation(new SharedEntityAssociation());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getSharedEntityAssociation(), "SharedEntityAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public SharedEntityAssociation getSharedEntityAssociation() {
        return this.sharedEntityAssociation;
    }

    public void setSharedEntityAssociation(SharedEntityAssociation sharedEntityAssociation) {
        this.sharedEntityAssociation = sharedEntityAssociation;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAccountPlacementInclusionListAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAccountPlacementInclusionListAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAccountPlacementInclusionListAssociation, Long>("Id", new Function<BulkAccountPlacementInclusionListAssociation, Long>(){

            @Override
            public Long apply(BulkAccountPlacementInclusionListAssociation c) {
                return c.getSharedEntityAssociation().getSharedEntityId();
            }
        }, new BiConsumer<String, BulkAccountPlacementInclusionListAssociation>(){

            @Override
            public void accept(String v, BulkAccountPlacementInclusionListAssociation c) {
                c.getSharedEntityAssociation().setSharedEntityId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccountPlacementInclusionListAssociation, String>("Status", new Function<BulkAccountPlacementInclusionListAssociation, String>(){

            @Override
            public String apply(BulkAccountPlacementInclusionListAssociation c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAccountPlacementInclusionListAssociation>(){

            @Override
            public void accept(String v, BulkAccountPlacementInclusionListAssociation c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return StringExtensions.fromValueOptional(value, Status.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccountPlacementInclusionListAssociation, Long>("Parent Id", new Function<BulkAccountPlacementInclusionListAssociation, Long>(){

            @Override
            public Long apply(BulkAccountPlacementInclusionListAssociation c) {
                return c.getSharedEntityAssociation().getEntityId();
            }
        }, new BiConsumer<String, BulkAccountPlacementInclusionListAssociation>(){

            @Override
            public void accept(String v, BulkAccountPlacementInclusionListAssociation c) {
                c.getSharedEntityAssociation().setEntityId(StringExtensions.nullOrLong(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

