/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v13.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v13.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.CashbackAdjustment;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v13.campaignmanagement.CriterionCashback;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkCampaignBiddableCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion biddableCampaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignBiddableCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        CashbackAdjustment cashback = new CashbackAdjustment();
        cashback.setType(CashbackAdjustment.class.getSimpleName());
        Criterion criterion = this.createCriterion();
        campaignCriterion.setCriterion(criterion);
        campaignCriterion.getCriterion().setType(criterion.getClass().getSimpleName());
        campaignCriterion.setCriterionBid(bidMultiplier);
        campaignCriterion.setCriterionCashback(cashback);
        campaignCriterion.setType("BiddableCampaignCriterion");
        this.setBiddableCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    protected abstract Criterion createCriterion();

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getBiddableCampaignCriterion() {
        return this.biddableCampaignCriterion;
    }

    public void setBiddableCampaignCriterion(BiddableCampaignCriterion biddableCampaignCriterion) {
        this.biddableCampaignCriterion = biddableCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignBiddableCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignBiddableCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignBiddableCriterion, String>("Status", new Function<BulkCampaignBiddableCriterion, String>(){

            @Override
            public String apply(BulkCampaignBiddableCriterion c) {
                CampaignCriterionStatus status = c.getBiddableCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignBiddableCriterion>(){

            @Override
            public void accept(String v, BulkCampaignBiddableCriterion c) {
                c.getBiddableCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return StringExtensions.fromValueOptional(s, CampaignCriterionStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignBiddableCriterion, Long>("Id", new Function<BulkCampaignBiddableCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignBiddableCriterion c) {
                return c.getBiddableCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignBiddableCriterion>(){

            @Override
            public void accept(String v, BulkCampaignBiddableCriterion c) {
                c.getBiddableCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignBiddableCriterion, Long>("Parent Id", new Function<BulkCampaignBiddableCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignBiddableCriterion c) {
                return c.getBiddableCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignBiddableCriterion>(){

            @Override
            public void accept(String v, BulkCampaignBiddableCriterion c) {
                c.getBiddableCampaignCriterion().setCampaignId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignBiddableCriterion, String>("Campaign", new Function<BulkCampaignBiddableCriterion, String>(){

            @Override
            public String apply(BulkCampaignBiddableCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignBiddableCriterion>(){

            @Override
            public void accept(String v, BulkCampaignBiddableCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignBiddableCriterion, String>("Bid Adjustment", new Function<BulkCampaignBiddableCriterion, String>(){

            @Override
            public String apply(BulkCampaignBiddableCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionBid bid = c.getBiddableCampaignCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignBiddableCriterion>(){

            @Override
            public void accept(String v, BulkCampaignBiddableCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    ((BidMultiplier)c.getBiddableCampaignCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignBiddableCriterion, String>("Cashback Percent", new Function<BulkCampaignBiddableCriterion, String>(){

            @Override
            public String apply(BulkCampaignBiddableCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionCashback cashback = c.getBiddableCampaignCriterion().getCriterionCashback();
                    if (cashback == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((CashbackAdjustment)cashback).getCashbackPercent());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignBiddableCriterion>(){

            @Override
            public void accept(String v, BulkCampaignBiddableCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    Double cashbackPercent = StringExtensions.nullOrDouble(v);
                    if (cashbackPercent == null) {
                        c.getBiddableCampaignCriterion().setCriterionCashback(null);
                    } else {
                        ((CashbackAdjustment)c.getBiddableCampaignCriterion().getCriterionCashback()).setCashbackPercent(cashbackPercent);
                    }
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

