/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.AdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v13.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v13.campaignmanagement.FixedBid;
import com.microsoft.bingads.v13.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupCriterion
extends SingleRecordBulkEntity {
    private AdGroupCriterion adGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupCriterion>> MAPPINGS;

    private static void biddingToCsv(BulkAdGroupCriterion c, RowValues v) {
        if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
            v.put("Is Excluded", "False");
            CriterionBid bid = ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getCriterionBid();
            if (bid instanceof FixedBid) {
                v.put("Bid", StringExtensions.toAdGroupFixedBidBulkString((FixedBid)bid, c.getAdGroupCriterion().getId()));
            } else if (bid instanceof BidMultiplier) {
                v.put("Bid Adjustment", StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier()));
            }
        } else {
            v.put("Is Excluded", "True");
        }
    }

    protected Criterion createCriterion() {
        return null;
    }

    private static void csvToBidding(RowValues v, BulkAdGroupCriterion c) {
        boolean isExcluded;
        String exclude = v.tryGet("Is Excluded");
        if ("yes".equalsIgnoreCase(exclude) || "true".equalsIgnoreCase(exclude)) {
            isExcluded = true;
        } else if ("no".equalsIgnoreCase(exclude) || "false".equalsIgnoreCase(exclude)) {
            isExcluded = false;
        } else {
            throw new IllegalStateException(String.format("%s can only be set to TRUE or FALSE in %s ", "Is Excluded", BulkAdGroupCriterion.class.getSimpleName()));
        }
        if (isExcluded) {
            Criterion criterion = c.createCriterion();
            NegativeAdGroupCriterion negativeAdGroupCriterion = new NegativeAdGroupCriterion();
            negativeAdGroupCriterion.setCriterion(criterion);
            negativeAdGroupCriterion.setType(NegativeAdGroupCriterion.class.getSimpleName());
            c.setAdGroupCriterion(negativeAdGroupCriterion);
        } else {
            Criterion criterion = c.createCriterion();
            BiddableAdGroupCriterion biddableAdGroupCriterion = new BiddableAdGroupCriterion();
            biddableAdGroupCriterion.setCriterion(criterion);
            biddableAdGroupCriterion.setType(BiddableAdGroupCriterion.class.getSimpleName());
            String bidStr = v.tryGet("Bid");
            Double bidAmount = StringExtensions.parseAdGroupBidAmount(bidStr);
            if (bidAmount != null) {
                FixedBid fixedBid = new FixedBid();
                fixedBid.setType(FixedBid.class.getSimpleName());
                fixedBid.setAmount(bidAmount);
                biddableAdGroupCriterion.setCriterionBid(fixedBid);
            } else {
                String bidAdjustmentStr = v.tryGet("Bid Adjustment");
                bidAmount = StringExtensions.parseAdGroupBidAmount(bidAdjustmentStr);
                if (bidAmount != null) {
                    BidMultiplier bidMultiplier = new BidMultiplier();
                    bidMultiplier.setType(BidMultiplier.class.getSimpleName());
                    bidMultiplier.setMultiplier(bidAmount);
                    biddableAdGroupCriterion.setCriterionBid(bidMultiplier);
                } else {
                    FixedBid fixedBid = new FixedBid();
                    fixedBid.setType(FixedBid.class.getSimpleName());
                    biddableAdGroupCriterion.setCriterionBid(fixedBid);
                }
            }
            c.setAdGroupCriterion(biddableAdGroupCriterion);
        }
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupCriterion(), AdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public AdGroupCriterion getAdGroupCriterion() {
        return this.adGroupCriterion;
    }

    public void setAdGroupCriterion(AdGroupCriterion adGroupCriterion) {
        this.adGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    static {
        ArrayList<BulkMapping<BulkAdGroupCriterion>> m = new ArrayList<BulkMapping<BulkAdGroupCriterion>>();
        m.add(new ComplexBulkMapping<BulkAdGroupCriterion>(new BiConsumer<BulkAdGroupCriterion, RowValues>(){

            @Override
            public void accept(BulkAdGroupCriterion c, RowValues v) {
                BulkAdGroupCriterion.biddingToCsv(c, v);
            }
        }, new BiConsumer<RowValues, BulkAdGroupCriterion>(){

            @Override
            public void accept(RowValues v, BulkAdGroupCriterion c) {
                BulkAdGroupCriterion.csvToBidding(v, c);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, String>("Status", new Function<BulkAdGroupCriterion, String>(){

            @Override
            public String apply(BulkAdGroupCriterion c) {
                AdGroupCriterionStatus status = c.getAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                c.getAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return StringExtensions.fromValueOptional(s, AdGroupCriterionStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, Long>("Id", new Function<BulkAdGroupCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupCriterion c) {
                return c.getAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                c.getAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, Long>("Parent Id", new Function<BulkAdGroupCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupCriterion c) {
                return c.getAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                c.getAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, String>("Campaign", new Function<BulkAdGroupCriterion, String>(){

            @Override
            public String apply(BulkAdGroupCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, String>("Ad Group", new Function<BulkAdGroupCriterion, String>(){

            @Override
            public String apply(BulkAdGroupCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, String>("Final Url", new Function<BulkAdGroupCriterion, String>(){

            @Override
            public String apply(BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.writeUrls("; ", ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getFinalUrls(), c.getAdGroupCriterion().getId());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ArrayOfstring urls = new ArrayOfstring();
                    List<String> urlArray = StringExtensions.parseUrls(v);
                    if (urlArray == null) {
                        urls = null;
                    } else {
                        urls.getStrings().addAll(urlArray);
                    }
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setFinalUrls(urls);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, String>("Mobile Final Url", new Function<BulkAdGroupCriterion, String>(){

            @Override
            public String apply(BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.writeUrls("; ", ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getFinalMobileUrls(), c.getAdGroupCriterion().getId());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ArrayOfstring urls = new ArrayOfstring();
                    List<String> urlArray = StringExtensions.parseUrls(v);
                    if (urlArray == null) {
                        urls = null;
                    } else {
                        urls.getStrings().addAll(urlArray);
                    }
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setFinalMobileUrls(urls);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, String>("Tracking Template", new Function<BulkAdGroupCriterion, String>(){

            @Override
            public String apply(BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toOptionalBulkString(((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getTrackingUrlTemplate(), c.getAdGroupCriterion().getId());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, String>("Custom Parameter", new Function<BulkAdGroupCriterion, String>(){

            @Override
            public String apply(BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toCustomParaBulkString(((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getUrlCustomParameters(), c.getAdGroupCriterion().getId());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    try {
                        ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupCriterion, String>("Final Url Suffix", new Function<BulkAdGroupCriterion, String>(){

            @Override
            public String apply(BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toOptionalBulkString(((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getFinalUrlSuffix(), c.getAdGroupCriterion().getId());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

