/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.reporting;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.Authentication;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.ServiceClient;
import com.microsoft.bingads.internal.ParentCallback;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.internal.utilities.HttpClientHttpFileService;
import com.microsoft.bingads.internal.utilities.HttpFileService;
import com.microsoft.bingads.internal.utilities.SimpleZipExtractor;
import com.microsoft.bingads.internal.utilities.ZipExtractor;
import com.microsoft.bingads.v13.reporting.CouldNotSubmitReportingDownloadException;
import com.microsoft.bingads.v13.reporting.IReportingService;
import com.microsoft.bingads.v13.reporting.Report;
import com.microsoft.bingads.v13.reporting.ReportFileReader;
import com.microsoft.bingads.v13.reporting.ReportRequest;
import com.microsoft.bingads.v13.reporting.ReportingDownloadOperation;
import com.microsoft.bingads.v13.reporting.ReportingDownloadParameters;
import com.microsoft.bingads.v13.reporting.ReportingOperationStatus;
import com.microsoft.bingads.v13.reporting.SubmitGenerateReportRequest;
import com.microsoft.bingads.v13.reporting.SubmitGenerateReportResponse;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ReportingServiceManager {
    private AuthorizationData authorizationData;
    private HttpFileService httpFileService;
    private ZipExtractor zipExtractor;
    private ApiEnvironment apiEnvironment;
    private int statusPollIntervalInMilliseconds;
    private int downloadHttpTimeoutInMilliseconds;
    private final ServiceClient<IReportingService> serviceClient;
    private File workingDirectory;

    public ReportingServiceManager(AuthorizationData authorizationData) {
        this(authorizationData, null);
    }

    public ReportingServiceManager(AuthorizationData authorizationData, ApiEnvironment apiEnvironment) {
        this(authorizationData, new HttpClientHttpFileService(), new SimpleZipExtractor(), apiEnvironment);
    }

    private ReportingServiceManager(AuthorizationData authorizationData, HttpFileService httpFileService, ZipExtractor zipExtractor, ApiEnvironment apiEnvironment) {
        this.authorizationData = authorizationData;
        this.httpFileService = httpFileService;
        this.zipExtractor = zipExtractor;
        this.apiEnvironment = apiEnvironment;
        this.serviceClient = new ServiceClient<IReportingService>(this.authorizationData, apiEnvironment, IReportingService.class);
        this.workingDirectory = new File(System.getProperty("java.io.tmpdir"), "BingAdsSDK");
        this.statusPollIntervalInMilliseconds = 5000;
        this.downloadHttpTimeoutInMilliseconds = 100000;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    private void validateSubmitReportingDownloadParameters(ReportRequest reportRequest) {
        if (reportRequest == null) {
            throw new NullPointerException("parameters must not be null");
        }
    }

    public Future<Report> downloadReportAsync(final ReportingDownloadParameters parameters, AsyncCallback<Report> callback) {
        final ResultFuture<Report> resultFuture = new ResultFuture<Report>(callback);
        this.downloadFileAsync(parameters, (AsyncCallback<File>)new ParentCallback<File>(resultFuture){

            @Override
            public void onSuccess(File result) throws Exception {
                if (result == null) {
                    resultFuture.setResult(null);
                } else {
                    resultFuture.setResult(new ReportFileReader(result, parameters.getReportRequest().getFormat()).getReport());
                }
            }
        });
        return resultFuture;
    }

    public Future<File> downloadFileAsync(ReportingDownloadParameters parameters, AsyncCallback<File> callback) {
        this.validateUserData();
        this.validateSubmitReportingDownloadParameters(parameters.getReportRequest());
        return this.downloadFileAsyncImpl(parameters, callback);
    }

    private Future<File> downloadFileAsyncImpl(final ReportingDownloadParameters parameters, AsyncCallback<File> callback) {
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        this.workingDirectory.mkdirs();
        this.submitDownloadAsync(parameters.getReportRequest(), (AsyncCallback<ReportingDownloadOperation>)new ParentCallback<ReportingDownloadOperation>(resultFuture){

            @Override
            public void onSuccess(final ReportingDownloadOperation operation) {
                operation.trackAsync((AsyncCallback<ReportingOperationStatus>)new ParentCallback<ReportingOperationStatus>(resultFuture){

                    @Override
                    public void onSuccess(ReportingOperationStatus status) throws IOException, URISyntaxException {
                        ReportingServiceManager.this.downloadReportingFileAsync(parameters.getResultFileDirectory(), parameters.getResultFileName(), parameters.getOverwriteResultFile(), operation, new ParentCallback<File>(resultFuture){

                            @Override
                            public void onSuccess(File localFile) {
                                resultFuture.setResult(localFile);
                            }
                        });
                    }
                });
            }
        });
        return resultFuture;
    }

    private <T> Future<File> downloadReportingFileAsync(File resultFileDirectory, String resultFileName, boolean overwriteResultFile, ReportingDownloadOperation operation, AsyncCallback<File> callback) throws IOException, URISyntaxException {
        operation.setHttpFileService(this.httpFileService);
        operation.setZipExtractor(this.zipExtractor);
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        File effectiveResultFileDirectory = resultFileDirectory;
        if (effectiveResultFileDirectory == null) {
            effectiveResultFileDirectory = this.workingDirectory;
        }
        operation.downloadResultFileAsync(effectiveResultFileDirectory, resultFileName, true, overwriteResultFile, (AsyncCallback<File>)new ParentCallback<File>(resultFuture){

            @Override
            public void onSuccess(File file) {
                resultFuture.setResult(file);
            }
        });
        return resultFuture;
    }

    private void validateUserData() {
        this.authorizationData.validate();
    }

    public Future<ReportingDownloadOperation> submitDownloadAsync(ReportRequest reportRequest, AsyncCallback<ReportingDownloadOperation> callback) {
        Authentication auth = this.authorizationData.getAuthentication();
        if (auth == null) {
            throw new IllegalArgumentException("Missing authentication");
        }
        final ResultFuture<ReportingDownloadOperation> resultFuture = new ResultFuture<ReportingDownloadOperation>(callback);
        IReportingService service = this.serviceClient.getService();
        SubmitGenerateReportRequest submitRequest = new SubmitGenerateReportRequest();
        submitRequest.setReportRequest(reportRequest);
        service.submitGenerateReportAsync(submitRequest, new AsyncHandler<SubmitGenerateReportResponse>(){

            public void handleResponse(Response<SubmitGenerateReportResponse> res) {
                try {
                    SubmitGenerateReportResponse response = (SubmitGenerateReportResponse)res.get();
                    String trackingId = ServiceUtils.GetTrackingId(res);
                    ReportingDownloadOperation operation = new ReportingDownloadOperation(response.getReportRequestId(), ReportingServiceManager.this.authorizationData, trackingId, ReportingServiceManager.this.apiEnvironment);
                    operation.setStatusPollIntervalInMilliseconds(ReportingServiceManager.this.statusPollIntervalInMilliseconds);
                    operation.setDownloadHttpTimeoutInMilliseconds(ReportingServiceManager.this.downloadHttpTimeoutInMilliseconds);
                    resultFuture.setResult(operation);
                }
                catch (InterruptedException e) {
                    resultFuture.setException(new CouldNotSubmitReportingDownloadException(e));
                }
                catch (ExecutionException e) {
                    resultFuture.setException(new CouldNotSubmitReportingDownloadException(e));
                }
            }
        });
        return resultFuture;
    }

    public HttpFileService getHttpFileService() {
        return this.httpFileService;
    }

    public void setHttpFileService(HttpFileService httpFileService) {
        this.httpFileService = httpFileService;
    }

    public ZipExtractor getZipExtractor() {
        return this.zipExtractor;
    }

    public void setZipExtractor(ZipExtractor zipExtractor) {
        this.zipExtractor = zipExtractor;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File value) {
        this.workingDirectory = value;
    }

    public int getStatusPollIntervalInMilliseconds() {
        return this.statusPollIntervalInMilliseconds;
    }

    public void setStatusPollIntervalInMilliseconds(int statusPollIntervalInMilliseconds) {
        this.statusPollIntervalInMilliseconds = statusPollIntervalInMilliseconds;
    }

    public int getDownloadHttpTimeoutInMilliseconds() {
        return this.downloadHttpTimeoutInMilliseconds;
    }

    public void setDownloadHttpTimeoutInMilliseconds(int downloadHttpTimeoutInMilliseconds) {
        this.downloadHttpTimeoutInMilliseconds = downloadHttpTimeoutInMilliseconds;
    }

    public void cleanupTempFiles() {
        for (File file : this.workingDirectory.listFiles()) {
            file.delete();
        }
    }
}

