/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BidSuggestionData;
import com.microsoft.bingads.v13.bulk.entities.BulkKeywordBestPositionBid;
import com.microsoft.bingads.v13.bulk.entities.BulkKeywordBidSuggestion;
import com.microsoft.bingads.v13.bulk.entities.BulkKeywordFirstPageBid;
import com.microsoft.bingads.v13.bulk.entities.BulkKeywordMainLineBid;
import com.microsoft.bingads.v13.bulk.entities.QualityScoreData;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.BiddingScheme;
import com.microsoft.bingads.v13.campaignmanagement.InheritFromParentBiddingScheme;
import com.microsoft.bingads.v13.campaignmanagement.Keyword;
import com.microsoft.bingads.v13.campaignmanagement.KeywordEditorialStatus;
import com.microsoft.bingads.v13.campaignmanagement.KeywordStatus;
import com.microsoft.bingads.v13.campaignmanagement.MatchType;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.v13.internal.bulk.BulkRecordReader;
import com.microsoft.bingads.v13.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.TryResult;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkKeyword
extends SingleRecordBulkEntity {
    private Long campaignId;
    private Long adGroupId;
    private Keyword keyword;
    private String campaignName;
    private String adGroupName;
    private QualityScoreData qualityScoreData;
    private BidSuggestionData bidSuggestions;
    private static final List<BulkMapping<BulkKeyword>> MAPPINGS;

    private static void csvToBiddingScheme(RowValues values, BulkKeyword c) {
        try {
            String bidStrategyTypeRowValue = values.tryGet("Bid Strategy Type");
            if (bidStrategyTypeRowValue == null) {
                return;
            }
            BiddingScheme biddingScheme = StringExtensions.parseBiddingScheme(bidStrategyTypeRowValue);
            if (biddingScheme == null) {
                return;
            }
            if (biddingScheme instanceof InheritFromParentBiddingScheme) {
                InheritFromParentBiddingScheme inheritFromParentBiddingScheme = new InheritFromParentBiddingScheme();
                inheritFromParentBiddingScheme.setType("InheritFromParent");
                inheritFromParentBiddingScheme.setInheritedBidStrategyType(values.tryGet("Inherited Bid Strategy Type"));
                c.getKeyword().setBiddingScheme(inheritFromParentBiddingScheme);
            } else {
                c.getKeyword().setBiddingScheme(biddingScheme);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void biddingSchemeToCsv(BulkKeyword c, RowValues values) {
        BiddingScheme biddingScheme = c.getKeyword().getBiddingScheme();
        if (biddingScheme == null) {
            return;
        }
        try {
            values.put("Bid Strategy Type", StringExtensions.toBiddingSchemeBulkString(biddingScheme));
            if (biddingScheme instanceof InheritFromParentBiddingScheme) {
                values.put("Inherited Bid Strategy Type", ((InheritFromParentBiddingScheme)biddingScheme).getInheritedBidStrategyType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setKeyword(new Keyword());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.qualityScoreData = QualityScoreData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getKeyword(), "Keyword");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            QualityScoreData.writeToRowValuesIfNotNull(this.qualityScoreData, values);
        }
    }

    @Override
    public void readAdditionalData(BulkRecordReader reader) {
        TryResult<BulkKeywordBidSuggestion> nextBidSuggestionResult = reader.tryRead(BulkKeywordBidSuggestion.class);
        while (nextBidSuggestionResult.isSuccessful()) {
            BulkKeywordBidSuggestion nextBidSuggestion;
            if (this.bidSuggestions == null) {
                this.bidSuggestions = new BidSuggestionData();
            }
            if ((nextBidSuggestion = nextBidSuggestionResult.getResult()) instanceof BulkKeywordBestPositionBid) {
                this.bidSuggestions.setBestPosition(nextBidSuggestion);
            } else if (nextBidSuggestion instanceof BulkKeywordMainLineBid) {
                this.bidSuggestions.setMainLine(nextBidSuggestion);
            } else if (nextBidSuggestion instanceof BulkKeywordFirstPageBid) {
                this.bidSuggestions.setFirstPage(nextBidSuggestion);
            }
            nextBidSuggestionResult = reader.tryRead(BulkKeywordBidSuggestion.class);
        }
    }

    @Override
    public void writeAdditionalData(BulkObjectWriter writer) throws IOException {
        if (this.getBidSuggestions() != null) {
            BulkKeywordBidSuggestion.writeIfNotNull(this.getBidSuggestions().getBestPosition(), writer);
            BulkKeywordBidSuggestion.writeIfNotNull(this.getBidSuggestions().getMainLine(), writer);
            BulkKeywordBidSuggestion.writeIfNotNull(this.getBidSuggestions().getFirstPage(), writer);
        }
    }

    public Long getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public Long getAdGroupId() {
        return this.adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public Keyword getKeyword() {
        return this.keyword;
    }

    public void setKeyword(Keyword keyword) {
        this.keyword = keyword;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public QualityScoreData getQualityScoreData() {
        return this.qualityScoreData;
    }

    public BidSuggestionData getBidSuggestions() {
        return this.bidSuggestions;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkKeyword, Long>("Id", new Function<BulkKeyword, Long>(){

            @Override
            public Long apply(BulkKeyword c) {
                return c.getKeyword().getId();
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, Long>("Campaign Id", new Function<BulkKeyword, Long>(){

            @Override
            public Long apply(BulkKeyword c) {
                return c.getCampaignId();
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.setCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, Long>("Parent Id", new Function<BulkKeyword, Long>(){

            @Override
            public Long apply(BulkKeyword c) {
                return c.getAdGroupId();
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Status", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return c.getKeyword().getStatus() != null ? c.getKeyword().getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setStatus(StringExtensions.parseOptional(v, new Function<String, KeywordStatus>(){

                    @Override
                    public KeywordStatus apply(String value) {
                        return StringExtensions.fromValueOptional(value, KeywordStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Campaign", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Ad Group", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Keyword", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return c.getKeyword().getText();
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Destination Url", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.toOptionalBulkString(c.getKeyword().getDestinationUrl(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setDestinationUrl(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Editorial Status", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword t) {
                return t.getKeyword().getEditorialStatus() != null ? t.getKeyword().getEditorialStatus().value() : null;
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setEditorialStatus(StringExtensions.parseOptional(v, new Function<String, KeywordEditorialStatus>(){

                    @Override
                    public KeywordEditorialStatus apply(String value) {
                        return StringExtensions.fromValueOptional(value, KeywordEditorialStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Match Type", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.toMatchTypeBulkString(c.getKeyword().getMatchType());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setMatchType(StringExtensions.parseOptional(v, new Function<String, MatchType>(){

                    @Override
                    public MatchType apply(String value) {
                        return StringExtensions.fromValueOptional(value, MatchType.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Bid", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.toKeywordBidBulkString(c.getKeyword().getBid(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setBid(StringExtensions.parseKeywordBid(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Param1", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.toOptionalBulkString(c.getKeyword().getParam1(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setParam1(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Param2", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.toOptionalBulkString(c.getKeyword().getParam2(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setParam2(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Param3", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.toOptionalBulkString(c.getKeyword().getParam3(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setParam3(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Final Url", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.writeUrls("; ", c.getKeyword().getFinalUrls(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getKeyword().setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Mobile Final Url", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.writeUrls("; ", c.getKeyword().getFinalMobileUrls(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getKeyword().setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Tracking Template", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.toOptionalBulkString(c.getKeyword().getTrackingUrlTemplate(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Custom Parameter", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.toCustomParaBulkString(c.getKeyword().getUrlCustomParameters(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                try {
                    c.getKeyword().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new ComplexBulkMapping<BulkKeyword>(new BiConsumer<BulkKeyword, RowValues>(){

            @Override
            public void accept(BulkKeyword c, RowValues v) {
                BulkKeyword.biddingSchemeToCsv(c, v);
            }
        }, new BiConsumer<RowValues, BulkKeyword>(){

            @Override
            public void accept(RowValues v, BulkKeyword c) {
                BulkKeyword.csvToBiddingScheme(v, c);
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeyword, String>("Final Url Suffix", new Function<BulkKeyword, String>(){

            @Override
            public String apply(BulkKeyword c) {
                return StringExtensions.toOptionalBulkString(c.getKeyword().getFinalUrlSuffix(), c.getKeyword().getId());
            }
        }, new BiConsumer<String, BulkKeyword>(){

            @Override
            public void accept(String v, BulkKeyword c) {
                c.getKeyword().setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

