/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.AgeRange;
import com.microsoft.bingads.v13.campaignmanagement.AudienceGroup;
import com.microsoft.bingads.v13.campaignmanagement.GenderType;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAudienceGroup
extends SingleRecordBulkEntity {
    private Status status;
    private Long accountId;
    private List<Long> audienceIds;
    private List<AgeRange> ageRanges;
    private List<GenderType> genderTypes;
    private AudienceGroup audienceGroup;
    private static final List<BulkMapping<BulkAudienceGroup>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAudienceGroup(new AudienceGroup());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAudienceGroup(), "AudienceGroup");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public AudienceGroup getAudienceGroup() {
        return this.audienceGroup;
    }

    public void setAudienceGroup(AudienceGroup audienceGroup) {
        this.audienceGroup = audienceGroup;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<Long> getAudienceIds() {
        return this.audienceIds;
    }

    public void setAudienceIds(List<Long> audienceIds) {
        this.audienceIds = audienceIds;
    }

    public List<AgeRange> getAgeRanges() {
        return this.ageRanges;
    }

    public void setAgeRanges(List<AgeRange> ageRanges) {
        this.ageRanges = ageRanges;
    }

    public List<GenderType> getGenderTypes() {
        return this.genderTypes;
    }

    public void setGenderTypes(List<GenderType> genderTypes) {
        this.genderTypes = genderTypes;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAudienceGroup, Object>> m = new ArrayList<SimpleBulkMapping<BulkAudienceGroup, Object>>();
        m.add(new SimpleBulkMapping<BulkAudienceGroup, String>("Status", new Function<BulkAudienceGroup, String>(){

            @Override
            public String apply(BulkAudienceGroup c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAudienceGroup>(){

            @Override
            public void accept(String v, BulkAudienceGroup c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return StringExtensions.fromValueOptional(value, Status.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudienceGroup, Long>("Id", new Function<BulkAudienceGroup, Long>(){

            @Override
            public Long apply(BulkAudienceGroup c) {
                return c.getAudienceGroup().getId();
            }
        }, new BiConsumer<String, BulkAudienceGroup>(){

            @Override
            public void accept(String v, BulkAudienceGroup c) {
                c.getAudienceGroup().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudienceGroup, Long>("Parent Id", new Function<BulkAudienceGroup, Long>(){

            @Override
            public Long apply(BulkAudienceGroup c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkAudienceGroup>(){

            @Override
            public void accept(String v, BulkAudienceGroup c) {
                c.setAccountId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudienceGroup, String>("Audience Group Name", new Function<BulkAudienceGroup, String>(){

            @Override
            public String apply(BulkAudienceGroup c) {
                return c.getAudienceGroup().getName();
            }
        }, new BiConsumer<String, BulkAudienceGroup>(){

            @Override
            public void accept(String v, BulkAudienceGroup c) {
                c.getAudienceGroup().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudienceGroup, String>("Audiences", new Function<BulkAudienceGroup, String>(){

            @Override
            public String apply(BulkAudienceGroup c) {
                return StringExtensions.toLongListBulkString(";", c.getAudienceIds());
            }
        }, new BiConsumer<String, BulkAudienceGroup>(){

            @Override
            public void accept(String v, BulkAudienceGroup c) {
                c.setAudienceIds(StringExtensions.parseIdList(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudienceGroup, String>("Age Ranges", new Function<BulkAudienceGroup, String>(){

            @Override
            public String apply(BulkAudienceGroup c) {
                return StringExtensions.toAgeRangeListBulkString(";", c.getAgeRanges());
            }
        }, new BiConsumer<String, BulkAudienceGroup>(){

            @Override
            public void accept(String v, BulkAudienceGroup c) {
                c.setAgeRanges(StringExtensions.parseAgeRangeList(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudienceGroup, String>("Gender Types", new Function<BulkAudienceGroup, String>(){

            @Override
            public String apply(BulkAudienceGroup c) {
                return StringExtensions.toGenderTypeListBulkString(";", c.getGenderTypes());
            }
        }, new BiConsumer<String, BulkAudienceGroup>(){

            @Override
            public void accept(String v, BulkAudienceGroup c) {
                c.setGenderTypes(StringExtensions.parseGenderTypeList(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudienceGroup, String>("Description", new Function<BulkAudienceGroup, String>(){

            @Override
            public String apply(BulkAudienceGroup c) {
                return c.getAudienceGroup().getDescription();
            }
        }, new BiConsumer<String, BulkAudienceGroup>(){

            @Override
            public void accept(String v, BulkAudienceGroup c) {
                c.getAudienceGroup().setDescription(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

