/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.HotelCheckInDateCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class BulkAdGroupHotelCheckInDateCriterion
extends BulkAdGroupBiddableCriterion {
    private static final List<BulkMapping<BulkAdGroupHotelCheckInDateCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    protected Criterion createCriterion() {
        return new HotelCheckInDateCriterion();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupHotelCheckInDateCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupHotelCheckInDateCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkAdGroupHotelCheckInDateCriterion, String>("Min Target Value", new Function<BulkAdGroupHotelCheckInDateCriterion, String>(){

            @Override
            public String apply(BulkAdGroupHotelCheckInDateCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelCheckInDateCriterion) {
                    HotelCheckInDateCriterion criterion = (HotelCheckInDateCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    if (criterion == null || criterion.getStartDate() == null) {
                        return null;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    format.setTimeZone(TimeZone.getTimeZone("UTC"));
                    return format.format(criterion.getStartDate().getTime());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupHotelCheckInDateCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupHotelCheckInDateCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelCheckInDateCriterion) {
                    ((HotelCheckInDateCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setStartDate(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                        @Override
                        public Calendar apply(String t) {
                            GregorianCalendar c = new GregorianCalendar();
                            try {
                                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                                c.setTime(format.parse(t));
                            }
                            catch (ParseException ex) {
                                throw new UncheckedParseException(ex);
                            }
                            return c;
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupHotelCheckInDateCriterion, String>("Max Target Value", new Function<BulkAdGroupHotelCheckInDateCriterion, String>(){

            @Override
            public String apply(BulkAdGroupHotelCheckInDateCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelCheckInDateCriterion) {
                    HotelCheckInDateCriterion criterion = (HotelCheckInDateCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    if (criterion == null || criterion.getEndDate() == null) {
                        return null;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    format.setTimeZone(TimeZone.getTimeZone("UTC"));
                    return format.format(criterion.getEndDate().getTime());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupHotelCheckInDateCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupHotelCheckInDateCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelCheckInDateCriterion) {
                    ((HotelCheckInDateCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setEndDate(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                        @Override
                        public Calendar apply(String t) {
                            GregorianCalendar c = new GregorianCalendar();
                            try {
                                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                                c.setTime(format.parse(t));
                            }
                            catch (ParseException ex) {
                                throw new UncheckedParseException(ex);
                            }
                            return c;
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

