/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.restful.ResponseInfo;
import com.microsoft.bingads.internal.restful.RestfulServiceClient;
import com.microsoft.bingads.v13.adinsight.AdApiFaultDetail;
import com.microsoft.bingads.v13.adinsight.AdApiFaultDetail_Exception;
import com.microsoft.bingads.v13.adinsight.ApiFaultDetail;
import com.microsoft.bingads.v13.adinsight.ApiFaultDetail_Exception;
import com.microsoft.bingads.v13.adinsight.ApplicationFault;
import com.microsoft.bingads.v13.adinsight.ApplyRecommendationsRequest;
import com.microsoft.bingads.v13.adinsight.ApplyRecommendationsResponse;
import com.microsoft.bingads.v13.adinsight.DismissRecommendationsRequest;
import com.microsoft.bingads.v13.adinsight.DismissRecommendationsResponse;
import com.microsoft.bingads.v13.adinsight.GetAuctionInsightDataRequest;
import com.microsoft.bingads.v13.adinsight.GetAuctionInsightDataResponse;
import com.microsoft.bingads.v13.adinsight.GetAudienceBreakdownRequest;
import com.microsoft.bingads.v13.adinsight.GetAudienceBreakdownResponse;
import com.microsoft.bingads.v13.adinsight.GetAudienceFullEstimationRequest;
import com.microsoft.bingads.v13.adinsight.GetAudienceFullEstimationResponse;
import com.microsoft.bingads.v13.adinsight.GetAutoApplyOptInStatusRequest;
import com.microsoft.bingads.v13.adinsight.GetAutoApplyOptInStatusResponse;
import com.microsoft.bingads.v13.adinsight.GetBidLandscapeByAdGroupIdsRequest;
import com.microsoft.bingads.v13.adinsight.GetBidLandscapeByAdGroupIdsResponse;
import com.microsoft.bingads.v13.adinsight.GetBidLandscapeByKeywordIdsRequest;
import com.microsoft.bingads.v13.adinsight.GetBidLandscapeByKeywordIdsResponse;
import com.microsoft.bingads.v13.adinsight.GetBidOpportunitiesRequest;
import com.microsoft.bingads.v13.adinsight.GetBidOpportunitiesResponse;
import com.microsoft.bingads.v13.adinsight.GetBudgetOpportunitiesRequest;
import com.microsoft.bingads.v13.adinsight.GetBudgetOpportunitiesResponse;
import com.microsoft.bingads.v13.adinsight.GetDomainCategoriesRequest;
import com.microsoft.bingads.v13.adinsight.GetDomainCategoriesResponse;
import com.microsoft.bingads.v13.adinsight.GetEstimatedBidByKeywordIdsRequest;
import com.microsoft.bingads.v13.adinsight.GetEstimatedBidByKeywordIdsResponse;
import com.microsoft.bingads.v13.adinsight.GetEstimatedBidByKeywordsRequest;
import com.microsoft.bingads.v13.adinsight.GetEstimatedBidByKeywordsResponse;
import com.microsoft.bingads.v13.adinsight.GetEstimatedPositionByKeywordIdsRequest;
import com.microsoft.bingads.v13.adinsight.GetEstimatedPositionByKeywordIdsResponse;
import com.microsoft.bingads.v13.adinsight.GetEstimatedPositionByKeywordsRequest;
import com.microsoft.bingads.v13.adinsight.GetEstimatedPositionByKeywordsResponse;
import com.microsoft.bingads.v13.adinsight.GetHistoricalKeywordPerformanceRequest;
import com.microsoft.bingads.v13.adinsight.GetHistoricalKeywordPerformanceResponse;
import com.microsoft.bingads.v13.adinsight.GetHistoricalSearchCountRequest;
import com.microsoft.bingads.v13.adinsight.GetHistoricalSearchCountResponse;
import com.microsoft.bingads.v13.adinsight.GetKeywordCategoriesRequest;
import com.microsoft.bingads.v13.adinsight.GetKeywordCategoriesResponse;
import com.microsoft.bingads.v13.adinsight.GetKeywordDemographicsRequest;
import com.microsoft.bingads.v13.adinsight.GetKeywordDemographicsResponse;
import com.microsoft.bingads.v13.adinsight.GetKeywordIdeaCategoriesRequest;
import com.microsoft.bingads.v13.adinsight.GetKeywordIdeaCategoriesResponse;
import com.microsoft.bingads.v13.adinsight.GetKeywordIdeasRequest;
import com.microsoft.bingads.v13.adinsight.GetKeywordIdeasResponse;
import com.microsoft.bingads.v13.adinsight.GetKeywordLocationsRequest;
import com.microsoft.bingads.v13.adinsight.GetKeywordLocationsResponse;
import com.microsoft.bingads.v13.adinsight.GetKeywordOpportunitiesRequest;
import com.microsoft.bingads.v13.adinsight.GetKeywordOpportunitiesResponse;
import com.microsoft.bingads.v13.adinsight.GetKeywordTrafficEstimatesRequest;
import com.microsoft.bingads.v13.adinsight.GetKeywordTrafficEstimatesResponse;
import com.microsoft.bingads.v13.adinsight.GetPerformanceInsightsDetailDataByAccountIdRequest;
import com.microsoft.bingads.v13.adinsight.GetPerformanceInsightsDetailDataByAccountIdResponse;
import com.microsoft.bingads.v13.adinsight.GetRecommendationsRequest;
import com.microsoft.bingads.v13.adinsight.GetRecommendationsResponse;
import com.microsoft.bingads.v13.adinsight.GetTextAssetSuggestionsByFinalUrlsRequest;
import com.microsoft.bingads.v13.adinsight.GetTextAssetSuggestionsByFinalUrlsResponse;
import com.microsoft.bingads.v13.adinsight.IAdInsightService;
import com.microsoft.bingads.v13.adinsight.PutMetricDataRequest;
import com.microsoft.bingads.v13.adinsight.PutMetricDataResponse;
import com.microsoft.bingads.v13.adinsight.RetrieveRecommendationsRequest;
import com.microsoft.bingads.v13.adinsight.RetrieveRecommendationsResponse;
import com.microsoft.bingads.v13.adinsight.SetAutoApplyOptInStatusRequest;
import com.microsoft.bingads.v13.adinsight.SetAutoApplyOptInStatusResponse;
import com.microsoft.bingads.v13.adinsight.SuggestKeywordsForUrlRequest;
import com.microsoft.bingads.v13.adinsight.SuggestKeywordsForUrlResponse;
import com.microsoft.bingads.v13.adinsight.SuggestKeywordsFromExistingKeywordsRequest;
import com.microsoft.bingads.v13.adinsight.SuggestKeywordsFromExistingKeywordsResponse;
import com.microsoft.bingads.v13.adinsight.TagRecommendationsRequest;
import com.microsoft.bingads.v13.adinsight.TagRecommendationsResponse;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import java.util.Map;
import java.util.concurrent.Future;

public class AdInsightService
extends RestfulServiceClient
implements IAdInsightService {
    public AdInsightService(Map<String, String> headers, ApiEnvironment env) {
        super(headers, env, IAdInsightService.class);
    }

    Exception processFaultDetail(ApplicationFault faultDetail, boolean shouldThrow) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        String message = this.getFaultMessage(faultDetail.getTrackingId());
        if (faultDetail instanceof AdApiFaultDetail) {
            AdApiFaultDetail_Exception ex = new AdApiFaultDetail_Exception(message, (AdApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiFaultDetail) {
            ApiFaultDetail_Exception ex = new ApiFaultDetail_Exception(message, (ApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (shouldThrow) {
            throw new RuntimeException("Unknown fault type: " + faultDetail.getClass());
        }
        return null;
    }

    protected <Req, Resp> Resp sendRequest(Req request, String entityEndpoint, String verb, Class<Resp> respClass) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        ResponseInfo<Resp, ApplicationFault> responseInfo = this.getResponseInfo(request, entityEndpoint, verb, respClass, ApplicationFault.class);
        if (responseInfo == null) {
            return null;
        }
        ApplicationFault faultDetail = responseInfo.getFaultDetail();
        if (faultDetail != null) {
            this.processFaultDetail(faultDetail, true);
        }
        return responseInfo.getResponse();
    }

    private Exception getFaultException(ApplicationFault faultDetail) {
        try {
            Exception ex = this.processFaultDetail(faultDetail, false);
            return ex;
        }
        catch (Exception ex) {
            throw new InternalException(ex);
        }
    }

    protected <Req, Resp> Response<Resp> sendRequestAsync(Req request, String entityEndpoint, String verb, Class<Resp> respClass, AsyncHandler<Resp> handler) {
        return this.processRequestAsync(request, entityEndpoint, verb, respClass, ApplicationFault.class, x -> this.getFaultException((ApplicationFault)x), handler);
    }

    @Override
    public GetBidOpportunitiesResponse getBidOpportunities(GetBidOpportunitiesRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetBidOpportunitiesResponse response = this.sendRequest(request, "/BidOpportunities/Query", "POST", GetBidOpportunitiesResponse.class);
        return response;
    }

    @Override
    public Response<GetBidOpportunitiesResponse> getBidOpportunitiesAsync(GetBidOpportunitiesRequest request) {
        return this.sendRequestAsync(request, "/BidOpportunities/Query", "POST", GetBidOpportunitiesResponse.class, null);
    }

    @Override
    public Future<?> getBidOpportunitiesAsync(GetBidOpportunitiesRequest request, AsyncHandler<GetBidOpportunitiesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BidOpportunities/Query", "POST", GetBidOpportunitiesResponse.class, asyncHandler);
    }

    @Override
    public GetBudgetOpportunitiesResponse getBudgetOpportunities(GetBudgetOpportunitiesRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetBudgetOpportunitiesResponse response = this.sendRequest(request, "/BudgetOpportunities/Query", "POST", GetBudgetOpportunitiesResponse.class);
        return response;
    }

    @Override
    public Response<GetBudgetOpportunitiesResponse> getBudgetOpportunitiesAsync(GetBudgetOpportunitiesRequest request) {
        return this.sendRequestAsync(request, "/BudgetOpportunities/Query", "POST", GetBudgetOpportunitiesResponse.class, null);
    }

    @Override
    public Future<?> getBudgetOpportunitiesAsync(GetBudgetOpportunitiesRequest request, AsyncHandler<GetBudgetOpportunitiesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BudgetOpportunities/Query", "POST", GetBudgetOpportunitiesResponse.class, asyncHandler);
    }

    @Override
    public GetKeywordOpportunitiesResponse getKeywordOpportunities(GetKeywordOpportunitiesRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetKeywordOpportunitiesResponse response = this.sendRequest(request, "/KeywordOpportunities/Query", "POST", GetKeywordOpportunitiesResponse.class);
        return response;
    }

    @Override
    public Response<GetKeywordOpportunitiesResponse> getKeywordOpportunitiesAsync(GetKeywordOpportunitiesRequest request) {
        return this.sendRequestAsync(request, "/KeywordOpportunities/Query", "POST", GetKeywordOpportunitiesResponse.class, null);
    }

    @Override
    public Future<?> getKeywordOpportunitiesAsync(GetKeywordOpportunitiesRequest request, AsyncHandler<GetKeywordOpportunitiesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/KeywordOpportunities/Query", "POST", GetKeywordOpportunitiesResponse.class, asyncHandler);
    }

    @Override
    public GetEstimatedBidByKeywordIdsResponse getEstimatedBidByKeywordIds(GetEstimatedBidByKeywordIdsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetEstimatedBidByKeywordIdsResponse response = this.sendRequest(request, "/EstimatedBid/QueryByKeywordIds", "POST", GetEstimatedBidByKeywordIdsResponse.class);
        return response;
    }

    @Override
    public Response<GetEstimatedBidByKeywordIdsResponse> getEstimatedBidByKeywordIdsAsync(GetEstimatedBidByKeywordIdsRequest request) {
        return this.sendRequestAsync(request, "/EstimatedBid/QueryByKeywordIds", "POST", GetEstimatedBidByKeywordIdsResponse.class, null);
    }

    @Override
    public Future<?> getEstimatedBidByKeywordIdsAsync(GetEstimatedBidByKeywordIdsRequest request, AsyncHandler<GetEstimatedBidByKeywordIdsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/EstimatedBid/QueryByKeywordIds", "POST", GetEstimatedBidByKeywordIdsResponse.class, asyncHandler);
    }

    @Override
    public GetEstimatedPositionByKeywordIdsResponse getEstimatedPositionByKeywordIds(GetEstimatedPositionByKeywordIdsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetEstimatedPositionByKeywordIdsResponse response = this.sendRequest(request, "/EstimatedPosition/QueryByKeywordIds", "POST", GetEstimatedPositionByKeywordIdsResponse.class);
        return response;
    }

    @Override
    public Response<GetEstimatedPositionByKeywordIdsResponse> getEstimatedPositionByKeywordIdsAsync(GetEstimatedPositionByKeywordIdsRequest request) {
        return this.sendRequestAsync(request, "/EstimatedPosition/QueryByKeywordIds", "POST", GetEstimatedPositionByKeywordIdsResponse.class, null);
    }

    @Override
    public Future<?> getEstimatedPositionByKeywordIdsAsync(GetEstimatedPositionByKeywordIdsRequest request, AsyncHandler<GetEstimatedPositionByKeywordIdsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/EstimatedPosition/QueryByKeywordIds", "POST", GetEstimatedPositionByKeywordIdsResponse.class, asyncHandler);
    }

    @Override
    public GetEstimatedBidByKeywordsResponse getEstimatedBidByKeywords(GetEstimatedBidByKeywordsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetEstimatedBidByKeywordsResponse response = this.sendRequest(request, "/EstimatedBid/QueryByKeywords", "POST", GetEstimatedBidByKeywordsResponse.class);
        return response;
    }

    @Override
    public Response<GetEstimatedBidByKeywordsResponse> getEstimatedBidByKeywordsAsync(GetEstimatedBidByKeywordsRequest request) {
        return this.sendRequestAsync(request, "/EstimatedBid/QueryByKeywords", "POST", GetEstimatedBidByKeywordsResponse.class, null);
    }

    @Override
    public Future<?> getEstimatedBidByKeywordsAsync(GetEstimatedBidByKeywordsRequest request, AsyncHandler<GetEstimatedBidByKeywordsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/EstimatedBid/QueryByKeywords", "POST", GetEstimatedBidByKeywordsResponse.class, asyncHandler);
    }

    @Override
    public GetEstimatedPositionByKeywordsResponse getEstimatedPositionByKeywords(GetEstimatedPositionByKeywordsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetEstimatedPositionByKeywordsResponse response = this.sendRequest(request, "/EstimatedPosition/QueryByKeywords", "POST", GetEstimatedPositionByKeywordsResponse.class);
        return response;
    }

    @Override
    public Response<GetEstimatedPositionByKeywordsResponse> getEstimatedPositionByKeywordsAsync(GetEstimatedPositionByKeywordsRequest request) {
        return this.sendRequestAsync(request, "/EstimatedPosition/QueryByKeywords", "POST", GetEstimatedPositionByKeywordsResponse.class, null);
    }

    @Override
    public Future<?> getEstimatedPositionByKeywordsAsync(GetEstimatedPositionByKeywordsRequest request, AsyncHandler<GetEstimatedPositionByKeywordsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/EstimatedPosition/QueryByKeywords", "POST", GetEstimatedPositionByKeywordsResponse.class, asyncHandler);
    }

    @Override
    public GetBidLandscapeByAdGroupIdsResponse getBidLandscapeByAdGroupIds(GetBidLandscapeByAdGroupIdsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetBidLandscapeByAdGroupIdsResponse response = this.sendRequest(request, "/BidLandscape/QueryByAdGroupIds", "POST", GetBidLandscapeByAdGroupIdsResponse.class);
        return response;
    }

    @Override
    public Response<GetBidLandscapeByAdGroupIdsResponse> getBidLandscapeByAdGroupIdsAsync(GetBidLandscapeByAdGroupIdsRequest request) {
        return this.sendRequestAsync(request, "/BidLandscape/QueryByAdGroupIds", "POST", GetBidLandscapeByAdGroupIdsResponse.class, null);
    }

    @Override
    public Future<?> getBidLandscapeByAdGroupIdsAsync(GetBidLandscapeByAdGroupIdsRequest request, AsyncHandler<GetBidLandscapeByAdGroupIdsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BidLandscape/QueryByAdGroupIds", "POST", GetBidLandscapeByAdGroupIdsResponse.class, asyncHandler);
    }

    @Override
    public GetBidLandscapeByKeywordIdsResponse getBidLandscapeByKeywordIds(GetBidLandscapeByKeywordIdsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetBidLandscapeByKeywordIdsResponse response = this.sendRequest(request, "/BidLandscape/QueryByKeywordIds", "POST", GetBidLandscapeByKeywordIdsResponse.class);
        return response;
    }

    @Override
    public Response<GetBidLandscapeByKeywordIdsResponse> getBidLandscapeByKeywordIdsAsync(GetBidLandscapeByKeywordIdsRequest request) {
        return this.sendRequestAsync(request, "/BidLandscape/QueryByKeywordIds", "POST", GetBidLandscapeByKeywordIdsResponse.class, null);
    }

    @Override
    public Future<?> getBidLandscapeByKeywordIdsAsync(GetBidLandscapeByKeywordIdsRequest request, AsyncHandler<GetBidLandscapeByKeywordIdsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BidLandscape/QueryByKeywordIds", "POST", GetBidLandscapeByKeywordIdsResponse.class, asyncHandler);
    }

    @Override
    public GetHistoricalKeywordPerformanceResponse getHistoricalKeywordPerformance(GetHistoricalKeywordPerformanceRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetHistoricalKeywordPerformanceResponse response = this.sendRequest(request, "/HistoricalKeywordPerformance/Query", "POST", GetHistoricalKeywordPerformanceResponse.class);
        return response;
    }

    @Override
    public Response<GetHistoricalKeywordPerformanceResponse> getHistoricalKeywordPerformanceAsync(GetHistoricalKeywordPerformanceRequest request) {
        return this.sendRequestAsync(request, "/HistoricalKeywordPerformance/Query", "POST", GetHistoricalKeywordPerformanceResponse.class, null);
    }

    @Override
    public Future<?> getHistoricalKeywordPerformanceAsync(GetHistoricalKeywordPerformanceRequest request, AsyncHandler<GetHistoricalKeywordPerformanceResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/HistoricalKeywordPerformance/Query", "POST", GetHistoricalKeywordPerformanceResponse.class, asyncHandler);
    }

    @Override
    public GetHistoricalSearchCountResponse getHistoricalSearchCount(GetHistoricalSearchCountRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetHistoricalSearchCountResponse response = this.sendRequest(request, "/HistoricalSearchCount/Query", "POST", GetHistoricalSearchCountResponse.class);
        return response;
    }

    @Override
    public Response<GetHistoricalSearchCountResponse> getHistoricalSearchCountAsync(GetHistoricalSearchCountRequest request) {
        return this.sendRequestAsync(request, "/HistoricalSearchCount/Query", "POST", GetHistoricalSearchCountResponse.class, null);
    }

    @Override
    public Future<?> getHistoricalSearchCountAsync(GetHistoricalSearchCountRequest request, AsyncHandler<GetHistoricalSearchCountResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/HistoricalSearchCount/Query", "POST", GetHistoricalSearchCountResponse.class, asyncHandler);
    }

    @Override
    public GetKeywordCategoriesResponse getKeywordCategories(GetKeywordCategoriesRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetKeywordCategoriesResponse response = this.sendRequest(request, "/KeywordCategories/Query", "POST", GetKeywordCategoriesResponse.class);
        return response;
    }

    @Override
    public Response<GetKeywordCategoriesResponse> getKeywordCategoriesAsync(GetKeywordCategoriesRequest request) {
        return this.sendRequestAsync(request, "/KeywordCategories/Query", "POST", GetKeywordCategoriesResponse.class, null);
    }

    @Override
    public Future<?> getKeywordCategoriesAsync(GetKeywordCategoriesRequest request, AsyncHandler<GetKeywordCategoriesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/KeywordCategories/Query", "POST", GetKeywordCategoriesResponse.class, asyncHandler);
    }

    @Override
    public GetKeywordDemographicsResponse getKeywordDemographics(GetKeywordDemographicsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetKeywordDemographicsResponse response = this.sendRequest(request, "/KeywordDemographics/Query", "POST", GetKeywordDemographicsResponse.class);
        return response;
    }

    @Override
    public Response<GetKeywordDemographicsResponse> getKeywordDemographicsAsync(GetKeywordDemographicsRequest request) {
        return this.sendRequestAsync(request, "/KeywordDemographics/Query", "POST", GetKeywordDemographicsResponse.class, null);
    }

    @Override
    public Future<?> getKeywordDemographicsAsync(GetKeywordDemographicsRequest request, AsyncHandler<GetKeywordDemographicsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/KeywordDemographics/Query", "POST", GetKeywordDemographicsResponse.class, asyncHandler);
    }

    @Override
    public GetKeywordLocationsResponse getKeywordLocations(GetKeywordLocationsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetKeywordLocationsResponse response = this.sendRequest(request, "/KeywordLocations/Query", "POST", GetKeywordLocationsResponse.class);
        return response;
    }

    @Override
    public Response<GetKeywordLocationsResponse> getKeywordLocationsAsync(GetKeywordLocationsRequest request) {
        return this.sendRequestAsync(request, "/KeywordLocations/Query", "POST", GetKeywordLocationsResponse.class, null);
    }

    @Override
    public Future<?> getKeywordLocationsAsync(GetKeywordLocationsRequest request, AsyncHandler<GetKeywordLocationsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/KeywordLocations/Query", "POST", GetKeywordLocationsResponse.class, asyncHandler);
    }

    @Override
    public SuggestKeywordsForUrlResponse suggestKeywordsForUrl(SuggestKeywordsForUrlRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        SuggestKeywordsForUrlResponse response = this.sendRequest(request, "/KeywordSuggestions/QueryByUrl", "POST", SuggestKeywordsForUrlResponse.class);
        return response;
    }

    @Override
    public Response<SuggestKeywordsForUrlResponse> suggestKeywordsForUrlAsync(SuggestKeywordsForUrlRequest request) {
        return this.sendRequestAsync(request, "/KeywordSuggestions/QueryByUrl", "POST", SuggestKeywordsForUrlResponse.class, null);
    }

    @Override
    public Future<?> suggestKeywordsForUrlAsync(SuggestKeywordsForUrlRequest request, AsyncHandler<SuggestKeywordsForUrlResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/KeywordSuggestions/QueryByUrl", "POST", SuggestKeywordsForUrlResponse.class, asyncHandler);
    }

    @Override
    public SuggestKeywordsFromExistingKeywordsResponse suggestKeywordsFromExistingKeywords(SuggestKeywordsFromExistingKeywordsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        SuggestKeywordsFromExistingKeywordsResponse response = this.sendRequest(request, "/KeywordSuggestions/QueryByKeywords", "POST", SuggestKeywordsFromExistingKeywordsResponse.class);
        return response;
    }

    @Override
    public Response<SuggestKeywordsFromExistingKeywordsResponse> suggestKeywordsFromExistingKeywordsAsync(SuggestKeywordsFromExistingKeywordsRequest request) {
        return this.sendRequestAsync(request, "/KeywordSuggestions/QueryByKeywords", "POST", SuggestKeywordsFromExistingKeywordsResponse.class, null);
    }

    @Override
    public Future<?> suggestKeywordsFromExistingKeywordsAsync(SuggestKeywordsFromExistingKeywordsRequest request, AsyncHandler<SuggestKeywordsFromExistingKeywordsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/KeywordSuggestions/QueryByKeywords", "POST", SuggestKeywordsFromExistingKeywordsResponse.class, asyncHandler);
    }

    @Override
    public GetAuctionInsightDataResponse getAuctionInsightData(GetAuctionInsightDataRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetAuctionInsightDataResponse response = this.sendRequest(request, "/AuctionInsightData/Query", "POST", GetAuctionInsightDataResponse.class);
        return response;
    }

    @Override
    public Response<GetAuctionInsightDataResponse> getAuctionInsightDataAsync(GetAuctionInsightDataRequest request) {
        return this.sendRequestAsync(request, "/AuctionInsightData/Query", "POST", GetAuctionInsightDataResponse.class, null);
    }

    @Override
    public Future<?> getAuctionInsightDataAsync(GetAuctionInsightDataRequest request, AsyncHandler<GetAuctionInsightDataResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AuctionInsightData/Query", "POST", GetAuctionInsightDataResponse.class, asyncHandler);
    }

    @Override
    public GetDomainCategoriesResponse getDomainCategories(GetDomainCategoriesRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetDomainCategoriesResponse response = this.sendRequest(request, "/DomainCategories/Query", "POST", GetDomainCategoriesResponse.class);
        return response;
    }

    @Override
    public Response<GetDomainCategoriesResponse> getDomainCategoriesAsync(GetDomainCategoriesRequest request) {
        return this.sendRequestAsync(request, "/DomainCategories/Query", "POST", GetDomainCategoriesResponse.class, null);
    }

    @Override
    public Future<?> getDomainCategoriesAsync(GetDomainCategoriesRequest request, AsyncHandler<GetDomainCategoriesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/DomainCategories/Query", "POST", GetDomainCategoriesResponse.class, asyncHandler);
    }

    @Override
    public PutMetricDataResponse putMetricData(PutMetricDataRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        PutMetricDataResponse response = this.sendRequest(request, "/MetricData/Put", "POST", PutMetricDataResponse.class);
        return response;
    }

    @Override
    public Response<PutMetricDataResponse> putMetricDataAsync(PutMetricDataRequest request) {
        return this.sendRequestAsync(request, "/MetricData/Put", "POST", PutMetricDataResponse.class, null);
    }

    @Override
    public Future<?> putMetricDataAsync(PutMetricDataRequest request, AsyncHandler<PutMetricDataResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/MetricData/Put", "POST", PutMetricDataResponse.class, asyncHandler);
    }

    @Override
    public GetKeywordIdeaCategoriesResponse getKeywordIdeaCategories(GetKeywordIdeaCategoriesRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetKeywordIdeaCategoriesResponse response = this.sendRequest(request, "/KeywordIdeaCategories/Query", "POST", GetKeywordIdeaCategoriesResponse.class);
        return response;
    }

    @Override
    public Response<GetKeywordIdeaCategoriesResponse> getKeywordIdeaCategoriesAsync(GetKeywordIdeaCategoriesRequest request) {
        return this.sendRequestAsync(request, "/KeywordIdeaCategories/Query", "POST", GetKeywordIdeaCategoriesResponse.class, null);
    }

    @Override
    public Future<?> getKeywordIdeaCategoriesAsync(GetKeywordIdeaCategoriesRequest request, AsyncHandler<GetKeywordIdeaCategoriesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/KeywordIdeaCategories/Query", "POST", GetKeywordIdeaCategoriesResponse.class, asyncHandler);
    }

    @Override
    public GetKeywordIdeasResponse getKeywordIdeas(GetKeywordIdeasRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetKeywordIdeasResponse response = this.sendRequest(request, "/KeywordIdeas/Query", "POST", GetKeywordIdeasResponse.class);
        return response;
    }

    @Override
    public Response<GetKeywordIdeasResponse> getKeywordIdeasAsync(GetKeywordIdeasRequest request) {
        return this.sendRequestAsync(request, "/KeywordIdeas/Query", "POST", GetKeywordIdeasResponse.class, null);
    }

    @Override
    public Future<?> getKeywordIdeasAsync(GetKeywordIdeasRequest request, AsyncHandler<GetKeywordIdeasResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/KeywordIdeas/Query", "POST", GetKeywordIdeasResponse.class, asyncHandler);
    }

    @Override
    public GetKeywordTrafficEstimatesResponse getKeywordTrafficEstimates(GetKeywordTrafficEstimatesRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetKeywordTrafficEstimatesResponse response = this.sendRequest(request, "/KeywordTrafficEstimates/Query", "POST", GetKeywordTrafficEstimatesResponse.class);
        return response;
    }

    @Override
    public Response<GetKeywordTrafficEstimatesResponse> getKeywordTrafficEstimatesAsync(GetKeywordTrafficEstimatesRequest request) {
        return this.sendRequestAsync(request, "/KeywordTrafficEstimates/Query", "POST", GetKeywordTrafficEstimatesResponse.class, null);
    }

    @Override
    public Future<?> getKeywordTrafficEstimatesAsync(GetKeywordTrafficEstimatesRequest request, AsyncHandler<GetKeywordTrafficEstimatesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/KeywordTrafficEstimates/Query", "POST", GetKeywordTrafficEstimatesResponse.class, asyncHandler);
    }

    @Override
    public GetAutoApplyOptInStatusResponse getAutoApplyOptInStatus(GetAutoApplyOptInStatusRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetAutoApplyOptInStatusResponse response = this.sendRequest(request, "/AutoApplyOptInStatus/Query", "POST", GetAutoApplyOptInStatusResponse.class);
        return response;
    }

    @Override
    public Response<GetAutoApplyOptInStatusResponse> getAutoApplyOptInStatusAsync(GetAutoApplyOptInStatusRequest request) {
        return this.sendRequestAsync(request, "/AutoApplyOptInStatus/Query", "POST", GetAutoApplyOptInStatusResponse.class, null);
    }

    @Override
    public Future<?> getAutoApplyOptInStatusAsync(GetAutoApplyOptInStatusRequest request, AsyncHandler<GetAutoApplyOptInStatusResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AutoApplyOptInStatus/Query", "POST", GetAutoApplyOptInStatusResponse.class, asyncHandler);
    }

    @Override
    public SetAutoApplyOptInStatusResponse setAutoApplyOptInStatus(SetAutoApplyOptInStatusRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        SetAutoApplyOptInStatusResponse response = this.sendRequest(request, "/AutoApplyOptInStatus/Set", "POST", SetAutoApplyOptInStatusResponse.class);
        return response;
    }

    @Override
    public Response<SetAutoApplyOptInStatusResponse> setAutoApplyOptInStatusAsync(SetAutoApplyOptInStatusRequest request) {
        return this.sendRequestAsync(request, "/AutoApplyOptInStatus/Set", "POST", SetAutoApplyOptInStatusResponse.class, null);
    }

    @Override
    public Future<?> setAutoApplyOptInStatusAsync(SetAutoApplyOptInStatusRequest request, AsyncHandler<SetAutoApplyOptInStatusResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AutoApplyOptInStatus/Set", "POST", SetAutoApplyOptInStatusResponse.class, asyncHandler);
    }

    @Override
    public GetPerformanceInsightsDetailDataByAccountIdResponse getPerformanceInsightsDetailDataByAccountId(GetPerformanceInsightsDetailDataByAccountIdRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetPerformanceInsightsDetailDataByAccountIdResponse response = this.sendRequest(request, "/PerformanceInsightsDetailData/QueryByAccountId", "POST", GetPerformanceInsightsDetailDataByAccountIdResponse.class);
        return response;
    }

    @Override
    public Response<GetPerformanceInsightsDetailDataByAccountIdResponse> getPerformanceInsightsDetailDataByAccountIdAsync(GetPerformanceInsightsDetailDataByAccountIdRequest request) {
        return this.sendRequestAsync(request, "/PerformanceInsightsDetailData/QueryByAccountId", "POST", GetPerformanceInsightsDetailDataByAccountIdResponse.class, null);
    }

    @Override
    public Future<?> getPerformanceInsightsDetailDataByAccountIdAsync(GetPerformanceInsightsDetailDataByAccountIdRequest request, AsyncHandler<GetPerformanceInsightsDetailDataByAccountIdResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/PerformanceInsightsDetailData/QueryByAccountId", "POST", GetPerformanceInsightsDetailDataByAccountIdResponse.class, asyncHandler);
    }

    @Override
    public GetRecommendationsResponse getRecommendations(GetRecommendationsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetRecommendationsResponse response = this.sendRequest(request, "/Recommendations/Query", "POST", GetRecommendationsResponse.class);
        return response;
    }

    @Override
    public Response<GetRecommendationsResponse> getRecommendationsAsync(GetRecommendationsRequest request) {
        return this.sendRequestAsync(request, "/Recommendations/Query", "POST", GetRecommendationsResponse.class, null);
    }

    @Override
    public Future<?> getRecommendationsAsync(GetRecommendationsRequest request, AsyncHandler<GetRecommendationsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Recommendations/Query", "POST", GetRecommendationsResponse.class, asyncHandler);
    }

    @Override
    public TagRecommendationsResponse tagRecommendations(TagRecommendationsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        TagRecommendationsResponse response = this.sendRequest(request, "/Recommendations/Tag", "POST", TagRecommendationsResponse.class);
        return response;
    }

    @Override
    public Response<TagRecommendationsResponse> tagRecommendationsAsync(TagRecommendationsRequest request) {
        return this.sendRequestAsync(request, "/Recommendations/Tag", "POST", TagRecommendationsResponse.class, null);
    }

    @Override
    public Future<?> tagRecommendationsAsync(TagRecommendationsRequest request, AsyncHandler<TagRecommendationsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Recommendations/Tag", "POST", TagRecommendationsResponse.class, asyncHandler);
    }

    @Override
    public GetTextAssetSuggestionsByFinalUrlsResponse getTextAssetSuggestionsByFinalUrls(GetTextAssetSuggestionsByFinalUrlsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetTextAssetSuggestionsByFinalUrlsResponse response = this.sendRequest(request, "/TextAssetSuggestions/QueryByFinalUrls", "POST", GetTextAssetSuggestionsByFinalUrlsResponse.class);
        return response;
    }

    @Override
    public Response<GetTextAssetSuggestionsByFinalUrlsResponse> getTextAssetSuggestionsByFinalUrlsAsync(GetTextAssetSuggestionsByFinalUrlsRequest request) {
        return this.sendRequestAsync(request, "/TextAssetSuggestions/QueryByFinalUrls", "POST", GetTextAssetSuggestionsByFinalUrlsResponse.class, null);
    }

    @Override
    public Future<?> getTextAssetSuggestionsByFinalUrlsAsync(GetTextAssetSuggestionsByFinalUrlsRequest request, AsyncHandler<GetTextAssetSuggestionsByFinalUrlsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/TextAssetSuggestions/QueryByFinalUrls", "POST", GetTextAssetSuggestionsByFinalUrlsResponse.class, asyncHandler);
    }

    @Override
    public ApplyRecommendationsResponse applyRecommendations(ApplyRecommendationsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        ApplyRecommendationsResponse response = this.sendRequest(request, "/Recommendations/Apply", "POST", ApplyRecommendationsResponse.class);
        return response;
    }

    @Override
    public Response<ApplyRecommendationsResponse> applyRecommendationsAsync(ApplyRecommendationsRequest request) {
        return this.sendRequestAsync(request, "/Recommendations/Apply", "POST", ApplyRecommendationsResponse.class, null);
    }

    @Override
    public Future<?> applyRecommendationsAsync(ApplyRecommendationsRequest request, AsyncHandler<ApplyRecommendationsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Recommendations/Apply", "POST", ApplyRecommendationsResponse.class, asyncHandler);
    }

    @Override
    public DismissRecommendationsResponse dismissRecommendations(DismissRecommendationsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        DismissRecommendationsResponse response = this.sendRequest(request, "/Recommendations/Dismiss", "POST", DismissRecommendationsResponse.class);
        return response;
    }

    @Override
    public Response<DismissRecommendationsResponse> dismissRecommendationsAsync(DismissRecommendationsRequest request) {
        return this.sendRequestAsync(request, "/Recommendations/Dismiss", "POST", DismissRecommendationsResponse.class, null);
    }

    @Override
    public Future<?> dismissRecommendationsAsync(DismissRecommendationsRequest request, AsyncHandler<DismissRecommendationsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Recommendations/Dismiss", "POST", DismissRecommendationsResponse.class, asyncHandler);
    }

    @Override
    public RetrieveRecommendationsResponse retrieveRecommendations(RetrieveRecommendationsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        RetrieveRecommendationsResponse response = this.sendRequest(request, "/Recommendations/Retrieve", "POST", RetrieveRecommendationsResponse.class);
        return response;
    }

    @Override
    public Response<RetrieveRecommendationsResponse> retrieveRecommendationsAsync(RetrieveRecommendationsRequest request) {
        return this.sendRequestAsync(request, "/Recommendations/Retrieve", "POST", RetrieveRecommendationsResponse.class, null);
    }

    @Override
    public Future<?> retrieveRecommendationsAsync(RetrieveRecommendationsRequest request, AsyncHandler<RetrieveRecommendationsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Recommendations/Retrieve", "POST", RetrieveRecommendationsResponse.class, asyncHandler);
    }

    @Override
    public GetAudienceFullEstimationResponse getAudienceFullEstimation(GetAudienceFullEstimationRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetAudienceFullEstimationResponse response = this.sendRequest(request, "/AudienceFullEstimation/Query", "POST", GetAudienceFullEstimationResponse.class);
        return response;
    }

    @Override
    public Response<GetAudienceFullEstimationResponse> getAudienceFullEstimationAsync(GetAudienceFullEstimationRequest request) {
        return this.sendRequestAsync(request, "/AudienceFullEstimation/Query", "POST", GetAudienceFullEstimationResponse.class, null);
    }

    @Override
    public Future<?> getAudienceFullEstimationAsync(GetAudienceFullEstimationRequest request, AsyncHandler<GetAudienceFullEstimationResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AudienceFullEstimation/Query", "POST", GetAudienceFullEstimationResponse.class, asyncHandler);
    }

    @Override
    public GetAudienceBreakdownResponse getAudienceBreakdown(GetAudienceBreakdownRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetAudienceBreakdownResponse response = this.sendRequest(request, "/AudienceBreakdown/Query", "POST", GetAudienceBreakdownResponse.class);
        return response;
    }

    @Override
    public Response<GetAudienceBreakdownResponse> getAudienceBreakdownAsync(GetAudienceBreakdownRequest request) {
        return this.sendRequestAsync(request, "/AudienceBreakdown/Query", "POST", GetAudienceBreakdownResponse.class, null);
    }

    @Override
    public Future<?> getAudienceBreakdownAsync(GetAudienceBreakdownRequest request, AsyncHandler<GetAudienceBreakdownResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AudienceBreakdown/Query", "POST", GetAudienceBreakdownResponse.class, asyncHandler);
    }
}

