/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.AsyncCallback;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ResultFuture<T>
implements Future<T> {
    protected AsyncCallback<T> handler;
    protected T result;
    protected Throwable exception;
    protected volatile boolean done;
    protected boolean cancelled;

    public ResultFuture(AsyncCallback<T> handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(T res) {
        this.result = res;
        if (this.handler != null) {
            try {
                this.handler.onCompleted(new Future<T>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        ResultFuture.this.cancelled = true;
                        return true;
                    }

                    @Override
                    public boolean isCancelled() {
                        return ResultFuture.this.cancelled;
                    }

                    @Override
                    public boolean isDone() {
                        return true;
                    }

                    @Override
                    public T get() throws InterruptedException, ExecutionException {
                        return ResultFuture.this.result;
                    }

                    @Override
                    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return ResultFuture.this.result;
                    }
                });
            }
            catch (Throwable t) {
                this.setException(t, false);
                return;
            }
        }
        this.done = true;
        ResultFuture resultFuture = this;
        synchronized (resultFuture) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        ResultFuture resultFuture = this;
        synchronized (resultFuture) {
            this.notifyAll();
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        ResultFuture resultFuture = this;
        synchronized (resultFuture) {
            if (!this.done) {
                this.wait();
            }
        }
        if (this.cancelled) {
            throw new InterruptedException("Operation Cancelled");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ResultFuture resultFuture = this;
        synchronized (resultFuture) {
            if (!this.done) {
                unit.timedWait(this, timeout);
            }
        }
        if (!this.done) {
            throw new TimeoutException("Operation timed out");
        }
        if (this.cancelled) {
            throw new InterruptedException("Operation Cancelled");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    public void setException(Throwable ex) {
        this.setException(ex, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setException(Throwable ex, boolean invokeHandler) {
        Throwable throwable = this.exception = ex instanceof ExecutionException ? ex.getCause() : ex;
        if (invokeHandler && this.handler != null) {
            try {
                this.handler.onCompleted(new Future<T>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        ResultFuture.this.cancelled = true;
                        return true;
                    }

                    @Override
                    public boolean isCancelled() {
                        return ResultFuture.this.cancelled;
                    }

                    @Override
                    public boolean isDone() {
                        return true;
                    }

                    @Override
                    public T get() throws InterruptedException, ExecutionException {
                        throw new ExecutionException(ResultFuture.this.exception);
                    }

                    @Override
                    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        throw new ExecutionException(ResultFuture.this.exception);
                    }
                });
            }
            catch (Throwable t) {
                this.setException(t, false);
                return;
            }
        }
        this.done = true;
        ResultFuture resultFuture = this;
        synchronized (resultFuture) {
            this.notifyAll();
        }
    }
}

