/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.AttributionModelType;
import com.microsoft.bingads.v13.campaignmanagement.ConversionGoal;
import com.microsoft.bingads.v13.campaignmanagement.ConversionGoalCategory;
import com.microsoft.bingads.v13.campaignmanagement.ConversionGoalCountType;
import com.microsoft.bingads.v13.campaignmanagement.ConversionGoalRevenue;
import com.microsoft.bingads.v13.campaignmanagement.ConversionGoalRevenueType;
import com.microsoft.bingads.v13.campaignmanagement.ConversionGoalStatus;
import com.microsoft.bingads.v13.campaignmanagement.EntityScope;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkConversionGoal<T extends ConversionGoal>
extends SingleRecordBulkEntity {
    private T ConversionGoal;
    private static final List<BulkMapping<BulkConversionGoal>> MAPPINGS;

    public void addRevenue() {
        ((ConversionGoal)this.ConversionGoal).setRevenue(new ConversionGoalRevenue());
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setConversionGoal(this.createConversionGoal());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getConversionGoal(), "ConversionGoal");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public abstract T createConversionGoal();

    public T getConversionGoal() {
        return this.ConversionGoal;
    }

    public void setConversionGoal(T ConversionGoal2) {
        this.ConversionGoal = ConversionGoal2;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkConversionGoal, Object>> m = new ArrayList<SimpleBulkMapping<BulkConversionGoal, Object>>();
        m.add(new SimpleBulkMapping<BulkConversionGoal, String>("Status", new Function<BulkConversionGoal, String>(){

            @Override
            public String apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getStatus() != null ? ((ConversionGoal)c.getConversionGoal()).getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setStatus(StringExtensions.parseOptional(v, new Function<String, ConversionGoalStatus>(){

                    @Override
                    public ConversionGoalStatus apply(String value) {
                        return StringExtensions.fromValueOptional(value, ConversionGoalStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, Long>("Id", new Function<BulkConversionGoal, Long>(){

            @Override
            public Long apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getId();
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, String>("Name", new Function<BulkConversionGoal, String>(){

            @Override
            public String apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getName();
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, String>("Attribution Model Type", new Function<BulkConversionGoal, String>(){

            @Override
            public String apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getAttributionModelType() != null ? ((ConversionGoal)c.getConversionGoal()).getAttributionModelType().value() : null;
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setAttributionModelType(StringExtensions.parseOptional(v, new Function<String, AttributionModelType>(){

                    @Override
                    public AttributionModelType apply(String value) {
                        return StringExtensions.fromValueOptional(value, AttributionModelType.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, Integer>("Conversion Window In Minutes", new Function<BulkConversionGoal, Integer>(){

            @Override
            public Integer apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getConversionWindowInMinutes();
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setConversionWindowInMinutes(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, String>("Count Type", new Function<BulkConversionGoal, String>(){

            @Override
            public String apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getCountType() != null ? ((ConversionGoal)c.getConversionGoal()).getCountType().value() : null;
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setCountType(StringExtensions.parseOptional(v, new Function<String, ConversionGoalCountType>(){

                    @Override
                    public ConversionGoalCountType apply(String value) {
                        return StringExtensions.fromValueOptional(value, ConversionGoalCountType.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, Boolean>("Exclude From Bidding", new Function<BulkConversionGoal, Boolean>(){

            @Override
            public Boolean apply(BulkConversionGoal t) {
                return ((ConversionGoal)t.getConversionGoal()).getExcludeFromBidding();
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setExcludeFromBidding(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, String>("Goal Category", new Function<BulkConversionGoal, String>(){

            @Override
            public String apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getGoalCategory() != null ? ((ConversionGoal)c.getConversionGoal()).getGoalCategory().value() : null;
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setGoalCategory(StringExtensions.parseOptional(v, new Function<String, ConversionGoalCategory>(){

                    @Override
                    public ConversionGoalCategory apply(String value) {
                        return StringExtensions.fromValueOptional(value, ConversionGoalCategory.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, Boolean>("Is Enhanced Conversions Enabled", new Function<BulkConversionGoal, Boolean>(){

            @Override
            public Boolean apply(BulkConversionGoal t) {
                return ((ConversionGoal)t.getConversionGoal()).getIsEnhancedConversionsEnabled();
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setIsEnhancedConversionsEnabled(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, String>("Currency Code", new Function<BulkConversionGoal, String>(){

            @Override
            public String apply(BulkConversionGoal c) {
                if (((ConversionGoal)c.getConversionGoal()).getRevenue() == null) {
                    return null;
                }
                return ((ConversionGoal)c.getConversionGoal()).getRevenue().getCurrencyCode();
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                if (((ConversionGoal)c.getConversionGoal()).getRevenue() == null) {
                    c.addRevenue();
                }
                ((ConversionGoal)c.getConversionGoal()).getRevenue().setCurrencyCode(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, String>("Revenue Value", new Function<BulkConversionGoal, String>(){

            @Override
            public String apply(BulkConversionGoal t) {
                if (((ConversionGoal)t.getConversionGoal()).getRevenue() == null) {
                    return null;
                }
                return ((ConversionGoal)t.getConversionGoal()).getRevenue().getValue() != null ? ((ConversionGoal)t.getConversionGoal()).getRevenue().getValue().toString() : null;
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                if (((ConversionGoal)c.getConversionGoal()).getRevenue() == null) {
                    c.addRevenue();
                }
                ((ConversionGoal)c.getConversionGoal()).getRevenue().setValue(StringExtensions.nullOrBigDecimal(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, String>("Revenue Type", new Function<BulkConversionGoal, String>(){

            @Override
            public String apply(BulkConversionGoal c) {
                if (((ConversionGoal)c.getConversionGoal()).getRevenue() == null) {
                    return null;
                }
                return ((ConversionGoal)c.getConversionGoal()).getRevenue().getType() != null ? ((ConversionGoal)c.getConversionGoal()).getRevenue().getType().value() : null;
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                if (((ConversionGoal)c.getConversionGoal()).getRevenue() == null) {
                    c.addRevenue();
                }
                ((ConversionGoal)c.getConversionGoal()).getRevenue().setType(StringExtensions.parseOptional(v, new Function<String, ConversionGoalRevenueType>(){

                    @Override
                    public ConversionGoalRevenueType apply(String value) {
                        return StringExtensions.fromValueOptional(value, ConversionGoalRevenueType.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, String>("Scope", new Function<BulkConversionGoal, String>(){

            @Override
            public String apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getScope() != null ? ((ConversionGoal)c.getConversionGoal()).getScope().value() : null;
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setScope(StringExtensions.parseOptional(v, new Function<String, EntityScope>(){

                    @Override
                    public EntityScope apply(String value) {
                        return StringExtensions.fromValueOptional(value, EntityScope.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, Long>("UET Tag Id", new Function<BulkConversionGoal, Long>(){

            @Override
            public Long apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getTagId();
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setTagId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkConversionGoal, Integer>("View Through Conversion Window In Minutes", new Function<BulkConversionGoal, Integer>(){

            @Override
            public Integer apply(BulkConversionGoal c) {
                return ((ConversionGoal)c.getConversionGoal()).getViewThroughConversionWindowInMinutes();
            }
        }, new BiConsumer<String, BulkConversionGoal>(){

            @Override
            public void accept(String v, BulkConversionGoal c) {
                ((ConversionGoal)c.getConversionGoal()).setViewThroughConversionWindowInMinutes(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

