/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.GenreCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupGenreCriterion
extends BulkAdGroupBiddableCriterion {
    private static final List<BulkMapping<BulkAdGroupGenreCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    protected Criterion createCriterion() {
        return new GenreCriterion();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupGenreCriterion, Long>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupGenreCriterion, Long>>();
        m.add(new SimpleBulkMapping<BulkAdGroupGenreCriterion, Long>("Target", new Function<BulkAdGroupGenreCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupGenreCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof GenreCriterion) {
                    return ((GenreCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getGenreId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupGenreCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupGenreCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof GenreCriterion) {
                    ((GenreCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setGenreId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                        @Override
                        public Long apply(String s) {
                            return Long.parseLong(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

