/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.DeviceCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupDeviceCriterion
extends BulkAdGroupBiddableCriterion {
    private static final List<BulkMapping<BulkAdGroupDeviceCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public Criterion createCriterion() {
        return new DeviceCriterion();
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>("Target", new Function<BulkAdGroupDeviceCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDeviceCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getDeviceName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setDeviceName(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>("OS Names", new Function<BulkAdGroupDeviceCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDeviceCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getOSName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setOSName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

