/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.restful.ResponseInfo;
import com.microsoft.bingads.internal.restful.RestfulServiceClient;
import com.microsoft.bingads.v13.customermanagement.AdApiFaultDetail;
import com.microsoft.bingads.v13.customermanagement.AdApiFaultDetail_Exception;
import com.microsoft.bingads.v13.customermanagement.AddAccountRequest;
import com.microsoft.bingads.v13.customermanagement.AddAccountResponse;
import com.microsoft.bingads.v13.customermanagement.AddClientLinksRequest;
import com.microsoft.bingads.v13.customermanagement.AddClientLinksResponse;
import com.microsoft.bingads.v13.customermanagement.AddPrepayAccountRequest;
import com.microsoft.bingads.v13.customermanagement.AddPrepayAccountResponse;
import com.microsoft.bingads.v13.customermanagement.ApiFault;
import com.microsoft.bingads.v13.customermanagement.ApiFault_Exception;
import com.microsoft.bingads.v13.customermanagement.ApplicationFault;
import com.microsoft.bingads.v13.customermanagement.DeleteAccountRequest;
import com.microsoft.bingads.v13.customermanagement.DeleteAccountResponse;
import com.microsoft.bingads.v13.customermanagement.DeleteCustomerRequest;
import com.microsoft.bingads.v13.customermanagement.DeleteCustomerResponse;
import com.microsoft.bingads.v13.customermanagement.DeleteUserRequest;
import com.microsoft.bingads.v13.customermanagement.DeleteUserResponse;
import com.microsoft.bingads.v13.customermanagement.DismissNotificationsRequest;
import com.microsoft.bingads.v13.customermanagement.DismissNotificationsResponse;
import com.microsoft.bingads.v13.customermanagement.FindAccountsOrCustomersInfoRequest;
import com.microsoft.bingads.v13.customermanagement.FindAccountsOrCustomersInfoResponse;
import com.microsoft.bingads.v13.customermanagement.FindAccountsRequest;
import com.microsoft.bingads.v13.customermanagement.FindAccountsResponse;
import com.microsoft.bingads.v13.customermanagement.GetAccessibleCustomerRequest;
import com.microsoft.bingads.v13.customermanagement.GetAccessibleCustomerResponse;
import com.microsoft.bingads.v13.customermanagement.GetAccountPilotFeaturesRequest;
import com.microsoft.bingads.v13.customermanagement.GetAccountPilotFeaturesResponse;
import com.microsoft.bingads.v13.customermanagement.GetAccountRequest;
import com.microsoft.bingads.v13.customermanagement.GetAccountResponse;
import com.microsoft.bingads.v13.customermanagement.GetAccountsInfoRequest;
import com.microsoft.bingads.v13.customermanagement.GetAccountsInfoResponse;
import com.microsoft.bingads.v13.customermanagement.GetCurrentUserRequest;
import com.microsoft.bingads.v13.customermanagement.GetCurrentUserResponse;
import com.microsoft.bingads.v13.customermanagement.GetCustomerPilotFeaturesRequest;
import com.microsoft.bingads.v13.customermanagement.GetCustomerPilotFeaturesResponse;
import com.microsoft.bingads.v13.customermanagement.GetCustomerRequest;
import com.microsoft.bingads.v13.customermanagement.GetCustomerResponse;
import com.microsoft.bingads.v13.customermanagement.GetCustomersInfoRequest;
import com.microsoft.bingads.v13.customermanagement.GetCustomersInfoResponse;
import com.microsoft.bingads.v13.customermanagement.GetLinkedAccountsAndCustomersInfoRequest;
import com.microsoft.bingads.v13.customermanagement.GetLinkedAccountsAndCustomersInfoResponse;
import com.microsoft.bingads.v13.customermanagement.GetNotificationsRequest;
import com.microsoft.bingads.v13.customermanagement.GetNotificationsResponse;
import com.microsoft.bingads.v13.customermanagement.GetPilotFeaturesCountriesRequest;
import com.microsoft.bingads.v13.customermanagement.GetPilotFeaturesCountriesResponse;
import com.microsoft.bingads.v13.customermanagement.GetUserMFAStatusRequest;
import com.microsoft.bingads.v13.customermanagement.GetUserMFAStatusResponse;
import com.microsoft.bingads.v13.customermanagement.GetUserRequest;
import com.microsoft.bingads.v13.customermanagement.GetUserResponse;
import com.microsoft.bingads.v13.customermanagement.GetUsersInfoRequest;
import com.microsoft.bingads.v13.customermanagement.GetUsersInfoResponse;
import com.microsoft.bingads.v13.customermanagement.ICustomerManagementService;
import com.microsoft.bingads.v13.customermanagement.MapAccountIdToExternalAccountIdsRequest;
import com.microsoft.bingads.v13.customermanagement.MapAccountIdToExternalAccountIdsResponse;
import com.microsoft.bingads.v13.customermanagement.MapCustomerIdToExternalCustomerIdRequest;
import com.microsoft.bingads.v13.customermanagement.MapCustomerIdToExternalCustomerIdResponse;
import com.microsoft.bingads.v13.customermanagement.SearchAccountsRequest;
import com.microsoft.bingads.v13.customermanagement.SearchAccountsResponse;
import com.microsoft.bingads.v13.customermanagement.SearchClientLinksRequest;
import com.microsoft.bingads.v13.customermanagement.SearchClientLinksResponse;
import com.microsoft.bingads.v13.customermanagement.SearchCustomersRequest;
import com.microsoft.bingads.v13.customermanagement.SearchCustomersResponse;
import com.microsoft.bingads.v13.customermanagement.SearchUserInvitationsRequest;
import com.microsoft.bingads.v13.customermanagement.SearchUserInvitationsResponse;
import com.microsoft.bingads.v13.customermanagement.SendUserInvitationRequest;
import com.microsoft.bingads.v13.customermanagement.SendUserInvitationResponse;
import com.microsoft.bingads.v13.customermanagement.SignupCustomerRequest;
import com.microsoft.bingads.v13.customermanagement.SignupCustomerResponse;
import com.microsoft.bingads.v13.customermanagement.UpdateAccountRequest;
import com.microsoft.bingads.v13.customermanagement.UpdateAccountResponse;
import com.microsoft.bingads.v13.customermanagement.UpdateClientLinksRequest;
import com.microsoft.bingads.v13.customermanagement.UpdateClientLinksResponse;
import com.microsoft.bingads.v13.customermanagement.UpdateCustomerRequest;
import com.microsoft.bingads.v13.customermanagement.UpdateCustomerResponse;
import com.microsoft.bingads.v13.customermanagement.UpdatePrepayAccountRequest;
import com.microsoft.bingads.v13.customermanagement.UpdatePrepayAccountResponse;
import com.microsoft.bingads.v13.customermanagement.UpdateUserRequest;
import com.microsoft.bingads.v13.customermanagement.UpdateUserResponse;
import com.microsoft.bingads.v13.customermanagement.UpdateUserRolesRequest;
import com.microsoft.bingads.v13.customermanagement.UpdateUserRolesResponse;
import com.microsoft.bingads.v13.customermanagement.UpgradeCustomerToAgencyRequest;
import com.microsoft.bingads.v13.customermanagement.UpgradeCustomerToAgencyResponse;
import com.microsoft.bingads.v13.customermanagement.ValidateAddressRequest;
import com.microsoft.bingads.v13.customermanagement.ValidateAddressResponse;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class CustomerManagementService
extends RestfulServiceClient
implements ICustomerManagementService {
    private Supplier<ICustomerManagementService> fallbackService;

    public CustomerManagementService(Map<String, String> headers, ApiEnvironment env, Supplier<ICustomerManagementService> fallbackService) {
        super(headers, env, ICustomerManagementService.class);
        this.fallbackService = fallbackService;
    }

    Exception processFaultDetail(ApplicationFault faultDetail, boolean shouldThrow) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        String message = this.getFaultMessage(faultDetail.getTrackingId());
        if (faultDetail instanceof AdApiFaultDetail) {
            AdApiFaultDetail_Exception ex = new AdApiFaultDetail_Exception(message, (AdApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiFault) {
            ApiFault_Exception ex = new ApiFault_Exception(message, (ApiFault)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (shouldThrow) {
            throw new RuntimeException("Unknown fault type: " + faultDetail.getClass());
        }
        return null;
    }

    protected <Req, Resp> Resp sendRequest(Req request, String entityEndpoint, String verb, Class<Resp> respClass) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        ResponseInfo<Resp, ApplicationFault> responseInfo = this.getResponseInfo(request, entityEndpoint, verb, respClass, ApplicationFault.class);
        if (responseInfo == null) {
            return null;
        }
        ApplicationFault faultDetail = responseInfo.getFaultDetail();
        if (faultDetail != null) {
            this.processFaultDetail(faultDetail, true);
        }
        return responseInfo.getResponse();
    }

    private Exception getFaultException(ApplicationFault faultDetail) {
        try {
            Exception ex = this.processFaultDetail(faultDetail, false);
            return ex;
        }
        catch (Exception ex) {
            throw new InternalException(ex);
        }
    }

    protected <Req, Resp> Response<Resp> sendRequestAsync(Req request, String entityEndpoint, String verb, Class<Resp> respClass, BiFunction<Req, AsyncHandler<Resp>, Future<?>> soapMethod, AsyncHandler<Resp> handler) {
        return this.processRequestAsync(request, entityEndpoint, verb, respClass, ApplicationFault.class, x -> this.getFaultException((ApplicationFault)x), soapMethod, handler);
    }

    @Override
    public GetAccountsInfoResponse getAccountsInfo(GetAccountsInfoRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetAccountsInfoResponse response = this.sendRequest(request, "/AccountsInfo/Query", "POST", GetAccountsInfoResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getAccountsInfo(request);
        }
        return response;
    }

    @Override
    public Response<GetAccountsInfoResponse> getAccountsInfoAsync(GetAccountsInfoRequest request) {
        return this.sendRequestAsync(request, "/AccountsInfo/Query", "POST", GetAccountsInfoResponse.class, (r, h) -> this.fallbackService.get().getAccountsInfoAsync((GetAccountsInfoRequest)r, (AsyncHandler<GetAccountsInfoResponse>)h), null);
    }

    @Override
    public Future<?> getAccountsInfoAsync(GetAccountsInfoRequest request, AsyncHandler<GetAccountsInfoResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AccountsInfo/Query", "POST", GetAccountsInfoResponse.class, (r, h) -> this.fallbackService.get().getAccountsInfoAsync((GetAccountsInfoRequest)r, (AsyncHandler<GetAccountsInfoResponse>)h), asyncHandler);
    }

    @Override
    public FindAccountsResponse findAccounts(FindAccountsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        FindAccountsResponse response = this.sendRequest(request, "/Accounts/Find", "POST", FindAccountsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().findAccounts(request);
        }
        return response;
    }

    @Override
    public Response<FindAccountsResponse> findAccountsAsync(FindAccountsRequest request) {
        return this.sendRequestAsync(request, "/Accounts/Find", "POST", FindAccountsResponse.class, (r, h) -> this.fallbackService.get().findAccountsAsync((FindAccountsRequest)r, (AsyncHandler<FindAccountsResponse>)h), null);
    }

    @Override
    public Future<?> findAccountsAsync(FindAccountsRequest request, AsyncHandler<FindAccountsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Accounts/Find", "POST", FindAccountsResponse.class, (r, h) -> this.fallbackService.get().findAccountsAsync((FindAccountsRequest)r, (AsyncHandler<FindAccountsResponse>)h), asyncHandler);
    }

    @Override
    public AddAccountResponse addAccount(AddAccountRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        AddAccountResponse response = this.sendRequest(request, "/Account", "POST", AddAccountResponse.class);
        if (response == null) {
            response = this.fallbackService.get().addAccount(request);
        }
        return response;
    }

    @Override
    public Response<AddAccountResponse> addAccountAsync(AddAccountRequest request) {
        return this.sendRequestAsync(request, "/Account", "POST", AddAccountResponse.class, (r, h) -> this.fallbackService.get().addAccountAsync((AddAccountRequest)r, (AsyncHandler<AddAccountResponse>)h), null);
    }

    @Override
    public Future<?> addAccountAsync(AddAccountRequest request, AsyncHandler<AddAccountResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Account", "POST", AddAccountResponse.class, (r, h) -> this.fallbackService.get().addAccountAsync((AddAccountRequest)r, (AsyncHandler<AddAccountResponse>)h), asyncHandler);
    }

    @Override
    public UpdateAccountResponse updateAccount(UpdateAccountRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        UpdateAccountResponse response = this.sendRequest(request, "/Account", "PUT", UpdateAccountResponse.class);
        if (response == null) {
            response = this.fallbackService.get().updateAccount(request);
        }
        return response;
    }

    @Override
    public Response<UpdateAccountResponse> updateAccountAsync(UpdateAccountRequest request) {
        return this.sendRequestAsync(request, "/Account", "PUT", UpdateAccountResponse.class, (r, h) -> this.fallbackService.get().updateAccountAsync((UpdateAccountRequest)r, (AsyncHandler<UpdateAccountResponse>)h), null);
    }

    @Override
    public Future<?> updateAccountAsync(UpdateAccountRequest request, AsyncHandler<UpdateAccountResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Account", "PUT", UpdateAccountResponse.class, (r, h) -> this.fallbackService.get().updateAccountAsync((UpdateAccountRequest)r, (AsyncHandler<UpdateAccountResponse>)h), asyncHandler);
    }

    @Override
    public GetCustomerResponse getCustomer(GetCustomerRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetCustomerResponse response = this.sendRequest(request, "/Customer/Query", "POST", GetCustomerResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getCustomer(request);
        }
        return response;
    }

    @Override
    public Response<GetCustomerResponse> getCustomerAsync(GetCustomerRequest request) {
        return this.sendRequestAsync(request, "/Customer/Query", "POST", GetCustomerResponse.class, (r, h) -> this.fallbackService.get().getCustomerAsync((GetCustomerRequest)r, (AsyncHandler<GetCustomerResponse>)h), null);
    }

    @Override
    public Future<?> getCustomerAsync(GetCustomerRequest request, AsyncHandler<GetCustomerResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Customer/Query", "POST", GetCustomerResponse.class, (r, h) -> this.fallbackService.get().getCustomerAsync((GetCustomerRequest)r, (AsyncHandler<GetCustomerResponse>)h), asyncHandler);
    }

    @Override
    public UpdateCustomerResponse updateCustomer(UpdateCustomerRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        UpdateCustomerResponse response = this.sendRequest(request, "/Customer", "PUT", UpdateCustomerResponse.class);
        if (response == null) {
            response = this.fallbackService.get().updateCustomer(request);
        }
        return response;
    }

    @Override
    public Response<UpdateCustomerResponse> updateCustomerAsync(UpdateCustomerRequest request) {
        return this.sendRequestAsync(request, "/Customer", "PUT", UpdateCustomerResponse.class, (r, h) -> this.fallbackService.get().updateCustomerAsync((UpdateCustomerRequest)r, (AsyncHandler<UpdateCustomerResponse>)h), null);
    }

    @Override
    public Future<?> updateCustomerAsync(UpdateCustomerRequest request, AsyncHandler<UpdateCustomerResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Customer", "PUT", UpdateCustomerResponse.class, (r, h) -> this.fallbackService.get().updateCustomerAsync((UpdateCustomerRequest)r, (AsyncHandler<UpdateCustomerResponse>)h), asyncHandler);
    }

    @Override
    public SignupCustomerResponse signupCustomer(SignupCustomerRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SignupCustomerResponse response = this.sendRequest(request, "/Customer/Signup", "POST", SignupCustomerResponse.class);
        if (response == null) {
            response = this.fallbackService.get().signupCustomer(request);
        }
        return response;
    }

    @Override
    public Response<SignupCustomerResponse> signupCustomerAsync(SignupCustomerRequest request) {
        return this.sendRequestAsync(request, "/Customer/Signup", "POST", SignupCustomerResponse.class, (r, h) -> this.fallbackService.get().signupCustomerAsync((SignupCustomerRequest)r, (AsyncHandler<SignupCustomerResponse>)h), null);
    }

    @Override
    public Future<?> signupCustomerAsync(SignupCustomerRequest request, AsyncHandler<SignupCustomerResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Customer/Signup", "POST", SignupCustomerResponse.class, (r, h) -> this.fallbackService.get().signupCustomerAsync((SignupCustomerRequest)r, (AsyncHandler<SignupCustomerResponse>)h), asyncHandler);
    }

    @Override
    public GetAccountResponse getAccount(GetAccountRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetAccountResponse response = this.sendRequest(request, "/Account/Query", "POST", GetAccountResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getAccount(request);
        }
        return response;
    }

    @Override
    public Response<GetAccountResponse> getAccountAsync(GetAccountRequest request) {
        return this.sendRequestAsync(request, "/Account/Query", "POST", GetAccountResponse.class, (r, h) -> this.fallbackService.get().getAccountAsync((GetAccountRequest)r, (AsyncHandler<GetAccountResponse>)h), null);
    }

    @Override
    public Future<?> getAccountAsync(GetAccountRequest request, AsyncHandler<GetAccountResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Account/Query", "POST", GetAccountResponse.class, (r, h) -> this.fallbackService.get().getAccountAsync((GetAccountRequest)r, (AsyncHandler<GetAccountResponse>)h), asyncHandler);
    }

    @Override
    public GetCustomersInfoResponse getCustomersInfo(GetCustomersInfoRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetCustomersInfoResponse response = this.sendRequest(request, "/CustomersInfo/Query", "POST", GetCustomersInfoResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getCustomersInfo(request);
        }
        return response;
    }

    @Override
    public Response<GetCustomersInfoResponse> getCustomersInfoAsync(GetCustomersInfoRequest request) {
        return this.sendRequestAsync(request, "/CustomersInfo/Query", "POST", GetCustomersInfoResponse.class, (r, h) -> this.fallbackService.get().getCustomersInfoAsync((GetCustomersInfoRequest)r, (AsyncHandler<GetCustomersInfoResponse>)h), null);
    }

    @Override
    public Future<?> getCustomersInfoAsync(GetCustomersInfoRequest request, AsyncHandler<GetCustomersInfoResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/CustomersInfo/Query", "POST", GetCustomersInfoResponse.class, (r, h) -> this.fallbackService.get().getCustomersInfoAsync((GetCustomersInfoRequest)r, (AsyncHandler<GetCustomersInfoResponse>)h), asyncHandler);
    }

    @Override
    public DeleteAccountResponse deleteAccount(DeleteAccountRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        DeleteAccountResponse response = this.sendRequest(request, "/Account", "DELETE", DeleteAccountResponse.class);
        if (response == null) {
            response = this.fallbackService.get().deleteAccount(request);
        }
        return response;
    }

    @Override
    public Response<DeleteAccountResponse> deleteAccountAsync(DeleteAccountRequest request) {
        return this.sendRequestAsync(request, "/Account", "DELETE", DeleteAccountResponse.class, (r, h) -> this.fallbackService.get().deleteAccountAsync((DeleteAccountRequest)r, (AsyncHandler<DeleteAccountResponse>)h), null);
    }

    @Override
    public Future<?> deleteAccountAsync(DeleteAccountRequest request, AsyncHandler<DeleteAccountResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Account", "DELETE", DeleteAccountResponse.class, (r, h) -> this.fallbackService.get().deleteAccountAsync((DeleteAccountRequest)r, (AsyncHandler<DeleteAccountResponse>)h), asyncHandler);
    }

    @Override
    public DeleteCustomerResponse deleteCustomer(DeleteCustomerRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        DeleteCustomerResponse response = this.sendRequest(request, "/Customer", "DELETE", DeleteCustomerResponse.class);
        if (response == null) {
            response = this.fallbackService.get().deleteCustomer(request);
        }
        return response;
    }

    @Override
    public Response<DeleteCustomerResponse> deleteCustomerAsync(DeleteCustomerRequest request) {
        return this.sendRequestAsync(request, "/Customer", "DELETE", DeleteCustomerResponse.class, (r, h) -> this.fallbackService.get().deleteCustomerAsync((DeleteCustomerRequest)r, (AsyncHandler<DeleteCustomerResponse>)h), null);
    }

    @Override
    public Future<?> deleteCustomerAsync(DeleteCustomerRequest request, AsyncHandler<DeleteCustomerResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Customer", "DELETE", DeleteCustomerResponse.class, (r, h) -> this.fallbackService.get().deleteCustomerAsync((DeleteCustomerRequest)r, (AsyncHandler<DeleteCustomerResponse>)h), asyncHandler);
    }

    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        UpdateUserResponse response = this.sendRequest(request, "/User", "PUT", UpdateUserResponse.class);
        if (response == null) {
            response = this.fallbackService.get().updateUser(request);
        }
        return response;
    }

    @Override
    public Response<UpdateUserResponse> updateUserAsync(UpdateUserRequest request) {
        return this.sendRequestAsync(request, "/User", "PUT", UpdateUserResponse.class, (r, h) -> this.fallbackService.get().updateUserAsync((UpdateUserRequest)r, (AsyncHandler<UpdateUserResponse>)h), null);
    }

    @Override
    public Future<?> updateUserAsync(UpdateUserRequest request, AsyncHandler<UpdateUserResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/User", "PUT", UpdateUserResponse.class, (r, h) -> this.fallbackService.get().updateUserAsync((UpdateUserRequest)r, (AsyncHandler<UpdateUserResponse>)h), asyncHandler);
    }

    @Override
    public UpdateUserRolesResponse updateUserRoles(UpdateUserRolesRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        UpdateUserRolesResponse response = this.sendRequest(request, "/UserRoles", "PUT", UpdateUserRolesResponse.class);
        if (response == null) {
            response = this.fallbackService.get().updateUserRoles(request);
        }
        return response;
    }

    @Override
    public Response<UpdateUserRolesResponse> updateUserRolesAsync(UpdateUserRolesRequest request) {
        return this.sendRequestAsync(request, "/UserRoles", "PUT", UpdateUserRolesResponse.class, (r, h) -> this.fallbackService.get().updateUserRolesAsync((UpdateUserRolesRequest)r, (AsyncHandler<UpdateUserRolesResponse>)h), null);
    }

    @Override
    public Future<?> updateUserRolesAsync(UpdateUserRolesRequest request, AsyncHandler<UpdateUserRolesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/UserRoles", "PUT", UpdateUserRolesResponse.class, (r, h) -> this.fallbackService.get().updateUserRolesAsync((UpdateUserRolesRequest)r, (AsyncHandler<UpdateUserRolesResponse>)h), asyncHandler);
    }

    @Override
    public GetUserResponse getUser(GetUserRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetUserResponse response = this.sendRequest(request, "/User/Query", "POST", GetUserResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getUser(request);
        }
        return response;
    }

    @Override
    public Response<GetUserResponse> getUserAsync(GetUserRequest request) {
        return this.sendRequestAsync(request, "/User/Query", "POST", GetUserResponse.class, (r, h) -> this.fallbackService.get().getUserAsync((GetUserRequest)r, (AsyncHandler<GetUserResponse>)h), null);
    }

    @Override
    public Future<?> getUserAsync(GetUserRequest request, AsyncHandler<GetUserResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/User/Query", "POST", GetUserResponse.class, (r, h) -> this.fallbackService.get().getUserAsync((GetUserRequest)r, (AsyncHandler<GetUserResponse>)h), asyncHandler);
    }

    @Override
    public GetCurrentUserResponse getCurrentUser(GetCurrentUserRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetCurrentUserResponse response = this.sendRequest(request, "/CurrentUser/Query", "POST", GetCurrentUserResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getCurrentUser(request);
        }
        return response;
    }

    @Override
    public Response<GetCurrentUserResponse> getCurrentUserAsync(GetCurrentUserRequest request) {
        return this.sendRequestAsync(request, "/CurrentUser/Query", "POST", GetCurrentUserResponse.class, (r, h) -> this.fallbackService.get().getCurrentUserAsync((GetCurrentUserRequest)r, (AsyncHandler<GetCurrentUserResponse>)h), null);
    }

    @Override
    public Future<?> getCurrentUserAsync(GetCurrentUserRequest request, AsyncHandler<GetCurrentUserResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/CurrentUser/Query", "POST", GetCurrentUserResponse.class, (r, h) -> this.fallbackService.get().getCurrentUserAsync((GetCurrentUserRequest)r, (AsyncHandler<GetCurrentUserResponse>)h), asyncHandler);
    }

    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        DeleteUserResponse response = this.sendRequest(request, "/User", "DELETE", DeleteUserResponse.class);
        if (response == null) {
            response = this.fallbackService.get().deleteUser(request);
        }
        return response;
    }

    @Override
    public Response<DeleteUserResponse> deleteUserAsync(DeleteUserRequest request) {
        return this.sendRequestAsync(request, "/User", "DELETE", DeleteUserResponse.class, (r, h) -> this.fallbackService.get().deleteUserAsync((DeleteUserRequest)r, (AsyncHandler<DeleteUserResponse>)h), null);
    }

    @Override
    public Future<?> deleteUserAsync(DeleteUserRequest request, AsyncHandler<DeleteUserResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/User", "DELETE", DeleteUserResponse.class, (r, h) -> this.fallbackService.get().deleteUserAsync((DeleteUserRequest)r, (AsyncHandler<DeleteUserResponse>)h), asyncHandler);
    }

    @Override
    public GetUsersInfoResponse getUsersInfo(GetUsersInfoRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetUsersInfoResponse response = this.sendRequest(request, "/UsersInfo/Query", "POST", GetUsersInfoResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getUsersInfo(request);
        }
        return response;
    }

    @Override
    public Response<GetUsersInfoResponse> getUsersInfoAsync(GetUsersInfoRequest request) {
        return this.sendRequestAsync(request, "/UsersInfo/Query", "POST", GetUsersInfoResponse.class, (r, h) -> this.fallbackService.get().getUsersInfoAsync((GetUsersInfoRequest)r, (AsyncHandler<GetUsersInfoResponse>)h), null);
    }

    @Override
    public Future<?> getUsersInfoAsync(GetUsersInfoRequest request, AsyncHandler<GetUsersInfoResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/UsersInfo/Query", "POST", GetUsersInfoResponse.class, (r, h) -> this.fallbackService.get().getUsersInfoAsync((GetUsersInfoRequest)r, (AsyncHandler<GetUsersInfoResponse>)h), asyncHandler);
    }

    @Override
    public GetCustomerPilotFeaturesResponse getCustomerPilotFeatures(GetCustomerPilotFeaturesRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetCustomerPilotFeaturesResponse response = this.sendRequest(request, "/CustomerPilotFeatures/Query", "POST", GetCustomerPilotFeaturesResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getCustomerPilotFeatures(request);
        }
        return response;
    }

    @Override
    public Response<GetCustomerPilotFeaturesResponse> getCustomerPilotFeaturesAsync(GetCustomerPilotFeaturesRequest request) {
        return this.sendRequestAsync(request, "/CustomerPilotFeatures/Query", "POST", GetCustomerPilotFeaturesResponse.class, (r, h) -> this.fallbackService.get().getCustomerPilotFeaturesAsync((GetCustomerPilotFeaturesRequest)r, (AsyncHandler<GetCustomerPilotFeaturesResponse>)h), null);
    }

    @Override
    public Future<?> getCustomerPilotFeaturesAsync(GetCustomerPilotFeaturesRequest request, AsyncHandler<GetCustomerPilotFeaturesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/CustomerPilotFeatures/Query", "POST", GetCustomerPilotFeaturesResponse.class, (r, h) -> this.fallbackService.get().getCustomerPilotFeaturesAsync((GetCustomerPilotFeaturesRequest)r, (AsyncHandler<GetCustomerPilotFeaturesResponse>)h), asyncHandler);
    }

    @Override
    public GetAccountPilotFeaturesResponse getAccountPilotFeatures(GetAccountPilotFeaturesRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetAccountPilotFeaturesResponse response = this.sendRequest(request, "/AccountPilotFeatures/Query", "POST", GetAccountPilotFeaturesResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getAccountPilotFeatures(request);
        }
        return response;
    }

    @Override
    public Response<GetAccountPilotFeaturesResponse> getAccountPilotFeaturesAsync(GetAccountPilotFeaturesRequest request) {
        return this.sendRequestAsync(request, "/AccountPilotFeatures/Query", "POST", GetAccountPilotFeaturesResponse.class, (r, h) -> this.fallbackService.get().getAccountPilotFeaturesAsync((GetAccountPilotFeaturesRequest)r, (AsyncHandler<GetAccountPilotFeaturesResponse>)h), null);
    }

    @Override
    public Future<?> getAccountPilotFeaturesAsync(GetAccountPilotFeaturesRequest request, AsyncHandler<GetAccountPilotFeaturesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AccountPilotFeatures/Query", "POST", GetAccountPilotFeaturesResponse.class, (r, h) -> this.fallbackService.get().getAccountPilotFeaturesAsync((GetAccountPilotFeaturesRequest)r, (AsyncHandler<GetAccountPilotFeaturesResponse>)h), asyncHandler);
    }

    @Override
    public GetPilotFeaturesCountriesResponse getPilotFeaturesCountries(GetPilotFeaturesCountriesRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetPilotFeaturesCountriesResponse response = this.sendRequest(request, "/PilotFeaturesCountries/Query", "POST", GetPilotFeaturesCountriesResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getPilotFeaturesCountries(request);
        }
        return response;
    }

    @Override
    public Response<GetPilotFeaturesCountriesResponse> getPilotFeaturesCountriesAsync(GetPilotFeaturesCountriesRequest request) {
        return this.sendRequestAsync(request, "/PilotFeaturesCountries/Query", "POST", GetPilotFeaturesCountriesResponse.class, (r, h) -> this.fallbackService.get().getPilotFeaturesCountriesAsync((GetPilotFeaturesCountriesRequest)r, (AsyncHandler<GetPilotFeaturesCountriesResponse>)h), null);
    }

    @Override
    public Future<?> getPilotFeaturesCountriesAsync(GetPilotFeaturesCountriesRequest request, AsyncHandler<GetPilotFeaturesCountriesResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/PilotFeaturesCountries/Query", "POST", GetPilotFeaturesCountriesResponse.class, (r, h) -> this.fallbackService.get().getPilotFeaturesCountriesAsync((GetPilotFeaturesCountriesRequest)r, (AsyncHandler<GetPilotFeaturesCountriesResponse>)h), asyncHandler);
    }

    @Override
    public GetAccessibleCustomerResponse getAccessibleCustomer(GetAccessibleCustomerRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetAccessibleCustomerResponse response = this.sendRequest(request, "/AccessibleCustomer/Query", "POST", GetAccessibleCustomerResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getAccessibleCustomer(request);
        }
        return response;
    }

    @Override
    public Response<GetAccessibleCustomerResponse> getAccessibleCustomerAsync(GetAccessibleCustomerRequest request) {
        return this.sendRequestAsync(request, "/AccessibleCustomer/Query", "POST", GetAccessibleCustomerResponse.class, (r, h) -> this.fallbackService.get().getAccessibleCustomerAsync((GetAccessibleCustomerRequest)r, (AsyncHandler<GetAccessibleCustomerResponse>)h), null);
    }

    @Override
    public Future<?> getAccessibleCustomerAsync(GetAccessibleCustomerRequest request, AsyncHandler<GetAccessibleCustomerResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AccessibleCustomer/Query", "POST", GetAccessibleCustomerResponse.class, (r, h) -> this.fallbackService.get().getAccessibleCustomerAsync((GetAccessibleCustomerRequest)r, (AsyncHandler<GetAccessibleCustomerResponse>)h), asyncHandler);
    }

    @Override
    public FindAccountsOrCustomersInfoResponse findAccountsOrCustomersInfo(FindAccountsOrCustomersInfoRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        FindAccountsOrCustomersInfoResponse response = this.sendRequest(request, "/AccountsOrCustomersInfo/Find", "POST", FindAccountsOrCustomersInfoResponse.class);
        if (response == null) {
            response = this.fallbackService.get().findAccountsOrCustomersInfo(request);
        }
        return response;
    }

    @Override
    public Response<FindAccountsOrCustomersInfoResponse> findAccountsOrCustomersInfoAsync(FindAccountsOrCustomersInfoRequest request) {
        return this.sendRequestAsync(request, "/AccountsOrCustomersInfo/Find", "POST", FindAccountsOrCustomersInfoResponse.class, (r, h) -> this.fallbackService.get().findAccountsOrCustomersInfoAsync((FindAccountsOrCustomersInfoRequest)r, (AsyncHandler<FindAccountsOrCustomersInfoResponse>)h), null);
    }

    @Override
    public Future<?> findAccountsOrCustomersInfoAsync(FindAccountsOrCustomersInfoRequest request, AsyncHandler<FindAccountsOrCustomersInfoResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AccountsOrCustomersInfo/Find", "POST", FindAccountsOrCustomersInfoResponse.class, (r, h) -> this.fallbackService.get().findAccountsOrCustomersInfoAsync((FindAccountsOrCustomersInfoRequest)r, (AsyncHandler<FindAccountsOrCustomersInfoResponse>)h), asyncHandler);
    }

    @Override
    public UpgradeCustomerToAgencyResponse upgradeCustomerToAgency(UpgradeCustomerToAgencyRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        UpgradeCustomerToAgencyResponse response = this.sendRequest(request, "/Customer/UpgradeToAgency", "POST", UpgradeCustomerToAgencyResponse.class);
        if (response == null) {
            response = this.fallbackService.get().upgradeCustomerToAgency(request);
        }
        return response;
    }

    @Override
    public Response<UpgradeCustomerToAgencyResponse> upgradeCustomerToAgencyAsync(UpgradeCustomerToAgencyRequest request) {
        return this.sendRequestAsync(request, "/Customer/UpgradeToAgency", "POST", UpgradeCustomerToAgencyResponse.class, (r, h) -> this.fallbackService.get().upgradeCustomerToAgencyAsync((UpgradeCustomerToAgencyRequest)r, (AsyncHandler<UpgradeCustomerToAgencyResponse>)h), null);
    }

    @Override
    public Future<?> upgradeCustomerToAgencyAsync(UpgradeCustomerToAgencyRequest request, AsyncHandler<UpgradeCustomerToAgencyResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Customer/UpgradeToAgency", "POST", UpgradeCustomerToAgencyResponse.class, (r, h) -> this.fallbackService.get().upgradeCustomerToAgencyAsync((UpgradeCustomerToAgencyRequest)r, (AsyncHandler<UpgradeCustomerToAgencyResponse>)h), asyncHandler);
    }

    @Override
    public AddPrepayAccountResponse addPrepayAccount(AddPrepayAccountRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        AddPrepayAccountResponse response = this.sendRequest(request, "/PrepayAccount", "POST", AddPrepayAccountResponse.class);
        if (response == null) {
            response = this.fallbackService.get().addPrepayAccount(request);
        }
        return response;
    }

    @Override
    public Response<AddPrepayAccountResponse> addPrepayAccountAsync(AddPrepayAccountRequest request) {
        return this.sendRequestAsync(request, "/PrepayAccount", "POST", AddPrepayAccountResponse.class, (r, h) -> this.fallbackService.get().addPrepayAccountAsync((AddPrepayAccountRequest)r, (AsyncHandler<AddPrepayAccountResponse>)h), null);
    }

    @Override
    public Future<?> addPrepayAccountAsync(AddPrepayAccountRequest request, AsyncHandler<AddPrepayAccountResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/PrepayAccount", "POST", AddPrepayAccountResponse.class, (r, h) -> this.fallbackService.get().addPrepayAccountAsync((AddPrepayAccountRequest)r, (AsyncHandler<AddPrepayAccountResponse>)h), asyncHandler);
    }

    @Override
    public UpdatePrepayAccountResponse updatePrepayAccount(UpdatePrepayAccountRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        UpdatePrepayAccountResponse response = this.sendRequest(request, "/PrepayAccount", "PUT", UpdatePrepayAccountResponse.class);
        if (response == null) {
            response = this.fallbackService.get().updatePrepayAccount(request);
        }
        return response;
    }

    @Override
    public Response<UpdatePrepayAccountResponse> updatePrepayAccountAsync(UpdatePrepayAccountRequest request) {
        return this.sendRequestAsync(request, "/PrepayAccount", "PUT", UpdatePrepayAccountResponse.class, (r, h) -> this.fallbackService.get().updatePrepayAccountAsync((UpdatePrepayAccountRequest)r, (AsyncHandler<UpdatePrepayAccountResponse>)h), null);
    }

    @Override
    public Future<?> updatePrepayAccountAsync(UpdatePrepayAccountRequest request, AsyncHandler<UpdatePrepayAccountResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/PrepayAccount", "PUT", UpdatePrepayAccountResponse.class, (r, h) -> this.fallbackService.get().updatePrepayAccountAsync((UpdatePrepayAccountRequest)r, (AsyncHandler<UpdatePrepayAccountResponse>)h), asyncHandler);
    }

    @Override
    public MapCustomerIdToExternalCustomerIdResponse mapCustomerIdToExternalCustomerId(MapCustomerIdToExternalCustomerIdRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        MapCustomerIdToExternalCustomerIdResponse response = this.sendRequest(request, "/CustomerId/MapToExternalCustomerId", "POST", MapCustomerIdToExternalCustomerIdResponse.class);
        if (response == null) {
            response = this.fallbackService.get().mapCustomerIdToExternalCustomerId(request);
        }
        return response;
    }

    @Override
    public Response<MapCustomerIdToExternalCustomerIdResponse> mapCustomerIdToExternalCustomerIdAsync(MapCustomerIdToExternalCustomerIdRequest request) {
        return this.sendRequestAsync(request, "/CustomerId/MapToExternalCustomerId", "POST", MapCustomerIdToExternalCustomerIdResponse.class, (r, h) -> this.fallbackService.get().mapCustomerIdToExternalCustomerIdAsync((MapCustomerIdToExternalCustomerIdRequest)r, (AsyncHandler<MapCustomerIdToExternalCustomerIdResponse>)h), null);
    }

    @Override
    public Future<?> mapCustomerIdToExternalCustomerIdAsync(MapCustomerIdToExternalCustomerIdRequest request, AsyncHandler<MapCustomerIdToExternalCustomerIdResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/CustomerId/MapToExternalCustomerId", "POST", MapCustomerIdToExternalCustomerIdResponse.class, (r, h) -> this.fallbackService.get().mapCustomerIdToExternalCustomerIdAsync((MapCustomerIdToExternalCustomerIdRequest)r, (AsyncHandler<MapCustomerIdToExternalCustomerIdResponse>)h), asyncHandler);
    }

    @Override
    public MapAccountIdToExternalAccountIdsResponse mapAccountIdToExternalAccountIds(MapAccountIdToExternalAccountIdsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        MapAccountIdToExternalAccountIdsResponse response = this.sendRequest(request, "/AccountId/MapToExternalAccountIds", "POST", MapAccountIdToExternalAccountIdsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().mapAccountIdToExternalAccountIds(request);
        }
        return response;
    }

    @Override
    public Response<MapAccountIdToExternalAccountIdsResponse> mapAccountIdToExternalAccountIdsAsync(MapAccountIdToExternalAccountIdsRequest request) {
        return this.sendRequestAsync(request, "/AccountId/MapToExternalAccountIds", "POST", MapAccountIdToExternalAccountIdsResponse.class, (r, h) -> this.fallbackService.get().mapAccountIdToExternalAccountIdsAsync((MapAccountIdToExternalAccountIdsRequest)r, (AsyncHandler<MapAccountIdToExternalAccountIdsResponse>)h), null);
    }

    @Override
    public Future<?> mapAccountIdToExternalAccountIdsAsync(MapAccountIdToExternalAccountIdsRequest request, AsyncHandler<MapAccountIdToExternalAccountIdsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AccountId/MapToExternalAccountIds", "POST", MapAccountIdToExternalAccountIdsResponse.class, (r, h) -> this.fallbackService.get().mapAccountIdToExternalAccountIdsAsync((MapAccountIdToExternalAccountIdsRequest)r, (AsyncHandler<MapAccountIdToExternalAccountIdsResponse>)h), asyncHandler);
    }

    @Override
    public SearchCustomersResponse searchCustomers(SearchCustomersRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SearchCustomersResponse response = this.sendRequest(request, "/Customers/Search", "POST", SearchCustomersResponse.class);
        if (response == null) {
            response = this.fallbackService.get().searchCustomers(request);
        }
        return response;
    }

    @Override
    public Response<SearchCustomersResponse> searchCustomersAsync(SearchCustomersRequest request) {
        return this.sendRequestAsync(request, "/Customers/Search", "POST", SearchCustomersResponse.class, (r, h) -> this.fallbackService.get().searchCustomersAsync((SearchCustomersRequest)r, (AsyncHandler<SearchCustomersResponse>)h), null);
    }

    @Override
    public Future<?> searchCustomersAsync(SearchCustomersRequest request, AsyncHandler<SearchCustomersResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Customers/Search", "POST", SearchCustomersResponse.class, (r, h) -> this.fallbackService.get().searchCustomersAsync((SearchCustomersRequest)r, (AsyncHandler<SearchCustomersResponse>)h), asyncHandler);
    }

    @Override
    public AddClientLinksResponse addClientLinks(AddClientLinksRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        AddClientLinksResponse response = this.sendRequest(request, "/ClientLinks", "POST", AddClientLinksResponse.class);
        if (response == null) {
            response = this.fallbackService.get().addClientLinks(request);
        }
        return response;
    }

    @Override
    public Response<AddClientLinksResponse> addClientLinksAsync(AddClientLinksRequest request) {
        return this.sendRequestAsync(request, "/ClientLinks", "POST", AddClientLinksResponse.class, (r, h) -> this.fallbackService.get().addClientLinksAsync((AddClientLinksRequest)r, (AsyncHandler<AddClientLinksResponse>)h), null);
    }

    @Override
    public Future<?> addClientLinksAsync(AddClientLinksRequest request, AsyncHandler<AddClientLinksResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/ClientLinks", "POST", AddClientLinksResponse.class, (r, h) -> this.fallbackService.get().addClientLinksAsync((AddClientLinksRequest)r, (AsyncHandler<AddClientLinksResponse>)h), asyncHandler);
    }

    @Override
    public UpdateClientLinksResponse updateClientLinks(UpdateClientLinksRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        UpdateClientLinksResponse response = this.sendRequest(request, "/ClientLinks", "PUT", UpdateClientLinksResponse.class);
        if (response == null) {
            response = this.fallbackService.get().updateClientLinks(request);
        }
        return response;
    }

    @Override
    public Response<UpdateClientLinksResponse> updateClientLinksAsync(UpdateClientLinksRequest request) {
        return this.sendRequestAsync(request, "/ClientLinks", "PUT", UpdateClientLinksResponse.class, (r, h) -> this.fallbackService.get().updateClientLinksAsync((UpdateClientLinksRequest)r, (AsyncHandler<UpdateClientLinksResponse>)h), null);
    }

    @Override
    public Future<?> updateClientLinksAsync(UpdateClientLinksRequest request, AsyncHandler<UpdateClientLinksResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/ClientLinks", "PUT", UpdateClientLinksResponse.class, (r, h) -> this.fallbackService.get().updateClientLinksAsync((UpdateClientLinksRequest)r, (AsyncHandler<UpdateClientLinksResponse>)h), asyncHandler);
    }

    @Override
    public SearchClientLinksResponse searchClientLinks(SearchClientLinksRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SearchClientLinksResponse response = this.sendRequest(request, "/ClientLinks/Search", "POST", SearchClientLinksResponse.class);
        if (response == null) {
            response = this.fallbackService.get().searchClientLinks(request);
        }
        return response;
    }

    @Override
    public Response<SearchClientLinksResponse> searchClientLinksAsync(SearchClientLinksRequest request) {
        return this.sendRequestAsync(request, "/ClientLinks/Search", "POST", SearchClientLinksResponse.class, (r, h) -> this.fallbackService.get().searchClientLinksAsync((SearchClientLinksRequest)r, (AsyncHandler<SearchClientLinksResponse>)h), null);
    }

    @Override
    public Future<?> searchClientLinksAsync(SearchClientLinksRequest request, AsyncHandler<SearchClientLinksResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/ClientLinks/Search", "POST", SearchClientLinksResponse.class, (r, h) -> this.fallbackService.get().searchClientLinksAsync((SearchClientLinksRequest)r, (AsyncHandler<SearchClientLinksResponse>)h), asyncHandler);
    }

    @Override
    public SearchAccountsResponse searchAccounts(SearchAccountsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SearchAccountsResponse response = this.sendRequest(request, "/Accounts/Search", "POST", SearchAccountsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().searchAccounts(request);
        }
        return response;
    }

    @Override
    public Response<SearchAccountsResponse> searchAccountsAsync(SearchAccountsRequest request) {
        return this.sendRequestAsync(request, "/Accounts/Search", "POST", SearchAccountsResponse.class, (r, h) -> this.fallbackService.get().searchAccountsAsync((SearchAccountsRequest)r, (AsyncHandler<SearchAccountsResponse>)h), null);
    }

    @Override
    public Future<?> searchAccountsAsync(SearchAccountsRequest request, AsyncHandler<SearchAccountsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Accounts/Search", "POST", SearchAccountsResponse.class, (r, h) -> this.fallbackService.get().searchAccountsAsync((SearchAccountsRequest)r, (AsyncHandler<SearchAccountsResponse>)h), asyncHandler);
    }

    @Override
    public SendUserInvitationResponse sendUserInvitation(SendUserInvitationRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SendUserInvitationResponse response = this.sendRequest(request, "/UserInvitation/Send", "POST", SendUserInvitationResponse.class);
        if (response == null) {
            response = this.fallbackService.get().sendUserInvitation(request);
        }
        return response;
    }

    @Override
    public Response<SendUserInvitationResponse> sendUserInvitationAsync(SendUserInvitationRequest request) {
        return this.sendRequestAsync(request, "/UserInvitation/Send", "POST", SendUserInvitationResponse.class, (r, h) -> this.fallbackService.get().sendUserInvitationAsync((SendUserInvitationRequest)r, (AsyncHandler<SendUserInvitationResponse>)h), null);
    }

    @Override
    public Future<?> sendUserInvitationAsync(SendUserInvitationRequest request, AsyncHandler<SendUserInvitationResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/UserInvitation/Send", "POST", SendUserInvitationResponse.class, (r, h) -> this.fallbackService.get().sendUserInvitationAsync((SendUserInvitationRequest)r, (AsyncHandler<SendUserInvitationResponse>)h), asyncHandler);
    }

    @Override
    public SearchUserInvitationsResponse searchUserInvitations(SearchUserInvitationsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SearchUserInvitationsResponse response = this.sendRequest(request, "/UserInvitations/Search", "POST", SearchUserInvitationsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().searchUserInvitations(request);
        }
        return response;
    }

    @Override
    public Response<SearchUserInvitationsResponse> searchUserInvitationsAsync(SearchUserInvitationsRequest request) {
        return this.sendRequestAsync(request, "/UserInvitations/Search", "POST", SearchUserInvitationsResponse.class, (r, h) -> this.fallbackService.get().searchUserInvitationsAsync((SearchUserInvitationsRequest)r, (AsyncHandler<SearchUserInvitationsResponse>)h), null);
    }

    @Override
    public Future<?> searchUserInvitationsAsync(SearchUserInvitationsRequest request, AsyncHandler<SearchUserInvitationsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/UserInvitations/Search", "POST", SearchUserInvitationsResponse.class, (r, h) -> this.fallbackService.get().searchUserInvitationsAsync((SearchUserInvitationsRequest)r, (AsyncHandler<SearchUserInvitationsResponse>)h), asyncHandler);
    }

    @Override
    public ValidateAddressResponse validateAddress(ValidateAddressRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        ValidateAddressResponse response = this.sendRequest(request, "/Address/Validate", "POST", ValidateAddressResponse.class);
        if (response == null) {
            response = this.fallbackService.get().validateAddress(request);
        }
        return response;
    }

    @Override
    public Response<ValidateAddressResponse> validateAddressAsync(ValidateAddressRequest request) {
        return this.sendRequestAsync(request, "/Address/Validate", "POST", ValidateAddressResponse.class, (r, h) -> this.fallbackService.get().validateAddressAsync((ValidateAddressRequest)r, (AsyncHandler<ValidateAddressResponse>)h), null);
    }

    @Override
    public Future<?> validateAddressAsync(ValidateAddressRequest request, AsyncHandler<ValidateAddressResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Address/Validate", "POST", ValidateAddressResponse.class, (r, h) -> this.fallbackService.get().validateAddressAsync((ValidateAddressRequest)r, (AsyncHandler<ValidateAddressResponse>)h), asyncHandler);
    }

    @Override
    public GetLinkedAccountsAndCustomersInfoResponse getLinkedAccountsAndCustomersInfo(GetLinkedAccountsAndCustomersInfoRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetLinkedAccountsAndCustomersInfoResponse response = this.sendRequest(request, "/LinkedAccountsAndCustomersInfo/Query", "POST", GetLinkedAccountsAndCustomersInfoResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getLinkedAccountsAndCustomersInfo(request);
        }
        return response;
    }

    @Override
    public Response<GetLinkedAccountsAndCustomersInfoResponse> getLinkedAccountsAndCustomersInfoAsync(GetLinkedAccountsAndCustomersInfoRequest request) {
        return this.sendRequestAsync(request, "/LinkedAccountsAndCustomersInfo/Query", "POST", GetLinkedAccountsAndCustomersInfoResponse.class, (r, h) -> this.fallbackService.get().getLinkedAccountsAndCustomersInfoAsync((GetLinkedAccountsAndCustomersInfoRequest)r, (AsyncHandler<GetLinkedAccountsAndCustomersInfoResponse>)h), null);
    }

    @Override
    public Future<?> getLinkedAccountsAndCustomersInfoAsync(GetLinkedAccountsAndCustomersInfoRequest request, AsyncHandler<GetLinkedAccountsAndCustomersInfoResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/LinkedAccountsAndCustomersInfo/Query", "POST", GetLinkedAccountsAndCustomersInfoResponse.class, (r, h) -> this.fallbackService.get().getLinkedAccountsAndCustomersInfoAsync((GetLinkedAccountsAndCustomersInfoRequest)r, (AsyncHandler<GetLinkedAccountsAndCustomersInfoResponse>)h), asyncHandler);
    }

    @Override
    public GetUserMFAStatusResponse getUserMFAStatus(GetUserMFAStatusRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetUserMFAStatusResponse response = this.sendRequest(request, "/UserMFAStatus/Query", "POST", GetUserMFAStatusResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getUserMFAStatus(request);
        }
        return response;
    }

    @Override
    public Response<GetUserMFAStatusResponse> getUserMFAStatusAsync(GetUserMFAStatusRequest request) {
        return this.sendRequestAsync(request, "/UserMFAStatus/Query", "POST", GetUserMFAStatusResponse.class, (r, h) -> this.fallbackService.get().getUserMFAStatusAsync((GetUserMFAStatusRequest)r, (AsyncHandler<GetUserMFAStatusResponse>)h), null);
    }

    @Override
    public Future<?> getUserMFAStatusAsync(GetUserMFAStatusRequest request, AsyncHandler<GetUserMFAStatusResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/UserMFAStatus/Query", "POST", GetUserMFAStatusResponse.class, (r, h) -> this.fallbackService.get().getUserMFAStatusAsync((GetUserMFAStatusRequest)r, (AsyncHandler<GetUserMFAStatusResponse>)h), asyncHandler);
    }

    @Override
    public GetNotificationsResponse getNotifications(GetNotificationsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetNotificationsResponse response = this.sendRequest(request, "/Notifications/Query", "POST", GetNotificationsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getNotifications(request);
        }
        return response;
    }

    @Override
    public Response<GetNotificationsResponse> getNotificationsAsync(GetNotificationsRequest request) {
        return this.sendRequestAsync(request, "/Notifications/Query", "POST", GetNotificationsResponse.class, (r, h) -> this.fallbackService.get().getNotificationsAsync((GetNotificationsRequest)r, (AsyncHandler<GetNotificationsResponse>)h), null);
    }

    @Override
    public Future<?> getNotificationsAsync(GetNotificationsRequest request, AsyncHandler<GetNotificationsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Notifications/Query", "POST", GetNotificationsResponse.class, (r, h) -> this.fallbackService.get().getNotificationsAsync((GetNotificationsRequest)r, (AsyncHandler<GetNotificationsResponse>)h), asyncHandler);
    }

    @Override
    public DismissNotificationsResponse dismissNotifications(DismissNotificationsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        DismissNotificationsResponse response = this.sendRequest(request, "/Notifications/Dismiss", "POST", DismissNotificationsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().dismissNotifications(request);
        }
        return response;
    }

    @Override
    public Response<DismissNotificationsResponse> dismissNotificationsAsync(DismissNotificationsRequest request) {
        return this.sendRequestAsync(request, "/Notifications/Dismiss", "POST", DismissNotificationsResponse.class, (r, h) -> this.fallbackService.get().dismissNotificationsAsync((DismissNotificationsRequest)r, (AsyncHandler<DismissNotificationsResponse>)h), null);
    }

    @Override
    public Future<?> dismissNotificationsAsync(DismissNotificationsRequest request, AsyncHandler<DismissNotificationsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Notifications/Dismiss", "POST", DismissNotificationsResponse.class, (r, h) -> this.fallbackService.get().dismissNotificationsAsync((DismissNotificationsRequest)r, (AsyncHandler<DismissNotificationsResponse>)h), asyncHandler);
    }
}

