/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOflong;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.FlyerAdExtension;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkFlyerAdExtension
extends BulkAdExtension<FlyerAdExtension> {
    private static final List<BulkMapping<BulkFlyerAdExtension>> MAPPINGS;

    public FlyerAdExtension getFlyerAdExtension() {
        return (FlyerAdExtension)this.getAdExtension();
    }

    public void setFlyerAdExtension(FlyerAdExtension FlyerAdExtension2) {
        this.setAdExtension(FlyerAdExtension2);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        FlyerAdExtension extension = new FlyerAdExtension();
        extension.setType("FlyerAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getFlyerAdExtension(), "FlyerAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkFlyerAdExtension, Object>> m = new ArrayList<SimpleBulkMapping<BulkFlyerAdExtension, Object>>();
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, String>("Flyer Name", new Function<BulkFlyerAdExtension, String>(){

            @Override
            public String apply(BulkFlyerAdExtension c) {
                return c.getFlyerAdExtension().getFlyerName();
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                c.getFlyerAdExtension().setFlyerName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, String>("Description", new Function<BulkFlyerAdExtension, String>(){

            @Override
            public String apply(BulkFlyerAdExtension c) {
                return c.getFlyerAdExtension().getDescription();
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                c.getFlyerAdExtension().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, Long>("Store Id", new Function<BulkFlyerAdExtension, Long>(){

            @Override
            public Long apply(BulkFlyerAdExtension c) {
                return c.getFlyerAdExtension().getStoreId();
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                c.getFlyerAdExtension().setStoreId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, String>("Media Ids", new Function<BulkFlyerAdExtension, String>(){

            @Override
            public String apply(BulkFlyerAdExtension c) {
                return StringExtensions.toIdListBulkString(";", c.getFlyerAdExtension().getImageMediaIds());
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                ArrayOflong ids = new ArrayOflong();
                List<Long> idArray = StringExtensions.parseIdList(v);
                if (idArray == null) {
                    ids = null;
                } else {
                    ids.getLongs().addAll(idArray);
                }
                c.getFlyerAdExtension().setImageMediaIds(ids);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, String>("Media Urls", new Function<BulkFlyerAdExtension, String>(){

            @Override
            public String apply(BulkFlyerAdExtension c) {
                return StringExtensions.writeUrls("; ", ((FlyerAdExtension)c.getAdExtension()).getImageMediaUrls(), ((FlyerAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((FlyerAdExtension)c.getAdExtension()).setImageMediaUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, String>("Final Url", new Function<BulkFlyerAdExtension, String>(){

            @Override
            public String apply(BulkFlyerAdExtension c) {
                return StringExtensions.writeUrls("; ", ((FlyerAdExtension)c.getAdExtension()).getFinalUrls(), ((FlyerAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((FlyerAdExtension)c.getAdExtension()).setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, String>("Mobile Final Url", new Function<BulkFlyerAdExtension, String>(){

            @Override
            public String apply(BulkFlyerAdExtension c) {
                return StringExtensions.writeUrls("; ", ((FlyerAdExtension)c.getAdExtension()).getFinalMobileUrls(), ((FlyerAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((FlyerAdExtension)c.getAdExtension()).setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, String>("Tracking Template", new Function<BulkFlyerAdExtension, String>(){

            @Override
            public String apply(BulkFlyerAdExtension c) {
                return StringExtensions.toOptionalBulkString(((FlyerAdExtension)c.getAdExtension()).getTrackingUrlTemplate(), ((FlyerAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                ((FlyerAdExtension)c.getAdExtension()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, String>("Custom Parameter", new Function<BulkFlyerAdExtension, String>(){

            @Override
            public String apply(BulkFlyerAdExtension c) {
                return StringExtensions.toCustomParaBulkString(((FlyerAdExtension)c.getAdExtension()).getUrlCustomParameters(), ((FlyerAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                try {
                    ((FlyerAdExtension)c.getAdExtension()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkFlyerAdExtension, String>("Final Url Suffix", new Function<BulkFlyerAdExtension, String>(){

            @Override
            public String apply(BulkFlyerAdExtension c) {
                return StringExtensions.toOptionalBulkString(((FlyerAdExtension)c.getAdExtension()).getFinalUrlSuffix(), ((FlyerAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFlyerAdExtension>(){

            @Override
            public void accept(String v, BulkFlyerAdExtension c) {
                ((FlyerAdExtension)c.getAdExtension()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

