/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful.adaptor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.microsoft.bingads.internal.restful.adaptor.AdaptorUtil;
import java.io.IOException;

public class EnumSerializer
extends StdSerializer<Enum<?>>
implements ContextualSerializer {
    private Class<?> enumClass;

    public EnumSerializer() {
        super(Enum.class, false);
    }

    public EnumSerializer(Class<?> enumClass) {
        super(enumClass, false);
        this.enumClass = enumClass;
    }

    public void serialize(Enum<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeObject((Object)AdaptorUtil.toCamelcase(value));
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Class enumClass = property.getType().getRawClass();
        return new EnumSerializer(enumClass);
    }
}

