/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.CampaignConversionGoal;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignConversionGoal
extends SingleRecordBulkEntity {
    private CampaignConversionGoal campaignConversionGoal;
    private String subType;
    private String actionType;
    private static final List<BulkMapping<BulkCampaignConversionGoal>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setCampaignConversionGoal(new CampaignConversionGoal());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCampaignConversionGoal(), "CampaignConversionGoal");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public CampaignConversionGoal createCampaignConversionGoal() {
        return new CampaignConversionGoal();
    }

    public CampaignConversionGoal getCampaignConversionGoal() {
        return this.campaignConversionGoal;
    }

    public void setCampaignConversionGoal(CampaignConversionGoal goal) {
        this.campaignConversionGoal = goal;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignConversionGoal, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignConversionGoal, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignConversionGoal, Long>("Parent Id", new Function<BulkCampaignConversionGoal, Long>(){

            @Override
            public Long apply(BulkCampaignConversionGoal g) {
                return g.getCampaignConversionGoal().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignConversionGoal>(){

            @Override
            public void accept(String v, BulkCampaignConversionGoal g) {
                g.getCampaignConversionGoal().setCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignConversionGoal, Long>("Goal Id", new Function<BulkCampaignConversionGoal, Long>(){

            @Override
            public Long apply(BulkCampaignConversionGoal g) {
                return g.getCampaignConversionGoal().getGoalId();
            }
        }, new BiConsumer<String, BulkCampaignConversionGoal>(){

            @Override
            public void accept(String v, BulkCampaignConversionGoal g) {
                g.getCampaignConversionGoal().setGoalId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignConversionGoal, String>("Sub Type", new Function<BulkCampaignConversionGoal, String>(){

            @Override
            public String apply(BulkCampaignConversionGoal c) {
                return c.getSubType();
            }
        }, new BiConsumer<String, BulkCampaignConversionGoal>(){

            @Override
            public void accept(String v, BulkCampaignConversionGoal c) {
                c.setSubType(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignConversionGoal, String>("Action Type", new Function<BulkCampaignConversionGoal, String>(){

            @Override
            public String apply(BulkCampaignConversionGoal c) {
                return c.getActionType();
            }
        }, new BiConsumer<String, BulkCampaignConversionGoal>(){

            @Override
            public void accept(String v, BulkCampaignConversionGoal c) {
                c.setActionType(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

