/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.AttributeType;
import com.microsoft.bingads.v13.bulk.entities.EditorialStatus;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdCustomizerAttribute
extends SingleRecordBulkEntity {
    private String id;
    private String name;
    private String accountValue;
    private AttributeType dataType;
    private EditorialStatus editorialStatus;
    private String status;
    private static final List<BulkMapping<BulkAdCustomizerAttribute>> MAPPINGS;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAccountValue() {
        return this.accountValue;
    }

    public void setAccountValue(String accountValue) {
        this.accountValue = accountValue;
    }

    public AttributeType getDataType() {
        return this.dataType;
    }

    public void setDataType(AttributeType dataType) {
        this.dataType = dataType;
    }

    public EditorialStatus getEditorialStatus() {
        return this.editorialStatus;
    }

    public void setEditorialStatus(EditorialStatus editorialStatus) {
        this.editorialStatus = editorialStatus;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdCustomizerAttribute, String>> m = new ArrayList<SimpleBulkMapping<BulkAdCustomizerAttribute, String>>();
        m.add(new SimpleBulkMapping<BulkAdCustomizerAttribute, String>("Id", new Function<BulkAdCustomizerAttribute, String>(){

            @Override
            public String apply(BulkAdCustomizerAttribute t) {
                return t.getId();
            }
        }, new BiConsumer<String, BulkAdCustomizerAttribute>(){

            @Override
            public void accept(String v, BulkAdCustomizerAttribute c) {
                c.setId(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdCustomizerAttribute, String>("Name", new Function<BulkAdCustomizerAttribute, String>(){

            @Override
            public String apply(BulkAdCustomizerAttribute t) {
                return t.getName();
            }
        }, new BiConsumer<String, BulkAdCustomizerAttribute>(){

            @Override
            public void accept(String v, BulkAdCustomizerAttribute c) {
                c.setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdCustomizerAttribute, String>("AdCustomizer AttributeValue", new Function<BulkAdCustomizerAttribute, String>(){

            @Override
            public String apply(BulkAdCustomizerAttribute t) {
                return t.getAccountValue();
            }
        }, new BiConsumer<String, BulkAdCustomizerAttribute>(){

            @Override
            public void accept(String v, BulkAdCustomizerAttribute c) {
                c.setAccountValue(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdCustomizerAttribute, String>("AdCustomizer DataType", new Function<BulkAdCustomizerAttribute, String>(){

            @Override
            public String apply(BulkAdCustomizerAttribute t) {
                return t.getDataType() != null ? t.getDataType().value() : null;
            }
        }, new BiConsumer<String, BulkAdCustomizerAttribute>(){

            @Override
            public void accept(String v, BulkAdCustomizerAttribute t) {
                t.setDataType(StringExtensions.parseOptional(v, new Function<String, AttributeType>(){

                    @Override
                    public AttributeType apply(String value) {
                        return StringExtensions.fromValueOptional(value, AttributeType.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdCustomizerAttribute, String>("Editorial Status", new Function<BulkAdCustomizerAttribute, String>(){

            @Override
            public String apply(BulkAdCustomizerAttribute t) {
                return t.getEditorialStatus() != null ? t.getEditorialStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAdCustomizerAttribute>(){

            @Override
            public void accept(String v, BulkAdCustomizerAttribute t) {
                t.setEditorialStatus(StringExtensions.parseOptional(v, new Function<String, EditorialStatus>(){

                    @Override
                    public EditorialStatus apply(String value) {
                        return StringExtensions.fromValueOptional(value, EditorialStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdCustomizerAttribute, String>("Status", new Function<BulkAdCustomizerAttribute, String>(){

            @Override
            public String apply(BulkAdCustomizerAttribute t) {
                return t.getStatus();
            }
        }, new BiConsumer<String, BulkAdCustomizerAttribute>(){

            @Override
            public void accept(String v, BulkAdCustomizerAttribute c) {
                c.setStatus(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

