/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkConversionGoal;
import com.microsoft.bingads.v13.campaignmanagement.ExpressionOperator;
import com.microsoft.bingads.v13.campaignmanagement.UrlGoal;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkUrlGoal
extends BulkConversionGoal<UrlGoal> {
    private static final List<BulkMapping<BulkUrlGoal>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public UrlGoal getUrlGoal() {
        return (UrlGoal)this.getConversionGoal();
    }

    public void setUrlGoal(UrlGoal UrlGoal2) {
        this.setConversionGoal(UrlGoal2);
    }

    @Override
    public UrlGoal createConversionGoal() {
        return new UrlGoal();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkUrlGoal, String>> m = new ArrayList<SimpleBulkMapping<BulkUrlGoal, String>>();
        m.add(new SimpleBulkMapping<BulkUrlGoal, String>("URL Expression", new Function<BulkUrlGoal, String>(){

            @Override
            public String apply(BulkUrlGoal c) {
                return c.getUrlGoal().getUrlExpression();
            }
        }, new BiConsumer<String, BulkUrlGoal>(){

            @Override
            public void accept(String v, BulkUrlGoal c) {
                c.getUrlGoal().setUrlExpression(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkUrlGoal, String>("URL Operator", new Function<BulkUrlGoal, String>(){

            @Override
            public String apply(BulkUrlGoal c) {
                return c.getUrlGoal().getUrlOperator() != null ? c.getUrlGoal().getUrlOperator().value() : null;
            }
        }, new BiConsumer<String, BulkUrlGoal>(){

            @Override
            public void accept(String v, BulkUrlGoal c) {
                c.getUrlGoal().setUrlOperator(StringExtensions.parseOptional(v, new Function<String, ExpressionOperator>(){

                    @Override
                    public ExpressionOperator apply(String value) {
                        return StringExtensions.fromValueOptional(value, ExpressionOperator.class);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

