/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.HotelLengthOfStayCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupHotelLengthOfStayCriterion
extends BulkAdGroupBiddableCriterion {
    private static final List<BulkMapping<BulkAdGroupHotelLengthOfStayCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    protected Criterion createCriterion() {
        return new HotelLengthOfStayCriterion();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupHotelLengthOfStayCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupHotelLengthOfStayCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkAdGroupHotelLengthOfStayCriterion, String>("Min Target Value", new Function<BulkAdGroupHotelLengthOfStayCriterion, String>(){

            @Override
            public String apply(BulkAdGroupHotelLengthOfStayCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelLengthOfStayCriterion) {
                    HotelLengthOfStayCriterion criterion = (HotelLengthOfStayCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    return criterion == null ? null : StringExtensions.toBulkString(criterion.getMinNights());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupHotelLengthOfStayCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupHotelLengthOfStayCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelLengthOfStayCriterion) {
                    ((HotelLengthOfStayCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setMinNights(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                        @Override
                        public Integer apply(String s) {
                            return Integer.parseInt(s);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupHotelLengthOfStayCriterion, String>("Max Target Value", new Function<BulkAdGroupHotelLengthOfStayCriterion, String>(){

            @Override
            public String apply(BulkAdGroupHotelLengthOfStayCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelLengthOfStayCriterion) {
                    HotelLengthOfStayCriterion criterion = (HotelLengthOfStayCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    return criterion == null ? null : StringExtensions.toBulkString(criterion.getMaxNights());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupHotelLengthOfStayCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupHotelLengthOfStayCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelLengthOfStayCriterion) {
                    ((HotelLengthOfStayCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setMaxNights(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                        @Override
                        public Integer apply(String s) {
                            return Integer.parseInt(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

