/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.CxfUtils;
import com.microsoft.bingads.internal.ServiceFactoryImpl;
import com.microsoft.bingads.internal.ServiceInfo;
import com.microsoft.bingads.internal.ServiceUtils;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.transport.common.gzip.GZIPFeature;

public class HttpClientProvider {
    private Map<String, WebTarget> webTargetByService;

    public void initialize() {
        if (this.webTargetByService != null) {
            return;
        }
        ClientBuilder clientBuilder = this.configureClientBuilder(ClientBuilder.newBuilder());
        Client client = clientBuilder.build();
        this.webTargetByService = this.createWebTargets(client);
    }

    public WebTarget get(Class<?> serviceInterface, ApiEnvironment environment) {
        String key = HttpClientProvider.getKey(serviceInterface, environment);
        return this.webTargetByService.get(key);
    }

    private static String getKey(Class<?> serviceInterface, ApiEnvironment environment) {
        return serviceInterface.getName() + "_" + environment.toString();
    }

    protected ClientBuilder configureClientBuilder(ClientBuilder clientBuilder) {
        String clientClassName = clientBuilder.getClass().getName();
        if (clientClassName.contains("org.apache.cxf")) {
            clientBuilder = (ClientBuilder)clientBuilder.register((Object)new GZIPFeature());
        }
        if (clientClassName.contains("org.glassfish.jersey")) {
            clientBuilder = (ClientBuilder)clientBuilder.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        }
        return clientBuilder.connectTimeout(1L, TimeUnit.MINUTES).readTimeout(10L, TimeUnit.MINUTES);
    }

    protected Map<String, WebTarget> createWebTargets(Client client) {
        boolean isCxf = client.getClass().getName().contains("org.apache.cxf");
        if (isCxf) {
            return CxfUtils.runOnNewBus(() -> HttpClientProvider.initializeWebTargets(client), logging -> {
                HashSet<String> headerNames = new HashSet<String>();
                headerNames.add("Authorization");
                headerNames.add("Password");
                logging.setSensitiveProtocolHeaderNames(headerNames);
            });
        }
        return HttpClientProvider.initializeWebTargets(client);
    }

    protected static Map<String, WebTarget> initializeWebTargets(Client client) {
        HashMap<String, WebTarget> webTargets = new HashMap<String, WebTarget>();
        for (ApiEnvironment environment : Arrays.asList(ApiEnvironment.PRODUCTION, ApiEnvironment.SANDBOX)) {
            for (Map.Entry<Class<?>, ServiceInfo> endpoint : ServiceFactoryImpl.endpoints.entrySet()) {
                URL soapUrl;
                Class<?> serviceInterface = endpoint.getKey();
                ServiceInfo serviceInfo = endpoint.getValue();
                String serviceUrl = ServiceUtils.getServiceUrlFromConfig(serviceInterface);
                if (serviceUrl == null) {
                    serviceUrl = serviceInfo.GetUrl(environment);
                }
                try {
                    soapUrl = new URL(serviceUrl);
                }
                catch (MalformedURLException e) {
                    throw new InternalException(e);
                }
                String restUrl = soapUrl.getProtocol() + "://" + soapUrl.getAuthority() + "/" + serviceInfo.getServiceNameAndVersion();
                String key = HttpClientProvider.getKey(serviceInterface, environment);
                WebTarget webTarget = client.target(restUrl);
                webTarget.request();
                webTargets.put(key, webTarget);
            }
        }
        return webTargets;
    }
}

