/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.restful.ResponseInfo;
import com.microsoft.bingads.internal.restful.RestfulServiceClient;
import com.microsoft.bingads.v13.bulk.AdApiFaultDetail;
import com.microsoft.bingads.v13.bulk.AdApiFaultDetail_Exception;
import com.microsoft.bingads.v13.bulk.ApiFaultDetail;
import com.microsoft.bingads.v13.bulk.ApiFaultDetail_Exception;
import com.microsoft.bingads.v13.bulk.ApplicationFault;
import com.microsoft.bingads.v13.bulk.DownloadCampaignsByAccountIdsRequest;
import com.microsoft.bingads.v13.bulk.DownloadCampaignsByAccountIdsResponse;
import com.microsoft.bingads.v13.bulk.DownloadCampaignsByCampaignIdsRequest;
import com.microsoft.bingads.v13.bulk.DownloadCampaignsByCampaignIdsResponse;
import com.microsoft.bingads.v13.bulk.GetBulkDownloadStatusRequest;
import com.microsoft.bingads.v13.bulk.GetBulkDownloadStatusResponse;
import com.microsoft.bingads.v13.bulk.GetBulkUploadStatusRequest;
import com.microsoft.bingads.v13.bulk.GetBulkUploadStatusResponse;
import com.microsoft.bingads.v13.bulk.GetBulkUploadUrlRequest;
import com.microsoft.bingads.v13.bulk.GetBulkUploadUrlResponse;
import com.microsoft.bingads.v13.bulk.IBulkService;
import com.microsoft.bingads.v13.bulk.UploadEntityRecordsRequest;
import com.microsoft.bingads.v13.bulk.UploadEntityRecordsResponse;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class BulkService
extends RestfulServiceClient
implements IBulkService {
    Supplier<IBulkService> fallbackService;

    public BulkService(Map<String, String> headers, ApiEnvironment env, Supplier<IBulkService> fallbackService) {
        super(headers, env, IBulkService.class);
        this.fallbackService = fallbackService;
    }

    Exception processFaultDetail(ApplicationFault faultDetail, boolean shouldThrow) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        String message = this.getFaultMessage(faultDetail.getTrackingId());
        if (faultDetail instanceof AdApiFaultDetail) {
            AdApiFaultDetail_Exception ex = new AdApiFaultDetail_Exception(message, (AdApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiFaultDetail) {
            ApiFaultDetail_Exception ex = new ApiFaultDetail_Exception(message, (ApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (shouldThrow) {
            throw new RuntimeException("Unknown fault type: " + faultDetail.getClass());
        }
        return null;
    }

    protected <Req, Resp> Resp sendRequest(Req request, String entityEndpoint, String verb, Class<Resp> respClass) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        ResponseInfo<Resp, ApplicationFault> responseInfo = this.getResponseInfo(request, entityEndpoint, verb, respClass, ApplicationFault.class);
        if (responseInfo == null) {
            return null;
        }
        ApplicationFault faultDetail = responseInfo.getFaultDetail();
        if (faultDetail != null) {
            this.processFaultDetail(faultDetail, true);
        }
        return responseInfo.getResponse();
    }

    private Exception getFaultException(ApplicationFault faultDetail) {
        try {
            Exception ex = this.processFaultDetail(faultDetail, false);
            return ex;
        }
        catch (Exception ex) {
            throw new InternalException(ex);
        }
    }

    protected <Req, Resp> Response<Resp> sendRequestAsync(Req request, String entityEndpoint, String verb, Class<Resp> respClass, BiFunction<Req, AsyncHandler<Resp>, Future<?>> soapMethod, AsyncHandler<Resp> handler) {
        return this.processRequestAsync(request, entityEndpoint, verb, respClass, ApplicationFault.class, x -> this.getFaultException((ApplicationFault)x), soapMethod, handler);
    }

    @Override
    public DownloadCampaignsByAccountIdsResponse downloadCampaignsByAccountIds(DownloadCampaignsByAccountIdsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        DownloadCampaignsByAccountIdsResponse response = this.sendRequest(request, "/Campaigns/DownloadByAccountIds", "POST", DownloadCampaignsByAccountIdsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().downloadCampaignsByAccountIds(request);
        }
        return response;
    }

    @Override
    public Response<DownloadCampaignsByAccountIdsResponse> downloadCampaignsByAccountIdsAsync(DownloadCampaignsByAccountIdsRequest request) {
        return this.sendRequestAsync(request, "/Campaigns/DownloadByAccountIds", "POST", DownloadCampaignsByAccountIdsResponse.class, (r, h) -> this.fallbackService.get().downloadCampaignsByAccountIdsAsync((DownloadCampaignsByAccountIdsRequest)r, (AsyncHandler<DownloadCampaignsByAccountIdsResponse>)h), null);
    }

    @Override
    public Future<?> downloadCampaignsByAccountIdsAsync(DownloadCampaignsByAccountIdsRequest request, AsyncHandler<DownloadCampaignsByAccountIdsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Campaigns/DownloadByAccountIds", "POST", DownloadCampaignsByAccountIdsResponse.class, (r, h) -> this.fallbackService.get().downloadCampaignsByAccountIdsAsync((DownloadCampaignsByAccountIdsRequest)r, (AsyncHandler<DownloadCampaignsByAccountIdsResponse>)h), asyncHandler);
    }

    @Override
    public DownloadCampaignsByCampaignIdsResponse downloadCampaignsByCampaignIds(DownloadCampaignsByCampaignIdsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        DownloadCampaignsByCampaignIdsResponse response = this.sendRequest(request, "/Campaigns/DownloadByCampaignIds", "POST", DownloadCampaignsByCampaignIdsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().downloadCampaignsByCampaignIds(request);
        }
        return response;
    }

    @Override
    public Response<DownloadCampaignsByCampaignIdsResponse> downloadCampaignsByCampaignIdsAsync(DownloadCampaignsByCampaignIdsRequest request) {
        return this.sendRequestAsync(request, "/Campaigns/DownloadByCampaignIds", "POST", DownloadCampaignsByCampaignIdsResponse.class, (r, h) -> this.fallbackService.get().downloadCampaignsByCampaignIdsAsync((DownloadCampaignsByCampaignIdsRequest)r, (AsyncHandler<DownloadCampaignsByCampaignIdsResponse>)h), null);
    }

    @Override
    public Future<?> downloadCampaignsByCampaignIdsAsync(DownloadCampaignsByCampaignIdsRequest request, AsyncHandler<DownloadCampaignsByCampaignIdsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Campaigns/DownloadByCampaignIds", "POST", DownloadCampaignsByCampaignIdsResponse.class, (r, h) -> this.fallbackService.get().downloadCampaignsByCampaignIdsAsync((DownloadCampaignsByCampaignIdsRequest)r, (AsyncHandler<DownloadCampaignsByCampaignIdsResponse>)h), asyncHandler);
    }

    @Override
    public GetBulkDownloadStatusResponse getBulkDownloadStatus(GetBulkDownloadStatusRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetBulkDownloadStatusResponse response = this.sendRequest(request, "/BulkDownloadStatus/Query", "POST", GetBulkDownloadStatusResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getBulkDownloadStatus(request);
        }
        return response;
    }

    @Override
    public Response<GetBulkDownloadStatusResponse> getBulkDownloadStatusAsync(GetBulkDownloadStatusRequest request) {
        return this.sendRequestAsync(request, "/BulkDownloadStatus/Query", "POST", GetBulkDownloadStatusResponse.class, (r, h) -> this.fallbackService.get().getBulkDownloadStatusAsync((GetBulkDownloadStatusRequest)r, (AsyncHandler<GetBulkDownloadStatusResponse>)h), null);
    }

    @Override
    public Future<?> getBulkDownloadStatusAsync(GetBulkDownloadStatusRequest request, AsyncHandler<GetBulkDownloadStatusResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BulkDownloadStatus/Query", "POST", GetBulkDownloadStatusResponse.class, (r, h) -> this.fallbackService.get().getBulkDownloadStatusAsync((GetBulkDownloadStatusRequest)r, (AsyncHandler<GetBulkDownloadStatusResponse>)h), asyncHandler);
    }

    @Override
    public GetBulkUploadUrlResponse getBulkUploadUrl(GetBulkUploadUrlRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetBulkUploadUrlResponse response = this.sendRequest(request, "/BulkUploadUrl/Query", "POST", GetBulkUploadUrlResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getBulkUploadUrl(request);
        }
        return response;
    }

    @Override
    public Response<GetBulkUploadUrlResponse> getBulkUploadUrlAsync(GetBulkUploadUrlRequest request) {
        return this.sendRequestAsync(request, "/BulkUploadUrl/Query", "POST", GetBulkUploadUrlResponse.class, (r, h) -> this.fallbackService.get().getBulkUploadUrlAsync((GetBulkUploadUrlRequest)r, (AsyncHandler<GetBulkUploadUrlResponse>)h), null);
    }

    @Override
    public Future<?> getBulkUploadUrlAsync(GetBulkUploadUrlRequest request, AsyncHandler<GetBulkUploadUrlResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BulkUploadUrl/Query", "POST", GetBulkUploadUrlResponse.class, (r, h) -> this.fallbackService.get().getBulkUploadUrlAsync((GetBulkUploadUrlRequest)r, (AsyncHandler<GetBulkUploadUrlResponse>)h), asyncHandler);
    }

    @Override
    public GetBulkUploadStatusResponse getBulkUploadStatus(GetBulkUploadStatusRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        GetBulkUploadStatusResponse response = this.sendRequest(request, "/BulkUploadStatus/Query", "POST", GetBulkUploadStatusResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getBulkUploadStatus(request);
        }
        return response;
    }

    @Override
    public Response<GetBulkUploadStatusResponse> getBulkUploadStatusAsync(GetBulkUploadStatusRequest request) {
        return this.sendRequestAsync(request, "/BulkUploadStatus/Query", "POST", GetBulkUploadStatusResponse.class, (r, h) -> this.fallbackService.get().getBulkUploadStatusAsync((GetBulkUploadStatusRequest)r, (AsyncHandler<GetBulkUploadStatusResponse>)h), null);
    }

    @Override
    public Future<?> getBulkUploadStatusAsync(GetBulkUploadStatusRequest request, AsyncHandler<GetBulkUploadStatusResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BulkUploadStatus/Query", "POST", GetBulkUploadStatusResponse.class, (r, h) -> this.fallbackService.get().getBulkUploadStatusAsync((GetBulkUploadStatusRequest)r, (AsyncHandler<GetBulkUploadStatusResponse>)h), asyncHandler);
    }

    @Override
    public UploadEntityRecordsResponse uploadEntityRecords(UploadEntityRecordsRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        UploadEntityRecordsResponse response = this.sendRequest(request, "/EntityRecords/Upload", "POST", UploadEntityRecordsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().uploadEntityRecords(request);
        }
        return response;
    }

    @Override
    public Response<UploadEntityRecordsResponse> uploadEntityRecordsAsync(UploadEntityRecordsRequest request) {
        return this.sendRequestAsync(request, "/EntityRecords/Upload", "POST", UploadEntityRecordsResponse.class, (r, h) -> this.fallbackService.get().uploadEntityRecordsAsync((UploadEntityRecordsRequest)r, (AsyncHandler<UploadEntityRecordsResponse>)h), null);
    }

    @Override
    public Future<?> uploadEntityRecordsAsync(UploadEntityRecordsRequest request, AsyncHandler<UploadEntityRecordsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/EntityRecords/Upload", "POST", UploadEntityRecordsResponse.class, (r, h) -> this.fallbackService.get().uploadEntityRecordsAsync((UploadEntityRecordsRequest)r, (AsyncHandler<UploadEntityRecordsResponse>)h), asyncHandler);
    }
}

