/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import jakarta.xml.ws.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class ServiceUtils {
    private static String PROPRETY_PREFIX = "com.microsoft.bingads.";
    public static String TRACKING_KEY = "com.microsoft.bingads.trackingId";
    public static String REQUEST_HEADERS_KEY = "com.microsoft.bingads.requestHeaders";
    public static String TRACKING_HEADER_NAME = "TrackingId";
    private static Properties FileProperties;

    public static String getPropertyFileName() {
        return System.getProperty("com.microsoft.bingads.propertyFileName", "bingads.properties");
    }

    public static String getPropertyValue(String name) {
        String systemPropertyName = name.startsWith(PROPRETY_PREFIX) ? name : PROPRETY_PREFIX + name;
        return System.getProperty(systemPropertyName, FileProperties != null ? FileProperties.getProperty(name) : null);
    }

    public static String getPropertyValue(String name, String valueIfNotFound) {
        String propertyValue = ServiceUtils.getPropertyValue(name);
        if (propertyValue == null) {
            return valueIfNotFound;
        }
        return propertyValue;
    }

    public static String GetTrackingId(Response<?> response) {
        Map context = response.getContext();
        return context != null ? context.get(TRACKING_KEY).toString() : "";
    }

    public static ApiEnvironment getEnvironmentFromConfig() {
        String envString = ServiceUtils.getPropertyValue("environment");
        if (envString == null) {
            return null;
        }
        return ApiEnvironment.fromValue(envString);
    }

    public static String getServiceUrlFromConfig(Class<?> serviceInterface) {
        return ServiceUtils.getPropertyValue(serviceInterface.getCanonicalName() + ".url");
    }

    public static boolean getFallbackFlag() {
        String propertyValue = ServiceUtils.getPropertyValue("EnableFallbackToSoap");
        if (propertyValue == null) {
            return true;
        }
        return Boolean.parseBoolean(propertyValue);
    }

    public static String getClientName() {
        return ServiceUtils.getPropertyValue("ClientName");
    }

    public static boolean getEnableRestApi() {
        String propertyValue = ServiceUtils.getPropertyValue("EnableRestApi");
        if (propertyValue == null) {
            return false;
        }
        return Boolean.parseBoolean(propertyValue);
    }

    public static boolean getDisableRestApi(Class<?> serviceInterface) {
        String propertyValue = ServiceUtils.getPropertyValue(serviceInterface.getSimpleName() + ".DisableRestApi");
        if (propertyValue == null) {
            return false;
        }
        return Boolean.parseBoolean(propertyValue);
    }

    static {
        String propertyFileName = ServiceUtils.getPropertyFileName();
        try (InputStream input = ServiceUtils.class.getClassLoader().getResourceAsStream(propertyFileName);){
            if (input != null) {
                FileProperties = new Properties();
                FileProperties.load(input);
            }
        }
        catch (IOException ex) {
            throw new InternalException(ex);
        }
    }
}

