/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.HotelDateSelectionType;
import com.microsoft.bingads.v13.campaignmanagement.HotelDateSelectionTypeCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupHotelDateSelectionTypeCriterion
extends BulkAdGroupBiddableCriterion {
    private static final List<BulkMapping<BulkAdGroupHotelDateSelectionTypeCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    protected Criterion createCriterion() {
        return new HotelDateSelectionTypeCriterion();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupHotelDateSelectionTypeCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupHotelDateSelectionTypeCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkAdGroupHotelDateSelectionTypeCriterion, String>("Target", new Function<BulkAdGroupHotelDateSelectionTypeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupHotelDateSelectionTypeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelDateSelectionTypeCriterion) {
                    HotelDateSelectionTypeCriterion criterion = (HotelDateSelectionTypeCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    return criterion == null || criterion.getHotelDateSelectionType() == null ? null : criterion.getHotelDateSelectionType().value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupHotelDateSelectionTypeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupHotelDateSelectionTypeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelDateSelectionTypeCriterion) {
                    ((HotelDateSelectionTypeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setHotelDateSelectionType(StringExtensions.parseOptional(v, new Function<String, HotelDateSelectionType>(){

                        @Override
                        public HotelDateSelectionType apply(String t) {
                            return StringExtensions.fromValueOptional(t, HotelDateSelectionType.class);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

