/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.reporting;

import com.microsoft.bingads.v13.internal.reporting.RowReportHeaderParser;
import com.microsoft.bingads.v13.internal.reporting.RowReportRecord;
import com.microsoft.bingads.v13.internal.reporting.RowReportRecordReader;
import com.microsoft.bingads.v13.internal.reporting.RowReportRecordReaderFactory;
import com.microsoft.bingads.v13.reporting.ReportFormat;
import java.io.File;
import java.io.IOException;

class RowReportStreamReader
implements AutoCloseable {
    private RowReportRecordReader recordReader;

    RowReportStreamReader(File file, ReportFormat format) throws IOException {
        this.recordReader = new RowReportRecordReader(RowReportRecordReaderFactory.createReportRecordReader(file, format));
    }

    RowReportStreamReader(String filePath, ReportFormat format) throws IOException {
        this.recordReader = new RowReportRecordReader(RowReportRecordReaderFactory.createReportRecordReader(filePath, format));
    }

    @Override
    public void close() throws Exception {
        if (this.recordReader != null) {
            this.recordReader.close();
            this.recordReader = null;
        }
    }

    RowReportRecord read() {
        if (this.recordReader == null) {
            return null;
        }
        RowReportRecord result = this.recordReader.next();
        if (result != null) {
            return result;
        }
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    void readReportHeader(RowReportHeaderParser reportHeaderParser) {
        while (this.recordReader != null && this.recordReader.readNextHeader(reportHeaderParser)) {
        }
    }
}

