/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.OfflineConversion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class BulkOfflineConversion
extends SingleRecordBulkEntity {
    private OfflineConversion offlineConversion;
    private Double adjustmentValue;
    private Calendar adjustmentTime;
    private String adjustmentCurrencyCode;
    private String adjustmentType;
    private String externalAttributionModel;
    private Double externalAttributionCredit;
    private static final List<BulkMapping<BulkOfflineConversion>> MAPPINGS;

    public OfflineConversion getOfflineConversion() {
        return this.offlineConversion;
    }

    public void setOfflineConversion(OfflineConversion offlineConversion) {
        this.offlineConversion = offlineConversion;
    }

    public Double getAdjustmentValue() {
        return this.adjustmentValue;
    }

    public void setAdjustmentValue(Double adjustmentValue) {
        this.adjustmentValue = adjustmentValue;
    }

    public Calendar getAdjustmentTime() {
        return this.adjustmentTime;
    }

    public void setAdjustmentTime(Calendar adjustmentTime) {
        this.adjustmentTime = adjustmentTime;
    }

    public String getAdjustmentCurrencyCode() {
        return this.adjustmentCurrencyCode;
    }

    public void setAdjustmentCurrencyCode(String adjustmentCurrencyCode) {
        this.adjustmentCurrencyCode = adjustmentCurrencyCode;
    }

    public String getAdjustmentType() {
        return this.adjustmentType;
    }

    public void setAdjustmentType(String adjustmentType) {
        this.adjustmentType = adjustmentType;
    }

    public String getExternalAttributionModel() {
        return this.externalAttributionModel;
    }

    public void setExternalAttributionModel(String externalAttributionModel) {
        this.externalAttributionModel = externalAttributionModel;
    }

    public Double getExternalAttributionCredit() {
        return this.externalAttributionCredit;
    }

    public void setExternalAttributionCredit(Double externalAttributionCredit) {
        this.externalAttributionCredit = externalAttributionCredit;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setOfflineConversion(new OfflineConversion());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getOfflineConversion(), "OfflineConversion");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkOfflineConversion, Object>> m = new ArrayList<SimpleBulkMapping<BulkOfflineConversion, Object>>();
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Conversion Currency Code", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getConversionCurrencyCode();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setConversionCurrencyCode(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Conversion Name", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getConversionName();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setConversionName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Microsoft Click Id", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getMicrosoftClickId();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setMicrosoftClickId(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Conversion Time", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion t) {
                if (t.getOfflineConversion().getConversionTime() == null) {
                    return null;
                }
                SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.format(t.getOfflineConversion().getConversionTime().getTime());
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setConversionTime(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, Double>("Conversion Value", new Function<BulkOfflineConversion, Double>(){

            @Override
            public Double apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getConversionValue();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setConversionValue(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, Double>("Adjustment Value", new Function<BulkOfflineConversion, Double>(){

            @Override
            public Double apply(BulkOfflineConversion c) {
                return c.getAdjustmentValue();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.setAdjustmentValue(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, Double>("External Attribution Credit", new Function<BulkOfflineConversion, Double>(){

            @Override
            public Double apply(BulkOfflineConversion c) {
                return c.getExternalAttributionCredit();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.setExternalAttributionCredit(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Adjustment Time", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion t) {
                if (t.getAdjustmentTime() == null) {
                    return null;
                }
                SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.format(t.getAdjustmentTime().getTime());
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.setAdjustmentTime(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Adjustment Currency Code", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getAdjustmentCurrencyCode();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.setAdjustmentCurrencyCode(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Adjustment Type", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getAdjustmentType();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.setAdjustmentType(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("External Attribution Model", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getExternalAttributionModel();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.setExternalAttributionModel(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Hashed Email Address", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getHashedEmailAddress();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setHashedEmailAddress(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Hashed Phone Number", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getHashedPhoneNumber();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setHashedPhoneNumber(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

