/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.NegativeCampaignCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkCampaignNegativeCriterion
extends SingleRecordBulkEntity {
    private NegativeCampaignCriterion negativeCampaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignNegativeCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeCampaignCriterion campaignCriterion = new NegativeCampaignCriterion();
        Criterion criterion = this.createCriterion();
        campaignCriterion.setCriterion(criterion);
        campaignCriterion.getCriterion().setType(criterion.getClass().getSimpleName());
        campaignCriterion.setType("NegativeCampaignCriterion");
        this.setNegativeCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    protected abstract Criterion createCriterion();

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeCampaignCriterion(), NegativeCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public NegativeCampaignCriterion getNegativeCampaignCriterion() {
        return this.negativeCampaignCriterion;
    }

    public void setNegativeCampaignCriterion(NegativeCampaignCriterion negativeCampaignCriterion) {
        this.negativeCampaignCriterion = negativeCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignNegativeCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignNegativeCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignNegativeCriterion, String>("Status", new Function<BulkCampaignNegativeCriterion, String>(){

            @Override
            public String apply(BulkCampaignNegativeCriterion c) {
                CampaignCriterionStatus status = c.getNegativeCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignNegativeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeCriterion c) {
                c.getNegativeCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return StringExtensions.fromValueOptional(s, CampaignCriterionStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeCriterion, Long>("Id", new Function<BulkCampaignNegativeCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeCriterion c) {
                return c.getNegativeCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeCriterion c) {
                c.getNegativeCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeCriterion, Long>("Parent Id", new Function<BulkCampaignNegativeCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeCriterion c) {
                return c.getNegativeCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeCriterion c) {
                c.getNegativeCampaignCriterion().setCampaignId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeCriterion, String>("Campaign", new Function<BulkCampaignNegativeCriterion, String>(){

            @Override
            public String apply(BulkCampaignNegativeCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignNegativeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeCriterion c) {
                c.setCampaignName(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

