/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkCampaignNegativeCriterion;
import com.microsoft.bingads.v13.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.NegativeCampaignCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignNegativeAudienceAssociation
extends BulkCampaignNegativeCriterion {
    private String audienceName;
    private static final List<BulkMapping<BulkCampaignNegativeAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    protected Criterion createCriterion() {
        return new AudienceCriterion();
    }

    public String getAudienceName() {
        return this.audienceName;
    }

    public void setAudienceName(String audienceName) {
        this.audienceName = audienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, String>("Audience", new Function<BulkCampaignNegativeAudienceAssociation, String>(){

            @Override
            public String apply(BulkCampaignNegativeAudienceAssociation c) {
                return c.getAudienceName();
            }
        }, new BiConsumer<String, BulkCampaignNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignNegativeAudienceAssociation c) {
                c.setAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, Long>("Audience Id", new Function<BulkCampaignNegativeAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeAudienceAssociation c) {
                if (c.getNegativeCampaignCriterion() instanceof NegativeCampaignCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeCampaignCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignNegativeAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeCampaignCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

