/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.Authentication;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.OAuthTokens;
import com.microsoft.bingads.internal.ServiceUtils;
import java.net.URL;

abstract class OAuthAuthorization
extends Authentication {
    protected static ApiEnvironment defaultEnv = ServiceUtils.getEnvironmentFromConfig() == ApiEnvironment.SANDBOX ? ApiEnvironment.SANDBOX : ApiEnvironment.PRODUCTION;
    protected OAuthTokens oAuthTokens;
    protected ApiEnvironment environment;
    private String tenant;
    private String state;

    public abstract URL getAuthorizationEndpoint();

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getTenant() {
        return this.tenant == null ? "common" : this.tenant;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public OAuthTokens getOAuthTokens() {
        return this.oAuthTokens;
    }

    public OAuthAuthorization(ApiEnvironment env) {
        this.environment = env;
    }

    protected void setOAuthTokens(OAuthTokens oAuthTokens) {
        this.oAuthTokens = oAuthTokens;
    }

    public String getAuthenticationToken() {
        return this.oAuthTokens.getAccessToken();
    }

    @Override
    public void addHeaders(HeadersImpl headersImplementation) {
        headersImplementation.addHeader("AuthenticationToken", this.getOAuthTokens().getAccessToken());
    }

    @Override
    public ApiEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ApiEnvironment environment) {
        this.environment = environment;
    }
}

