/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads;

import com.fasterxml.jackson.databind.JsonNode;

public class OAuthTokens {
    private final String accessToken;
    private final long accessTokenExpiresInSeconds;
    private final String refreshToken;
    private final long creationTimeStampInMilliseconds;
    private final JsonNode responseJson;

    public OAuthTokens(String accessToken, long accessTokenExpiresInSeconds, String refreshToken) {
        this(accessToken, accessTokenExpiresInSeconds, refreshToken, null);
    }

    public OAuthTokens(String accessToken, long accessTokenExpiresInSeconds, String refreshToken, JsonNode node) {
        this.accessToken = accessToken;
        this.accessTokenExpiresInSeconds = accessTokenExpiresInSeconds;
        this.refreshToken = refreshToken;
        this.creationTimeStampInMilliseconds = System.currentTimeMillis();
        this.responseJson = node;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public long getAccessTokenExpiresInSeconds() {
        return this.accessTokenExpiresInSeconds - (System.currentTimeMillis() - this.creationTimeStampInMilliseconds) / 1000L;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public JsonNode getResponseJson() {
        return this.responseJson;
    }
}

