/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk;

import com.microsoft.bingads.v13.bulk.BulkEntityIterable;
import com.microsoft.bingads.v13.bulk.DownloadFileType;
import com.microsoft.bingads.v13.bulk.ResultFileType;
import com.microsoft.bingads.v13.internal.bulk.BulkEntityReadable;
import com.microsoft.bingads.v13.internal.bulk.BulkRecordReader;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkStreamReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class BulkFileReader
implements Closeable,
BulkEntityReadable {
    private BulkRecordReader bulkRecordReader;
    private String bulkFilePath;
    private ResultFileType fileType;

    public BulkFileReader(File file, ResultFileType resultFileType, DownloadFileType fileFormat) throws IOException {
        this(file, resultFileType, fileFormat, false);
    }

    public BulkFileReader(File file, ResultFileType resultFileType, DownloadFileType fileFormat, boolean deleteFileOnClose) throws IOException {
        this(new SimpleBulkStreamReader(file, fileFormat, deleteFileOnClose), resultFileType);
        this.bulkFilePath = file.getCanonicalPath();
    }

    public BulkFileReader(InputStream inputStream, ResultFileType resultFileType, DownloadFileType fileFormat) throws IOException {
        this(new SimpleBulkStreamReader(inputStream, fileFormat), resultFileType);
    }

    public BulkFileReader(BulkRecordReader reader, ResultFileType fileType) {
        this.bulkRecordReader = reader;
        this.fileType = fileType;
    }

    @Override
    public BulkEntityIterable getEntities() {
        return new BulkEntityIterable(this.bulkRecordReader, this.isForFullDownload());
    }

    @Override
    public void close() throws IOException {
        this.bulkRecordReader.close();
    }

    boolean isForFullDownload() {
        return this.fileType == ResultFileType.FULL_DOWNLOAD;
    }

    public String getBulkFilePath() {
        return this.bulkFilePath;
    }
}

