/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.DeviceType;
import com.microsoft.bingads.v13.campaignmanagement.SeasonalityAdjustment;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class BulkSeasonalityAdjustment
extends SingleRecordBulkEntity {
    private SeasonalityAdjustment SeasonalityAdjustment;
    private static final List<BulkMapping<BulkSeasonalityAdjustment>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setSeasonalityAdjustment(new SeasonalityAdjustment());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getSeasonalityAdjustment(), "SeasonalityAdjustment");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public SeasonalityAdjustment getSeasonalityAdjustment() {
        return this.SeasonalityAdjustment;
    }

    public void setSeasonalityAdjustment(SeasonalityAdjustment SeasonalityAdjustment2) {
        this.SeasonalityAdjustment = SeasonalityAdjustment2;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkSeasonalityAdjustment, Object>> m = new ArrayList<SimpleBulkMapping<BulkSeasonalityAdjustment, Object>>();
        m.add(new SimpleBulkMapping<BulkSeasonalityAdjustment, Long>("Id", new Function<BulkSeasonalityAdjustment, Long>(){

            @Override
            public Long apply(BulkSeasonalityAdjustment c) {
                return c.getSeasonalityAdjustment().getId();
            }
        }, new BiConsumer<String, BulkSeasonalityAdjustment>(){

            @Override
            public void accept(String v, BulkSeasonalityAdjustment c) {
                c.getSeasonalityAdjustment().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSeasonalityAdjustment, String>("Seasonality Adjustment", new Function<BulkSeasonalityAdjustment, String>(){

            @Override
            public String apply(BulkSeasonalityAdjustment c) {
                return c.getSeasonalityAdjustment().getName();
            }
        }, new BiConsumer<String, BulkSeasonalityAdjustment>(){

            @Override
            public void accept(String v, BulkSeasonalityAdjustment c) {
                c.getSeasonalityAdjustment().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSeasonalityAdjustment, String>("Description", new Function<BulkSeasonalityAdjustment, String>(){

            @Override
            public String apply(BulkSeasonalityAdjustment c) {
                return c.getSeasonalityAdjustment().getDescription();
            }
        }, new BiConsumer<String, BulkSeasonalityAdjustment>(){

            @Override
            public void accept(String v, BulkSeasonalityAdjustment c) {
                c.getSeasonalityAdjustment().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSeasonalityAdjustment, String>("Start Date", new Function<BulkSeasonalityAdjustment, String>(){

            @Override
            public String apply(BulkSeasonalityAdjustment t) {
                if (t.getSeasonalityAdjustment().getStartDate() == null) {
                    return null;
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.format(t.getSeasonalityAdjustment().getStartDate().getTime());
            }
        }, new BiConsumer<String, BulkSeasonalityAdjustment>(){

            @Override
            public void accept(String v, BulkSeasonalityAdjustment c) {
                c.getSeasonalityAdjustment().setStartDate(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSeasonalityAdjustment, String>("End Date", new Function<BulkSeasonalityAdjustment, String>(){

            @Override
            public String apply(BulkSeasonalityAdjustment t) {
                if (t.getSeasonalityAdjustment().getEndDate() == null) {
                    return null;
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.format(t.getSeasonalityAdjustment().getEndDate().getTime());
            }
        }, new BiConsumer<String, BulkSeasonalityAdjustment>(){

            @Override
            public void accept(String v, BulkSeasonalityAdjustment c) {
                c.getSeasonalityAdjustment().setEndDate(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSeasonalityAdjustment, String>("Campaign Type", new Function<BulkSeasonalityAdjustment, String>(){

            @Override
            public String apply(BulkSeasonalityAdjustment c) {
                return StringExtensions.toCampaignTypeListBulkString(",", c.getSeasonalityAdjustment().getCampaignTypeFilter());
            }
        }, new BiConsumer<String, BulkSeasonalityAdjustment>(){

            @Override
            public void accept(String v, BulkSeasonalityAdjustment c) {
                c.getSeasonalityAdjustment().setCampaignTypeFilter(StringExtensions.parseCampaignTypeList(v, ","));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSeasonalityAdjustment, String>("Device Type", new Function<BulkSeasonalityAdjustment, String>(){

            @Override
            public String apply(BulkSeasonalityAdjustment t) {
                return t.getSeasonalityAdjustment().getDeviceTypeFilter() != null ? t.getSeasonalityAdjustment().getDeviceTypeFilter().value() : null;
            }
        }, new BiConsumer<String, BulkSeasonalityAdjustment>(){

            @Override
            public void accept(String v, BulkSeasonalityAdjustment c) {
                c.getSeasonalityAdjustment().setDeviceTypeFilter(StringExtensions.parseOptional(v, new Function<String, DeviceType>(){

                    @Override
                    public DeviceType apply(String value) {
                        return DeviceType.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSeasonalityAdjustment, Double>("Adjustment Value", new Function<BulkSeasonalityAdjustment, Double>(){

            @Override
            public Double apply(BulkSeasonalityAdjustment c) {
                return c.getSeasonalityAdjustment().getAdjustmentPercentage();
            }
        }, new BiConsumer<String, BulkSeasonalityAdjustment>(){

            @Override
            public void accept(String v, BulkSeasonalityAdjustment c) {
                c.getSeasonalityAdjustment().setAdjustmentPercentage(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSeasonalityAdjustment, String>("Campaign Associations", new Function<BulkSeasonalityAdjustment, String>(){

            @Override
            public String apply(BulkSeasonalityAdjustment c) {
                return StringExtensions.toCampaignAssociationsBulkString(";", c.getSeasonalityAdjustment().getCampaignAssociations());
            }
        }, new BiConsumer<String, BulkSeasonalityAdjustment>(){

            @Override
            public void accept(String v, BulkSeasonalityAdjustment c) {
                c.getSeasonalityAdjustment().setCampaignAssociations(StringExtensions.parseCampaignAssociations(v, ";"));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

