/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.SharedEntityAssociation;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAccountNegativeKeywordListAssociation
extends SingleRecordBulkEntity {
    private SharedEntityAssociation sharedEntityAssociation;
    private Status status;
    private static final List<BulkMapping<BulkAccountNegativeKeywordListAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setSharedEntityAssociation(new SharedEntityAssociation());
        this.getSharedEntityAssociation().setEntityType("Account");
        this.getSharedEntityAssociation().setSharedEntityType("NegativeKeywordList");
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public SharedEntityAssociation getSharedEntityAssociation() {
        return this.sharedEntityAssociation;
    }

    public void setSharedEntityAssociation(SharedEntityAssociation association) {
        this.sharedEntityAssociation = association;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAccountNegativeKeywordListAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAccountNegativeKeywordListAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAccountNegativeKeywordListAssociation, String>("Status", new Function<BulkAccountNegativeKeywordListAssociation, String>(){

            @Override
            public String apply(BulkAccountNegativeKeywordListAssociation c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAccountNegativeKeywordListAssociation>(){

            @Override
            public void accept(String v, BulkAccountNegativeKeywordListAssociation c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccountNegativeKeywordListAssociation, Long>("Id", new Function<BulkAccountNegativeKeywordListAssociation, Long>(){

            @Override
            public Long apply(BulkAccountNegativeKeywordListAssociation c) {
                return c.getSharedEntityAssociation().getSharedEntityId();
            }
        }, new BiConsumer<String, BulkAccountNegativeKeywordListAssociation>(){

            @Override
            public void accept(String v, BulkAccountNegativeKeywordListAssociation c) {
                c.getSharedEntityAssociation().setSharedEntityId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccountNegativeKeywordListAssociation, Long>("Parent Id", new Function<BulkAccountNegativeKeywordListAssociation, Long>(){

            @Override
            public Long apply(BulkAccountNegativeKeywordListAssociation c) {
                return c.getSharedEntityAssociation().getEntityId();
            }
        }, new BiConsumer<String, BulkAccountNegativeKeywordListAssociation>(){

            @Override
            public void accept(String v, BulkAccountNegativeKeywordListAssociation c) {
                c.getSharedEntityAssociation().setEntityId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

