/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAudience;
import com.microsoft.bingads.v13.campaignmanagement.RemarketingList;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkRemarketingList
extends BulkAudience<RemarketingList> {
    private static final List<BulkMapping<BulkRemarketingList>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public RemarketingList getRemarketingList() {
        return (RemarketingList)this.getAudience();
    }

    public void setRemarketingList(RemarketingList remarketingList) {
        this.setAudience(remarketingList);
    }

    @Override
    public RemarketingList createAudience() {
        return new RemarketingList();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkRemarketingList, Object>> m = new ArrayList<SimpleBulkMapping<BulkRemarketingList, Object>>();
        m.add(new SimpleBulkMapping<BulkRemarketingList, Long>("UET Tag Id", new Function<BulkRemarketingList, Long>(){

            @Override
            public Long apply(BulkRemarketingList c) {
                return c.getRemarketingList().getTagId();
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setTagId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRemarketingList, String>("Remarketing Rule", new Function<BulkRemarketingList, String>(){

            @Override
            public String apply(BulkRemarketingList c) {
                return StringExtensions.toRemarketingRuleBulkString(c.getRemarketingList().getRule());
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setRule(StringExtensions.parseRemarketingRule(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

