/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.Authentication;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.CouldNotUploadFileException;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.ServiceClient;
import com.microsoft.bingads.internal.MessageHandler;
import com.microsoft.bingads.internal.ParentCallback;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.utilities.HttpClientHttpFileService;
import com.microsoft.bingads.internal.utilities.HttpFileService;
import com.microsoft.bingads.internal.utilities.SimpleZipExtractor;
import com.microsoft.bingads.internal.utilities.ZipExtractor;
import com.microsoft.bingads.v13.bulk.ApiFaultDetail_Exception;
import com.microsoft.bingads.v13.bulk.ArrayOfCampaignScope;
import com.microsoft.bingads.v13.bulk.ArrayOflong;
import com.microsoft.bingads.v13.bulk.ArrayOfstring;
import com.microsoft.bingads.v13.bulk.BulkDownloadOperation;
import com.microsoft.bingads.v13.bulk.BulkEntityIterable;
import com.microsoft.bingads.v13.bulk.BulkFileWriter;
import com.microsoft.bingads.v13.bulk.BulkOperation;
import com.microsoft.bingads.v13.bulk.BulkOperationProgressInfo;
import com.microsoft.bingads.v13.bulk.BulkOperationStatus;
import com.microsoft.bingads.v13.bulk.BulkUploadOperation;
import com.microsoft.bingads.v13.bulk.CampaignScope;
import com.microsoft.bingads.v13.bulk.CouldNotSubmitBulkDownloadException;
import com.microsoft.bingads.v13.bulk.CouldNotSubmitBulkUploadException;
import com.microsoft.bingads.v13.bulk.DownloadCampaignsByAccountIdsRequest;
import com.microsoft.bingads.v13.bulk.DownloadCampaignsByAccountIdsResponse;
import com.microsoft.bingads.v13.bulk.DownloadCampaignsByCampaignIdsRequest;
import com.microsoft.bingads.v13.bulk.DownloadCampaignsByCampaignIdsResponse;
import com.microsoft.bingads.v13.bulk.DownloadFileType;
import com.microsoft.bingads.v13.bulk.DownloadParameters;
import com.microsoft.bingads.v13.bulk.DownloadStatus;
import com.microsoft.bingads.v13.bulk.EntityUploadParameters;
import com.microsoft.bingads.v13.bulk.FileUploadParameters;
import com.microsoft.bingads.v13.bulk.GetBulkUploadUrlRequest;
import com.microsoft.bingads.v13.bulk.GetBulkUploadUrlResponse;
import com.microsoft.bingads.v13.bulk.IBulkService;
import com.microsoft.bingads.v13.bulk.Progress;
import com.microsoft.bingads.v13.bulk.ResultFileType;
import com.microsoft.bingads.v13.bulk.SubmitDownloadParameters;
import com.microsoft.bingads.v13.bulk.SubmitUploadParameters;
import com.microsoft.bingads.v13.bulk.UploadEntityRecordsRequest;
import com.microsoft.bingads.v13.bulk.UploadEntityRecordsResponse;
import com.microsoft.bingads.v13.bulk.UploadStatus;
import com.microsoft.bingads.v13.bulk.WriteAction;
import com.microsoft.bingads.v13.bulk.entities.BulkEntity;
import com.microsoft.bingads.v13.internal.bulk.BulkEntityReadable;
import com.microsoft.bingads.v13.internal.bulk.BulkEntityReaderFactory;
import com.microsoft.bingads.v13.internal.bulk.CsvBulkEntityReaderFactory;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkObjectWriter;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.HttpRequest;

public class BulkServiceManager {
    private static final int SYNC_THRESHOLD = 1000;
    private static final String FORMAT_VERSION = "6.0";
    private AuthorizationData authorizationData;
    private HttpFileService httpFileService;
    private ZipExtractor zipExtractor;
    private BulkEntityReaderFactory bulkEntityReaderFactory;
    private ApiEnvironment apiEnvironment;
    private int statusPollIntervalInMilliseconds;
    private int uploadHttpTimeoutInMilliseconds;
    private int downloadHttpTimeoutInMilliseconds;
    private final ServiceClient<IBulkService> serviceClient;
    private File workingDirectory;

    public BulkServiceManager(AuthorizationData authorizationData) {
        this(authorizationData, null);
    }

    public BulkServiceManager(AuthorizationData authorizationData, boolean enableRestApi) {
        this(authorizationData, null, enableRestApi);
    }

    public BulkServiceManager(AuthorizationData authorizationData, ApiEnvironment apiEnvironment) {
        this(authorizationData, new HttpClientHttpFileService(), new SimpleZipExtractor(), new CsvBulkEntityReaderFactory(), apiEnvironment, false);
    }

    public BulkServiceManager(AuthorizationData authorizationData, ApiEnvironment apiEnvironment, boolean enableRestApi) {
        this(authorizationData, new HttpClientHttpFileService(), new SimpleZipExtractor(), new CsvBulkEntityReaderFactory(), apiEnvironment, enableRestApi);
    }

    private BulkServiceManager(AuthorizationData authorizationData, HttpFileService httpFileService, ZipExtractor zipExtractor, BulkEntityReaderFactory factory, ApiEnvironment apiEnvironment, boolean enableRestApi) {
        this.authorizationData = authorizationData;
        this.httpFileService = httpFileService;
        this.zipExtractor = zipExtractor;
        this.bulkEntityReaderFactory = factory;
        this.apiEnvironment = apiEnvironment;
        this.serviceClient = new ServiceClient<IBulkService>(this.authorizationData, apiEnvironment, IBulkService.class, enableRestApi);
        this.workingDirectory = new File(System.getProperty("java.io.tmpdir"), "BingAdsSDK");
        this.statusPollIntervalInMilliseconds = 5000;
        this.uploadHttpTimeoutInMilliseconds = 100000;
        this.downloadHttpTimeoutInMilliseconds = 100000;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public Future<BulkEntityIterable> downloadEntitiesAsync(DownloadParameters parameters, AsyncCallback<BulkEntityIterable> callback) {
        return this.downloadEntitiesAsync(parameters, null, callback);
    }

    public Future<BulkEntityIterable> downloadEntitiesAsync(DownloadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkEntityIterable> callback) {
        this.validateSubmitDownloadParameters(parameters.getSubmitDownloadParameters());
        this.validateUserData();
        return this.downloadEntitiesAsyncImpl(parameters, progress, callback);
    }

    public Future<BulkEntityIterable> uploadEntitiesAsync(EntityUploadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkEntityIterable> callback) {
        this.validateEntityUploadParameters(parameters);
        this.validateUserData();
        if (this.needToTryUploadEntityRecordsSyncFirst(parameters)) {
            return this.uploadEntityRecordsImpl(parameters, progress, callback);
        }
        return this.uploadEntitiesAsyncImpl(this.createFileUploadParameters(parameters), progress, callback);
    }

    private Future<BulkEntityIterable> uploadEntityRecordsImpl(final EntityUploadParameters parameters, final Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkEntityIterable> callback) {
        final ResultFuture<BulkEntityIterable> resultFuture = new ResultFuture<BulkEntityIterable>(callback);
        try {
            UploadEntityRecordsRequest request = this.createUploadEntityRecordsRequest(parameters);
            final IBulkService service = this.serviceClient.getService();
            service.uploadEntityRecordsAsync(request, new AsyncHandler<UploadEntityRecordsResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleResponse(Response<UploadEntityRecordsResponse> res) {
                    try {
                        UploadEntityRecordsResponse result = (UploadEntityRecordsResponse)res.get();
                        if (this.needToFallBacktoAsync(result)) {
                            final BulkUploadOperation operation = new BulkUploadOperation(result.getRequestId(), BulkServiceManager.this.authorizationData, service, ServiceUtils.GetTrackingId(res), BulkServiceManager.this.apiEnvironment);
                            operation.setStatusPollIntervalInMilliseconds(BulkServiceManager.this.statusPollIntervalInMilliseconds);
                            operation.setDownloadHttpTimeoutInMilliseconds(BulkServiceManager.this.downloadHttpTimeoutInMilliseconds);
                            operation.trackAsync(progress, new ParentCallback<BulkOperationStatus<UploadStatus>>(resultFuture){

                                @Override
                                public void onSuccess(BulkOperationStatus<UploadStatus> status) throws IOException, URISyntaxException {
                                    BulkServiceManager.this.downloadBulkFileAsync(parameters.getResultFileDirectory(), parameters.getResultFileName(), parameters.getOverwriteResultFile(), operation, new ParentCallback<File>(resultFuture){

                                        @Override
                                        public void onSuccess(File localFile) {
                                            try {
                                                resultFuture.setResult(BulkServiceManager.this.bulkEntityReaderFactory.createBulkFileReader(localFile, ResultFileType.UPLOAD, DownloadFileType.CSV, parameters.getAutoDeleteTempFile()).getEntities());
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                }
                            });
                        } else {
                            resultFuture.setResult(BulkServiceManager.this.parseBulkUpsertResult(result.getEntityRecords()));
                        }
                    }
                    catch (Exception ex) {
                        block9: {
                            Throwable cause = ex.getCause();
                            String errorCode = "";
                            try {
                                if (cause instanceof ApiFaultDetail_Exception) {
                                    errorCode = ((ApiFaultDetail_Exception)cause).getFaultInfo().getOperationErrors().getOperationErrors().get(0).getErrorCode();
                                }
                                if (!"OperationNotSupported".equalsIgnoreCase(errorCode)) break block9;
                            }
                            catch (Throwable throwable) {
                                if ("OperationNotSupported".equalsIgnoreCase(errorCode)) {
                                    BulkServiceManager.this.uploadFileAsyncImpl(BulkServiceManager.this.createFileUploadParameters(parameters), progress, new ParentCallback<File>(resultFuture){

                                        @Override
                                        public void onSuccess(File resultFile) throws IOException {
                                            resultFuture.setResult(BulkServiceManager.this.bulkEntityReaderFactory.createBulkFileReader(resultFile, ResultFileType.UPLOAD, DownloadFileType.CSV, parameters.getAutoDeleteTempFile()).getEntities());
                                        }
                                    });
                                } else {
                                    resultFuture.setException(ex);
                                }
                                throw throwable;
                            }
                            BulkServiceManager.this.uploadFileAsyncImpl(BulkServiceManager.this.createFileUploadParameters(parameters), progress, new /* invalid duplicate definition of identical inner class */);
                        }
                        resultFuture.setException(ex);
                    }
                }

                private boolean needToFallBacktoAsync(UploadEntityRecordsResponse result) {
                    return result != null && result.getRequestId() != null && result.getRequestId().length() > 0 && "InProgress".equals(result.getRequestStatus());
                }
            });
        }
        catch (IOException e) {
            resultFuture.setException(e);
        }
        return resultFuture;
    }

    private BulkEntityIterable parseBulkUpsertResult(ArrayOfstring resultRows) throws IOException {
        return this.bulkEntityReaderFactory.createBulkRowsReader(resultRows.getStrings()).getEntities();
    }

    private UploadEntityRecordsRequest createUploadEntityRecordsRequest(EntityUploadParameters parameters) throws IOException {
        List<String> entitiesPayload = this.writeUploadEntitiesAsPayload(parameters);
        UploadEntityRecordsRequest request = new UploadEntityRecordsRequest();
        ArrayOfstring payload = new ArrayOfstring();
        payload.getStrings().addAll(entitiesPayload);
        request.setEntityRecords(payload);
        request.setResponseMode(parameters.getResponseMode());
        request.setAccountId(this.authorizationData.getAccountId());
        return request;
    }

    private List<String> writeUploadEntitiesAsPayload(EntityUploadParameters parameters) throws IOException {
        ArrayList<String> entitiesPayload = new ArrayList<String>();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SimpleBulkObjectWriter writer = new SimpleBulkObjectWriter(os, DownloadFileType.CSV);
        this.writeContent(entitiesPayload, os, () -> writer.writeHeaders());
        this.writeContent(entitiesPayload, os, () -> writer.writeFormatVersion());
        for (BulkEntity entity : parameters.getEntities()) {
            this.writeContent(entitiesPayload, os, () -> entity.write(writer, false));
        }
        return entitiesPayload;
    }

    private void writeContent(List<String> entitiesPayload, ByteArrayOutputStream os, WriteAction action) throws IOException, UnsupportedEncodingException {
        String[] arr;
        os.reset();
        action.execute();
        for (String s : arr = new String(os.toByteArray(), "UTF-8").split("(\\r\\n|\\n|\\r)")) {
            entitiesPayload.add(s);
        }
    }

    private boolean needToTryUploadEntityRecordsSyncFirst(EntityUploadParameters parameters) {
        int count = 0;
        for (BulkEntity entity : parameters.getEntities()) {
            ++count;
        }
        return count <= 1000;
    }

    public Future<BulkEntityIterable> uploadEntitiesAsync(EntityUploadParameters parameters, AsyncCallback<BulkEntityIterable> callback) {
        return this.uploadEntitiesAsync(parameters, null, callback);
    }

    public Future<File> uploadFileAsync(FileUploadParameters parameters, AsyncCallback<File> callback) {
        return this.uploadFileAsync(parameters, null, callback);
    }

    public Future<File> uploadFileAsync(FileUploadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<File> callback) {
        this.validateSubmitUploadParameters(parameters.getSubmitUploadParameters());
        this.validateUserData();
        return this.uploadFileAsyncImpl(parameters, progress, callback);
    }

    private void validateEntityUploadParameters(EntityUploadParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters must not be null");
        }
        if (parameters.getEntities() == null) {
            throw new NullPointerException("parameters.getEntities() must not be null");
        }
        if (!parameters.getEntities().iterator().hasNext()) {
            throw new IllegalArgumentException("parameters.getEntities() must not be empty");
        }
    }

    private void validateSubmitUploadParameters(SubmitUploadParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters must not be null");
        }
        if (parameters.getUploadFilePath() == null) {
            throw new NullPointerException("parameters.getUploadFilePath() must not be null");
        }
    }

    private Future<BulkEntityIterable> uploadEntitiesAsyncImpl(final FileUploadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkEntityIterable> callback) {
        final ResultFuture<BulkEntityIterable> resultFuture = new ResultFuture<BulkEntityIterable>(callback);
        this.uploadFileAsyncImpl(parameters, progress, (AsyncCallback<File>)new ParentCallback<File>(resultFuture){

            @Override
            public void onSuccess(File resultFile) throws IOException {
                resultFuture.setResult(BulkServiceManager.this.bulkEntityReaderFactory.createBulkFileReader(resultFile, ResultFileType.UPLOAD, DownloadFileType.CSV, parameters.getAutoDeleteTempFile()).getEntities());
            }
        });
        return resultFuture;
    }

    private Future<File> uploadFileAsyncImpl(final FileUploadParameters parameters, final Progress<BulkOperationProgressInfo> progress, AsyncCallback<File> callback) {
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        this.workingDirectory.mkdirs();
        this.submitUploadAsync(parameters, (AsyncCallback<BulkUploadOperation>)new ParentCallback<BulkUploadOperation>(resultFuture){

            @Override
            public void onSuccess(final BulkUploadOperation operation) {
                operation.trackAsync(progress, new ParentCallback<BulkOperationStatus<UploadStatus>>(resultFuture){

                    @Override
                    public void onSuccess(BulkOperationStatus<UploadStatus> status) throws IOException, URISyntaxException {
                        BulkServiceManager.this.downloadBulkFileAsync(parameters.getResultFileDirectory(), parameters.getResultFileName(), parameters.getOverwriteResultFile(), operation, new ParentCallback<File>(resultFuture){

                            @Override
                            public void onSuccess(File localFile) {
                                resultFuture.setResult(localFile);
                            }
                        });
                    }
                });
            }
        });
        return resultFuture;
    }

    private void validateSubmitDownloadParameters(SubmitDownloadParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters must not be null");
        }
    }

    private Future<BulkEntityIterable> downloadEntitiesAsyncImpl(final DownloadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkEntityIterable> callback) {
        final ResultFuture<BulkEntityIterable> resultFuture = new ResultFuture<BulkEntityIterable>(callback);
        this.downloadFileAsyncImpl(parameters, progress, (AsyncCallback<File>)new ParentCallback<File>(resultFuture){

            @Override
            public void onSuccess(File result) throws IOException {
                ResultFileType resultFileType = parameters.getLastSyncTimeInUTC() != null ? ResultFileType.PARTIAL_DOWNLOAD : ResultFileType.FULL_DOWNLOAD;
                BulkEntityReadable reader = BulkServiceManager.this.bulkEntityReaderFactory.createBulkFileReader(result, resultFileType, parameters.getFileType(), parameters.getAutoDeleteTempFile());
                resultFuture.setResult(reader.getEntities());
            }
        });
        return resultFuture;
    }

    public Future<File> downloadFileAsync(DownloadParameters parameters, AsyncCallback<File> callback) {
        return this.downloadFileAsync(parameters, null, callback);
    }

    public Future<File> downloadFileAsync(DownloadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<File> callback) {
        this.validateUserData();
        this.validateSubmitDownloadParameters(parameters.getSubmitDownloadParameters());
        return this.downloadFileAsyncImpl(parameters, progress, callback);
    }

    private Future<File> downloadFileAsyncImpl(final DownloadParameters parameters, final Progress<BulkOperationProgressInfo> progress, AsyncCallback<File> callback) {
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        this.workingDirectory.mkdirs();
        this.submitDownloadAsync(parameters.getSubmitDownloadParameters(), (AsyncCallback<BulkDownloadOperation>)new ParentCallback<BulkDownloadOperation>(resultFuture){

            @Override
            public void onSuccess(final BulkDownloadOperation operation) {
                operation.trackAsync(progress, new ParentCallback<BulkOperationStatus<DownloadStatus>>(resultFuture){

                    @Override
                    public void onSuccess(BulkOperationStatus<DownloadStatus> status) throws IOException, URISyntaxException {
                        BulkServiceManager.this.downloadBulkFileAsync(parameters.getResultFileDirectory(), parameters.getResultFileName(), parameters.getOverwriteResultFile(), operation, new ParentCallback<File>(resultFuture){

                            @Override
                            public void onSuccess(File localFile) {
                                resultFuture.setResult(localFile);
                            }
                        });
                    }
                });
            }
        });
        return resultFuture;
    }

    private <T> Future<File> downloadBulkFileAsync(File resultFileDirectory, String resultFileName, boolean overwriteResultFile, BulkOperation<T> operation, AsyncCallback<File> callback) throws IOException, URISyntaxException {
        operation.setHttpFileService(this.httpFileService);
        operation.setZipExtractor(this.zipExtractor);
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        File effectiveResultFileDirectory = resultFileDirectory;
        if (effectiveResultFileDirectory == null) {
            this.workingDirectory.mkdirs();
            effectiveResultFileDirectory = this.workingDirectory;
        }
        operation.downloadResultFileAsync(effectiveResultFileDirectory, resultFileName, true, overwriteResultFile, (AsyncCallback<File>)new ParentCallback<File>(resultFuture){

            @Override
            public void onSuccess(File file) {
                resultFuture.setResult(file);
            }
        });
        return resultFuture;
    }

    private void validateUserData() {
        this.authorizationData.validate();
    }

    public Future<BulkDownloadOperation> submitDownloadAsync(SubmitDownloadParameters parameters, AsyncCallback<BulkDownloadOperation> callback) {
        Authentication auth = this.authorizationData.getAuthentication();
        if (auth == null) {
            throw new IllegalArgumentException("Missing authentication");
        }
        final ResultFuture<BulkDownloadOperation> resultFuture = new ResultFuture<BulkDownloadOperation>(callback);
        if (parameters.getCampaignIds() == null) {
            DownloadCampaignsByAccountIdsRequest request = this.generateCampaignsByAccountIdRequest(parameters);
            IBulkService service = this.serviceClient.getService();
            service.downloadCampaignsByAccountIdsAsync(request, new AsyncHandler<DownloadCampaignsByAccountIdsResponse>(){

                public void handleResponse(Response<DownloadCampaignsByAccountIdsResponse> res) {
                    try {
                        DownloadCampaignsByAccountIdsResponse response = (DownloadCampaignsByAccountIdsResponse)res.get();
                        String trackingId = ServiceUtils.GetTrackingId(res);
                        BulkDownloadOperation operation = new BulkDownloadOperation(response.getDownloadRequestId(), BulkServiceManager.this.authorizationData, trackingId, BulkServiceManager.this.apiEnvironment);
                        operation.setStatusPollIntervalInMilliseconds(BulkServiceManager.this.statusPollIntervalInMilliseconds);
                        operation.setDownloadHttpTimeoutInMilliseconds(BulkServiceManager.this.downloadHttpTimeoutInMilliseconds);
                        resultFuture.setResult(operation);
                    }
                    catch (InterruptedException e) {
                        resultFuture.setException(new CouldNotSubmitBulkDownloadException(e));
                    }
                    catch (ExecutionException e) {
                        resultFuture.setException(new CouldNotSubmitBulkDownloadException(e));
                    }
                }
            });
        } else {
            DownloadCampaignsByCampaignIdsRequest request = this.generateCampaignsByCampaignIdsRequest(parameters);
            IBulkService service = this.serviceClient.getService();
            service.downloadCampaignsByCampaignIdsAsync(request, new AsyncHandler<DownloadCampaignsByCampaignIdsResponse>(){

                public void handleResponse(Response<DownloadCampaignsByCampaignIdsResponse> res) {
                    try {
                        DownloadCampaignsByCampaignIdsResponse response = (DownloadCampaignsByCampaignIdsResponse)res.get();
                        BulkDownloadOperation operation = new BulkDownloadOperation(response.getDownloadRequestId(), BulkServiceManager.this.authorizationData, ServiceUtils.GetTrackingId(res), BulkServiceManager.this.apiEnvironment);
                        operation.setStatusPollIntervalInMilliseconds(BulkServiceManager.this.statusPollIntervalInMilliseconds);
                        operation.setDownloadHttpTimeoutInMilliseconds(BulkServiceManager.this.downloadHttpTimeoutInMilliseconds);
                        resultFuture.setResult(operation);
                    }
                    catch (InterruptedException e) {
                        resultFuture.setException(new CouldNotSubmitBulkDownloadException(e));
                    }
                    catch (ExecutionException e) {
                        resultFuture.setException(new CouldNotSubmitBulkDownloadException(e));
                    }
                }
            });
        }
        return resultFuture;
    }

    public Future<BulkUploadOperation> submitUploadAsync(final FileUploadParameters parameters, AsyncCallback<BulkUploadOperation> callback) {
        GetBulkUploadUrlRequest request = new GetBulkUploadUrlRequest();
        request.setResponseMode(parameters.getResponseMode());
        request.setAccountId(this.authorizationData.getAccountId());
        final ResultFuture<BulkUploadOperation> resultFuture = new ResultFuture<BulkUploadOperation>(callback);
        final IBulkService service = this.serviceClient.getService();
        service.getBulkUploadUrlAsync(request, new AsyncHandler<GetBulkUploadUrlResponse>(){

            public void handleResponse(Response<GetBulkUploadUrlResponse> res) {
                try {
                    GetBulkUploadUrlResponse response = (GetBulkUploadUrlResponse)res.get();
                    String trackingId = ServiceUtils.GetTrackingId(res);
                    String uploadUrl = response.getUploadUrl();
                    File effectiveUploadPath = parameters.getUploadFilePath();
                    if (parameters.getRenameUploadFileToMatchRequestId()) {
                        effectiveUploadPath = this.renameUploadFileToMatchRequestId(effectiveUploadPath, response.getRequestId());
                    }
                    boolean shouldCompress = parameters.getCompressUploadFile() && !StringExtensions.getFileExtension(effectiveUploadPath.toString()).equals(".zip");
                    File compressedFilePath = null;
                    if (shouldCompress) {
                        effectiveUploadPath = compressedFilePath = BulkServiceManager.this.compressUploadFile(effectiveUploadPath);
                    }
                    Consumer<HttpRequest> addHeaders = new Consumer<HttpRequest>(){

                        @Override
                        public void accept(final HttpRequest request) {
                            request.addHeader("DeveloperToken", BulkServiceManager.this.authorizationData.getDeveloperToken());
                            request.addHeader("CustomerId", Long.toString(BulkServiceManager.this.authorizationData.getCustomerId()));
                            request.addHeader("AccountId", Long.toString(BulkServiceManager.this.authorizationData.getAccountId()));
                            BulkServiceManager.this.authorizationData.getAuthentication().addHeaders(new HeadersImpl(){

                                @Override
                                public void addHeader(String name, String value) {
                                    request.addHeader(name, value);
                                }
                            });
                        }
                    };
                    MessageHandler.getInstance().handleDirectMessage("Bulk Upload... requestId: " + response.getRequestId() + "; UploadFilePath:" + parameters.getUploadFilePath() + "; uploadUrl: " + uploadUrl);
                    BulkServiceManager.this.httpFileService.uploadFile(new URI(uploadUrl), effectiveUploadPath, addHeaders, BulkServiceManager.this.uploadHttpTimeoutInMilliseconds);
                    if (shouldCompress) {
                        compressedFilePath.delete();
                    }
                    if (parameters.getAutoDeleteTempFile()) {
                        parameters.getUploadFilePath().delete();
                    }
                    BulkUploadOperation operation = new BulkUploadOperation(response.getRequestId(), BulkServiceManager.this.authorizationData, service, trackingId, BulkServiceManager.this.apiEnvironment);
                    operation.setStatusPollIntervalInMilliseconds(BulkServiceManager.this.statusPollIntervalInMilliseconds);
                    operation.setDownloadHttpTimeoutInMilliseconds(BulkServiceManager.this.downloadHttpTimeoutInMilliseconds);
                    resultFuture.setResult(operation);
                }
                catch (InterruptedException e) {
                    resultFuture.setException(new CouldNotSubmitBulkUploadException(e));
                }
                catch (ExecutionException e) {
                    resultFuture.setException(new CouldNotSubmitBulkUploadException(e));
                }
                catch (URISyntaxException e) {
                    resultFuture.setException(e);
                }
                catch (CouldNotUploadFileException e) {
                    resultFuture.setException(e);
                }
            }

            private File renameUploadFileToMatchRequestId(File uploadFilePath, String requestId) {
                uploadFilePath.renameTo(uploadFilePath);
                Path path = uploadFilePath.toPath();
                File newFile = path.resolveSibling("upload_" + requestId + ".csv").toFile();
                if (uploadFilePath.renameTo(newFile)) {
                    return newFile;
                }
                return uploadFilePath;
            }
        });
        return resultFuture;
    }

    private File compressUploadFile(File uploadFilePath) {
        this.workingDirectory.mkdirs();
        File compressedFilePath = new File(this.workingDirectory, StringExtensions.getFileNameWithoutExtension(uploadFilePath) + "_" + UUID.randomUUID() + ".zip");
        this.zipExtractor.compressFile(uploadFilePath, compressedFilePath);
        return compressedFilePath;
    }

    public void cleanupTempFiles() {
        for (File file : this.workingDirectory.listFiles()) {
            file.delete();
        }
    }

    private DownloadCampaignsByCampaignIdsRequest generateCampaignsByCampaignIdsRequest(SubmitDownloadParameters parameters) {
        DownloadCampaignsByCampaignIdsRequest request = new DownloadCampaignsByCampaignIdsRequest();
        ArrayOfCampaignScope arrayOfCampaigns = new ArrayOfCampaignScope();
        List<CampaignScope> campaigns = arrayOfCampaigns.getCampaignScopes();
        for (Long campaignId : parameters.getCampaignIds()) {
            CampaignScope scope = new CampaignScope();
            scope.setCampaignId(campaignId);
            scope.setParentAccountId(this.authorizationData.getAccountId());
            campaigns.add(scope);
        }
        request.setCampaigns(arrayOfCampaigns);
        request.setDataScope(parameters.getDataScope());
        request.setDownloadFileType(parameters.getFileType());
        request.setDownloadEntities(parameters.getDownloadEntities());
        request.setFormatVersion(FORMAT_VERSION);
        request.setLastSyncTimeInUTC(parameters.getLastSyncTimeInUTC());
        return request;
    }

    private DownloadCampaignsByAccountIdsRequest generateCampaignsByAccountIdRequest(SubmitDownloadParameters parameters) {
        DownloadCampaignsByAccountIdsRequest request = new DownloadCampaignsByAccountIdsRequest();
        ArrayOflong accountIds = new ArrayOflong();
        accountIds.getLongs().add(this.authorizationData.getAccountId());
        request.setAccountIds(accountIds);
        request.setDataScope(parameters.getDataScope());
        request.setDownloadFileType(parameters.getFileType());
        request.setDownloadEntities(parameters.getDownloadEntities());
        request.setFormatVersion(FORMAT_VERSION);
        request.setLastSyncTimeInUTC(parameters.getLastSyncTimeInUTC());
        return request;
    }

    private FileUploadParameters createFileUploadParameters(EntityUploadParameters parameters) {
        this.workingDirectory.mkdirs();
        File tempFilePath = new File(this.getWorkingDirectory(), UUID.randomUUID() + ".csv");
        BulkFileWriter writer = null;
        try {
            writer = new BulkFileWriter(tempFilePath);
            for (BulkEntity entity : parameters.getEntities()) {
                writer.writeEntity(entity);
            }
        }
        catch (IOException ex) {
            throw new InternalException(ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    throw new InternalException(ex);
                }
            }
        }
        FileUploadParameters fileUploadParameters = new FileUploadParameters();
        fileUploadParameters.setUploadFilePath(tempFilePath);
        fileUploadParameters.setResponseMode(parameters.getResponseMode());
        fileUploadParameters.setResultFileDirectory(parameters.getResultFileDirectory());
        fileUploadParameters.setResultFileName(parameters.getResultFileName());
        fileUploadParameters.setOverwriteResultFile(parameters.getOverwriteResultFile());
        fileUploadParameters.setAutoDeleteTempFile(parameters.getAutoDeleteTempFile());
        return fileUploadParameters;
    }

    public HttpFileService getHttpFileService() {
        return this.httpFileService;
    }

    public void setHttpFileService(HttpFileService httpFileService) {
        this.httpFileService = httpFileService;
    }

    public ZipExtractor getZipExtractor() {
        return this.zipExtractor;
    }

    public void setZipExtractor(ZipExtractor zipExtractor) {
        this.zipExtractor = zipExtractor;
    }

    public BulkEntityReaderFactory getBulkEntityReaderFactory() {
        return this.bulkEntityReaderFactory;
    }

    public void setBulkEntityReaderFactory(BulkEntityReaderFactory bulkEntityReaderFactory) {
        this.bulkEntityReaderFactory = bulkEntityReaderFactory;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File value) {
        this.workingDirectory = value;
    }

    public int getStatusPollIntervalInMilliseconds() {
        return this.statusPollIntervalInMilliseconds;
    }

    public void setStatusPollIntervalInMilliseconds(int statusPollIntervalInMilliseconds) {
        this.statusPollIntervalInMilliseconds = statusPollIntervalInMilliseconds;
    }

    public int getUploadHttpTimeoutInMilliseconds() {
        return this.uploadHttpTimeoutInMilliseconds;
    }

    public void setUploadHttpTimeoutInMilliseconds(int uploadHttpTimeoutInMilliseconds) {
        this.uploadHttpTimeoutInMilliseconds = uploadHttpTimeoutInMilliseconds;
    }

    public int getDownloadHttpTimeoutInMilliseconds() {
        return this.downloadHttpTimeoutInMilliseconds;
    }

    public void setDownloadHttpTimeoutInMilliseconds(int downloadHttpTimeoutInMilliseconds) {
        this.downloadHttpTimeoutInMilliseconds = downloadHttpTimeoutInMilliseconds;
    }
}

