/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful.adaptor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CalendarSerializer
extends StdSerializer<Calendar> {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public CalendarSerializer() {
        this(null);
    }

    public CalendarSerializer(Class t) {
        super(t);
    }

    public void serialize(Calendar value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.formatter.setTimeZone(value.getTimeZone());
        String zone = value.getTimeZone().getID().replaceAll("GMT", "").replaceAll("UTC", "");
        Date date = value.getTime();
        gen.writeString(this.formatter.format(value.getTime()) + zone);
    }
}

