/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.AdExtensionHeaderType;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.FilterLinkAdExtension;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkFilterLinkAdExtension
extends BulkAdExtension<FilterLinkAdExtension> {
    private static final List<BulkMapping<BulkFilterLinkAdExtension>> MAPPINGS;

    public FilterLinkAdExtension getFilterLinkAdExtension() {
        return (FilterLinkAdExtension)this.getAdExtension();
    }

    public void setFilterLinkAdExtension(FilterLinkAdExtension FilterLinkAdExtension2) {
        this.setAdExtension(FilterLinkAdExtension2);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        FilterLinkAdExtension extension = new FilterLinkAdExtension();
        extension.setType("FilterLinkAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getFilterLinkAdExtension(), "FilterLinkAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkFilterLinkAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkFilterLinkAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkFilterLinkAdExtension, String>("AdExtension Header Type", new Function<BulkFilterLinkAdExtension, String>(){

            @Override
            public String apply(BulkFilterLinkAdExtension c) {
                return ((FilterLinkAdExtension)c.getAdExtension()).getAdExtensionHeaderType() != null ? ((FilterLinkAdExtension)c.getAdExtension()).getAdExtensionHeaderType().value() : null;
            }
        }, new BiConsumer<String, BulkFilterLinkAdExtension>(){

            @Override
            public void accept(String v, BulkFilterLinkAdExtension c) {
                if (c.getAdExtension() == null) {
                    return;
                }
                ((FilterLinkAdExtension)c.getAdExtension()).setAdExtensionHeaderType(StringExtensions.parseOptional(v, new Function<String, AdExtensionHeaderType>(){

                    @Override
                    public AdExtensionHeaderType apply(String value) {
                        return AdExtensionHeaderType.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkFilterLinkAdExtension, String>("Language", new Function<BulkFilterLinkAdExtension, String>(){

            @Override
            public String apply(BulkFilterLinkAdExtension c) {
                return c.getFilterLinkAdExtension().getLanguage();
            }
        }, new BiConsumer<String, BulkFilterLinkAdExtension>(){

            @Override
            public void accept(String v, BulkFilterLinkAdExtension c) {
                c.getFilterLinkAdExtension().setLanguage(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFilterLinkAdExtension, String>("Texts", new Function<BulkFilterLinkAdExtension, String>(){

            @Override
            public String apply(BulkFilterLinkAdExtension c) {
                return StringExtensions.WriteDelimitedStrings(";", ((FilterLinkAdExtension)c.getAdExtension()).getTexts());
            }
        }, new BiConsumer<String, BulkFilterLinkAdExtension>(){

            @Override
            public void accept(String v, BulkFilterLinkAdExtension c) {
                ((FilterLinkAdExtension)c.getAdExtension()).setTexts(StringExtensions.ParseDelimitedStrings(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkFilterLinkAdExtension, String>("Final Url", new Function<BulkFilterLinkAdExtension, String>(){

            @Override
            public String apply(BulkFilterLinkAdExtension c) {
                return StringExtensions.writeUrls("; ", ((FilterLinkAdExtension)c.getAdExtension()).getFinalUrls(), ((FilterLinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFilterLinkAdExtension>(){

            @Override
            public void accept(String v, BulkFilterLinkAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((FilterLinkAdExtension)c.getAdExtension()).setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFilterLinkAdExtension, String>("Mobile Final Url", new Function<BulkFilterLinkAdExtension, String>(){

            @Override
            public String apply(BulkFilterLinkAdExtension c) {
                return StringExtensions.writeUrls("; ", ((FilterLinkAdExtension)c.getAdExtension()).getFinalMobileUrls(), ((FilterLinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFilterLinkAdExtension>(){

            @Override
            public void accept(String v, BulkFilterLinkAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((FilterLinkAdExtension)c.getAdExtension()).setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFilterLinkAdExtension, String>("Tracking Template", new Function<BulkFilterLinkAdExtension, String>(){

            @Override
            public String apply(BulkFilterLinkAdExtension c) {
                return StringExtensions.toOptionalBulkString(((FilterLinkAdExtension)c.getAdExtension()).getTrackingUrlTemplate(), ((FilterLinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFilterLinkAdExtension>(){

            @Override
            public void accept(String v, BulkFilterLinkAdExtension c) {
                ((FilterLinkAdExtension)c.getAdExtension()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkFilterLinkAdExtension, String>("Custom Parameter", new Function<BulkFilterLinkAdExtension, String>(){

            @Override
            public String apply(BulkFilterLinkAdExtension c) {
                return StringExtensions.toCustomParaBulkString(((FilterLinkAdExtension)c.getAdExtension()).getUrlCustomParameters(), ((FilterLinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFilterLinkAdExtension>(){

            @Override
            public void accept(String v, BulkFilterLinkAdExtension c) {
                try {
                    ((FilterLinkAdExtension)c.getAdExtension()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkFilterLinkAdExtension, String>("Final Url Suffix", new Function<BulkFilterLinkAdExtension, String>(){

            @Override
            public String apply(BulkFilterLinkAdExtension c) {
                return StringExtensions.toOptionalBulkString(((FilterLinkAdExtension)c.getAdExtension()).getFinalUrlSuffix(), ((FilterLinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkFilterLinkAdExtension>(){

            @Override
            public void accept(String v, BulkFilterLinkAdExtension c) {
                ((FilterLinkAdExtension)c.getAdExtension()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

