/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.AdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.HotelGroup;
import com.microsoft.bingads.v13.campaignmanagement.HotelListing;
import com.microsoft.bingads.v13.campaignmanagement.HotelListingType;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupHotelListingGroup
extends BulkAdGroupCriterion {
    private static final List<BulkMapping<BulkAdGroupHotelListingGroup>> MAPPINGS;

    private static void parseHotelListing(RowValues values, BulkAdGroupHotelListingGroup entity) {
        String attribute = values.tryGet("Hotel Attribute Value");
        String operand = values.tryGet("Hotel Attribute");
        if (attribute != null || operand != null) {
            HotelListing value = new HotelListing();
            value.setAttribute(attribute);
            value.setOperand(operand);
            ((HotelGroup)entity.getAdGroupCriterion().getCriterion()).setListing(value);
        }
    }

    private static void HotelListingToRowValue(BulkAdGroupHotelListingGroup entity, RowValues values) {
        AdGroupCriterion adGroupCriterion = entity.getAdGroupCriterion();
        if (adGroupCriterion == null) {
            return;
        }
        Criterion criterion = adGroupCriterion.getCriterion();
        if (criterion == null) {
            return;
        }
        HotelListing hotelListing = ((HotelGroup)criterion).getListing();
        if (hotelListing != null) {
            values.put("Hotel Attribute Value", hotelListing.getAttribute());
            values.put("Hotel Attribute", hotelListing.getOperand());
        }
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupCriterion(), AdGroupCriterion.class.getSimpleName());
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public Criterion createCriterion() {
        HotelGroup hotelGroup = new HotelGroup();
        hotelGroup.setType(HotelGroup.class.getSimpleName());
        return hotelGroup;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupHotelListingGroup, String>("Sub Type", new Function<BulkAdGroupHotelListingGroup, String>(){

            @Override
            public String apply(BulkAdGroupHotelListingGroup c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof HotelGroup) {
                    HotelListingType hotelListingType = ((HotelGroup)c.getAdGroupCriterion().getCriterion()).getListingType();
                    return hotelListingType == null ? null : hotelListingType.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupHotelListingGroup>(){

            @Override
            public void accept(String v, BulkAdGroupHotelListingGroup c) {
                ((HotelGroup)c.getAdGroupCriterion().getCriterion()).setListingType(StringExtensions.parseOptional(v, new Function<String, HotelListingType>(){

                    @Override
                    public HotelListingType apply(String s) {
                        return HotelListingType.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupHotelListingGroup, Long>("Parent Criterion Id", new Function<BulkAdGroupHotelListingGroup, Long>(){

            @Override
            public Long apply(BulkAdGroupHotelListingGroup c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof HotelGroup) {
                    return ((HotelGroup)c.getAdGroupCriterion().getCriterion()).getParentCriterionId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupHotelListingGroup>(){

            @Override
            public void accept(String v, BulkAdGroupHotelListingGroup c) {
                ((HotelGroup)c.getAdGroupCriterion().getCriterion()).setParentCriterionId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new ComplexBulkMapping<BulkAdGroupHotelListingGroup>(new BiConsumer<BulkAdGroupHotelListingGroup, RowValues>(){

            @Override
            public void accept(BulkAdGroupHotelListingGroup c, RowValues v) {
                BulkAdGroupHotelListingGroup.HotelListingToRowValue(c, v);
            }
        }, new BiConsumer<RowValues, BulkAdGroupHotelListingGroup>(){

            @Override
            public void accept(RowValues v, BulkAdGroupHotelListingGroup c) {
                BulkAdGroupHotelListingGroup.parseHotelListing(v, c);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

