/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.Budget;
import com.microsoft.bingads.v13.campaignmanagement.BudgetLimitType;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkBudget
extends SingleRecordBulkEntity {
    private Budget budget;
    private Long accountId;
    private Status status;
    private static final List<BulkMapping<BulkBudget>> MAPPINGS;

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setBudget(new Budget());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBudget(), "Budget");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkBudget, Object>> m = new ArrayList<SimpleBulkMapping<BulkBudget, Object>>();
        m.add(new SimpleBulkMapping<BulkBudget, Long>("Id", new Function<BulkBudget, Long>(){

            @Override
            public Long apply(BulkBudget t) {
                return t.getBudget().getId();
            }
        }, new BiConsumer<String, BulkBudget>(){

            @Override
            public void accept(String v, BulkBudget c) {
                c.getBudget().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBudget, Long>("Parent Id", new Function<BulkBudget, Long>(){

            @Override
            public Long apply(BulkBudget c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkBudget>(){

            @Override
            public void accept(String v, BulkBudget c) {
                c.setAccountId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBudget, String>("Status", new Function<BulkBudget, String>(){

            @Override
            public String apply(BulkBudget t) {
                return t.getStatus() != null ? t.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkBudget>(){

            @Override
            public void accept(String v, BulkBudget c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBudget, String>("Budget Name", new Function<BulkBudget, String>(){

            @Override
            public String apply(BulkBudget t) {
                return t.getBudget().getName();
            }
        }, new BiConsumer<String, BulkBudget>(){

            @Override
            public void accept(String v, BulkBudget c) {
                c.getBudget().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkBudget, String>("Budget Type", new Function<BulkBudget, String>(){

            @Override
            public String apply(BulkBudget t) {
                return t.getBudget().getBudgetType() != null ? t.getBudget().getBudgetType().value() : null;
            }
        }, new BiConsumer<String, BulkBudget>(){

            @Override
            public void accept(String v, BulkBudget c) {
                c.getBudget().setBudgetType(StringExtensions.parseOptional(v, new Function<String, BudgetLimitType>(){

                    @Override
                    public BudgetLimitType apply(String value) {
                        return BudgetLimitType.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBudget, String>("Budget", new Function<BulkBudget, String>(){

            @Override
            public String apply(BulkBudget t) {
                return t.getBudget().getAmount() != null ? t.getBudget().getAmount().toString() : null;
            }
        }, new BiConsumer<String, BulkBudget>(){

            @Override
            public void accept(String v, BulkBudget c) {
                c.getBudget().setAmount(StringExtensions.nullOrBigDecimal(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

