/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.v13.campaignmanagement.ArrayOfWebpageCondition;
import com.microsoft.bingads.v13.campaignmanagement.WebpageCondition;
import com.microsoft.bingads.v13.campaignmanagement.WebpageConditionOperand;
import com.microsoft.bingads.v13.campaignmanagement.WebpageConditionOperator;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import java.util.List;

class WebpageConditionHelper {
    public static final int MaxNumberOfConditions = 3;

    WebpageConditionHelper() {
    }

    public static void addRowValuesFromConditions(ArrayOfWebpageCondition arrayOfWebpageCondition, RowValues rowValues) {
        List<WebpageCondition> conditions = arrayOfWebpageCondition.getWebpageConditions();
        for (int i = 1; i <= conditions.size(); ++i) {
            rowValues.put("Dynamic Ad Target Condition " + i, conditions.get(i - 1).getOperand().value());
            rowValues.put("Dynamic Ad Target Value " + i, conditions.get(i - 1).getArgument());
            rowValues.put("Dynamic Ad Target Condition Operator " + i, conditions.get(i - 1).getOperator().value());
        }
    }

    public static void addConditionsFromRowValues(RowValues values, ArrayOfWebpageCondition arrayOfWebpageCondition) {
        List<WebpageCondition> conditions = arrayOfWebpageCondition.getWebpageConditions();
        for (int i = 1; i <= 3; ++i) {
            String webpageCondition = values.tryGet("Dynamic Ad Target Condition " + i);
            String webpageValue = values.tryGet("Dynamic Ad Target Value " + i);
            String webpageOperator = values.tryGet("Dynamic Ad Target Condition Operator " + i);
            if (webpageCondition == null || webpageCondition.isEmpty() || webpageValue == null || webpageValue.isEmpty()) continue;
            WebpageCondition condition = new WebpageCondition();
            condition.setArgument(webpageValue);
            condition.setOperand(WebpageConditionOperand.fromValue(webpageCondition));
            if (webpageOperator != null && !webpageOperator.isEmpty()) {
                condition.setOperator(WebpageConditionOperator.fromValue(webpageOperator));
            }
            conditions.add(condition);
        }
    }
}

