/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.WebpageConditionHelper;
import com.microsoft.bingads.v13.campaignmanagement.AdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfWebpageCondition;
import com.microsoft.bingads.v13.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v13.campaignmanagement.FixedBid;
import com.microsoft.bingads.v13.campaignmanagement.Webpage;
import com.microsoft.bingads.v13.campaignmanagement.WebpageParameter;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupDynamicSearchAdTarget
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupDynamicSearchAdTarget>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        FixedBid fixedBid = new FixedBid();
        fixedBid.setType(FixedBid.class.getSimpleName());
        Webpage webpage = new Webpage();
        webpage.setParameter(new WebpageParameter());
        adGroupCriterion.setCriterion(webpage);
        adGroupCriterion.getCriterion().setType(Webpage.class.getSimpleName());
        adGroupCriterion.setCriterionBid(fixedBid);
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), AdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public AdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion biddableAdGroupCriterion) {
        this.biddableAdGroupCriterion = biddableAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Status", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, Long>("Id", new Function<BulkAdGroupDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkAdGroupDynamicSearchAdTarget c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, Long>("Parent Id", new Function<BulkAdGroupDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkAdGroupDynamicSearchAdTarget c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Campaign", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Ad Group", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Bid", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = ((BiddableAdGroupCriterion)c.getBiddableAdGroupCriterion()).getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toAdGroupCriterionFixedBidBulkString((FixedBid)bid);
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((FixedBid)((BiddableAdGroupCriterion)c.getBiddableAdGroupCriterion()).getCriterionBid()).setAmount(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Tracking Template", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toOptionalBulkString(((BiddableAdGroupCriterion)c.getBiddableAdGroupCriterion()).getTrackingUrlTemplate(), c.getBiddableAdGroupCriterion().getId());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BiddableAdGroupCriterion)c.getBiddableAdGroupCriterion()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Custom Parameter", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toCustomParaBulkString(((BiddableAdGroupCriterion)c.getBiddableAdGroupCriterion()).getUrlCustomParameters(), c.getBiddableAdGroupCriterion().getId());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    try {
                        ((BiddableAdGroupCriterion)c.getBiddableAdGroupCriterion()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        m.add(new ComplexBulkMapping<BulkAdGroupDynamicSearchAdTarget>(new BiConsumer<BulkAdGroupDynamicSearchAdTarget, RowValues>(){

            @Override
            public void accept(BulkAdGroupDynamicSearchAdTarget c, RowValues v) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getBiddableAdGroupCriterion().getCriterion()).getParameter();
                    if (webpageParameter == null || webpageParameter.getConditions() == null) {
                        return;
                    }
                    WebpageConditionHelper.addRowValuesFromConditions(webpageParameter.getConditions(), v);
                }
            }
        }, new BiConsumer<RowValues, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(RowValues v, BulkAdGroupDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getBiddableAdGroupCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setConditions(new ArrayOfWebpageCondition());
                    WebpageConditionHelper.addConditionsFromRowValues(v, webpageParameter.getConditions());
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Name", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getBiddableAdGroupCriterion().getCriterion()).getParameter();
                    return StringExtensions.toCriterionNameBulkString(webpageParameter, c.getBiddableAdGroupCriterion().getId());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getBiddableAdGroupCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setCriterionName(StringExtensions.parseCriterionName(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

