/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.NewOAuthTokensReceivedListener;
import com.microsoft.bingads.OAuthTokens;
import com.microsoft.bingads.internal.OAuthAuthorization;
import com.microsoft.bingads.internal.OAuthEndpointHelper;
import com.microsoft.bingads.internal.OAuthRequestParameters;
import com.microsoft.bingads.internal.OAuthService;
import com.microsoft.bingads.internal.OAuthUrlParameters;
import com.microsoft.bingads.internal.URLExtensions;
import com.microsoft.bingads.internal.UriOAuthService;
import java.net.URL;
import java.util.Map;

public abstract class OAuthWithAuthorizationCode
extends OAuthAuthorization {
    private static final long TIME_RESERVE_BEFORE_TOKEN_REFRESH_IN_SECONDS = 60L;
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String CODE = "code";
    private OAuthService oauthService;
    private String clientId;
    private String clientSecret;
    private URL redirectionUri;
    private boolean requireLiveConnect;
    private NewOAuthTokensReceivedListener newTokensListener;

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public URL getRedirectionUri() {
        return this.redirectionUri;
    }

    protected OAuthWithAuthorizationCode(String clientId, String clientSecret, URL redirectionUri, String refreshToken, ApiEnvironment env, boolean requireLiveConnect) {
        this(clientId, clientSecret, redirectionUri, env, requireLiveConnect);
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken must not be null");
        }
        this.oAuthTokens = new OAuthTokens(null, 0L, refreshToken);
    }

    protected OAuthWithAuthorizationCode(String clientId, String clientSecret, URL redirectionUri, OAuthTokens oauthTokens, ApiEnvironment env, boolean requireLiveConnect) {
        this(clientId, clientSecret, redirectionUri, env, requireLiveConnect);
        if (oauthTokens == null || oauthTokens.getRefreshToken() == null) {
            throw new NullPointerException("OAuth tokens must not be null");
        }
        this.oAuthTokens = new OAuthTokens(null, 0L, oauthTokens.getRefreshToken());
    }

    protected OAuthWithAuthorizationCode(String clientId, String clientSecret, URL redirectionUri, ApiEnvironment env, boolean requireLiveConnect) {
        super(env);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectionUri = redirectionUri;
        this.oauthService = new UriOAuthService(this.environment);
        this.requireLiveConnect = requireLiveConnect;
    }

    protected OAuthWithAuthorizationCode(String clientId, String clientSecret, URL redirectionUri, OAuthService oauthService, ApiEnvironment env, boolean requireLiveConnect) {
        super(env);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectionUri = redirectionUri;
        this.oauthService = oauthService;
        this.requireLiveConnect = requireLiveConnect;
    }

    @Override
    public URL getAuthorizationEndpoint() {
        return OAuthEndpointHelper.getAuthorizationEndpoint(new OAuthUrlParameters(this.clientId, CODE, this.redirectionUri, this.getState()), this.getEnvironment(), this.requireLiveConnect);
    }

    public OAuthTokens requestAccessAndRefreshTokens(URL responseUrl) {
        Map<String, String> queryParts = URLExtensions.parseQuery(responseUrl);
        if (!queryParts.containsKey(CODE)) {
            throw new IllegalArgumentException("Uri passed doesn't contain code param. Please make sure the uri has a code in it, for example http://myurl.com?code=123");
        }
        String code = queryParts.get(CODE);
        this.oAuthTokens = this.oauthService.getAccessTokens(new OAuthRequestParameters(this.clientId, this.clientSecret, this.redirectionUri, AUTHORIZATION_CODE, CODE, code), this.requireLiveConnect);
        this.raiseNewTokensEventIfNeeded();
        return this.oAuthTokens;
    }

    public OAuthTokens requestAccessAndRefreshTokens(String refreshToken) {
        this.oAuthTokens = this.oauthService.getAccessTokens(new OAuthRequestParameters(this.clientId, this.clientSecret, null, REFRESH_TOKEN, REFRESH_TOKEN, refreshToken), this.requireLiveConnect);
        this.raiseNewTokensEventIfNeeded();
        return this.oAuthTokens;
    }

    public OAuthTokens refreshTokensIfNeeded(boolean forceRefresh) {
        if (this.oAuthTokens == null) {
            throw new IllegalStateException("No OAuth tokens to refresh. Please request tokens first using requestAccessAndRefreshTokens()");
        }
        if (forceRefresh || this.oAuthTokens.getAccessToken() == null || this.oAuthTokens.getAccessTokenExpiresInSeconds() < 60L) {
            this.requestAccessAndRefreshTokens(this.oAuthTokens.getRefreshToken());
        }
        return this.oAuthTokens;
    }

    private void raiseNewTokensEventIfNeeded() {
        if (this.newTokensListener != null) {
            this.newTokensListener.onNewOAuthTokensReceived(this.oAuthTokens);
        }
    }

    public NewOAuthTokensReceivedListener getNewTokensListener() {
        return this.newTokensListener;
    }

    public void setNewTokensListener(NewOAuthTokensReceivedListener newTokensListener) {
        this.newTokensListener = newTokensListener;
    }
}

