/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v12.campaignmanagement.Address;
import com.microsoft.bingads.v12.campaignmanagement.BusinessGeoCodeStatus;
import com.microsoft.bingads.v12.campaignmanagement.GeoPoint;
import com.microsoft.bingads.v12.campaignmanagement.LocationAdExtension;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkLocationAdExtension
extends BulkAdExtension<LocationAdExtension> {
    private static final List<BulkMapping<BulkLocationAdExtension>> MAPPINGS;

    public LocationAdExtension getLocationAdExtension() {
        return (LocationAdExtension)this.getAdExtension();
    }

    public void setLocationAdExtension(LocationAdExtension extension) {
        this.setAdExtension(extension);
    }

    private static String getAddressPart(BulkLocationAdExtension adExtension, Function<Address, String> getFunc) {
        return adExtension.getLocationAdExtension().getAddress() != null ? getFunc.apply(adExtension.getLocationAdExtension().getAddress()) : null;
    }

    private static void setAddressPart(BulkLocationAdExtension adExtension, Consumer<Address> setFunc) {
        if (adExtension.getLocationAdExtension().getAddress() == null) {
            adExtension.getLocationAdExtension().setAddress(new Address());
        }
        setFunc.accept(adExtension.getLocationAdExtension().getAddress());
    }

    private static Double getGeoPointPart(BulkLocationAdExtension adExtension, Function<GeoPoint, Double> getFunc) {
        return adExtension.getLocationAdExtension().getGeoPoint() != null ? getFunc.apply(adExtension.getLocationAdExtension().getGeoPoint()) : null;
    }

    private static void setGeoPointPart(BulkLocationAdExtension adExtension, BiConsumer<GeoPoint, String> setFunc, String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return;
        }
        if (adExtension.getLocationAdExtension().getGeoPoint() == null) {
            adExtension.getLocationAdExtension().setGeoPoint(new GeoPoint());
        }
        setFunc.accept(adExtension.getLocationAdExtension().getGeoPoint(), value);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        LocationAdExtension extension = new LocationAdExtension();
        extension.setType("LocationAdExtension");
        this.setLocationAdExtension(extension);
        if (!StringExtensions.isNullOrEmpty(values.get("Latitude")) || !StringExtensions.isNullOrEmpty(values.get("Longitude"))) {
            this.getLocationAdExtension().setGeoPoint(new GeoPoint());
        }
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getLocationAdExtension(), "LocationAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkLocationAdExtension, Object>> m = new ArrayList<SimpleBulkMapping<BulkLocationAdExtension, Object>>();
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("Business Name", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(BulkLocationAdExtension c) {
                return c.getLocationAdExtension().getCompanyName();
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(String v, BulkLocationAdExtension c) {
                c.getLocationAdExtension().setCompanyName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("Phone Number", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(BulkLocationAdExtension c) {
                return StringExtensions.toOptionalBulkString(c.getLocationAdExtension().getPhoneNumber(), c.getLocationAdExtension().getId());
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(String v, BulkLocationAdExtension c) {
                c.getLocationAdExtension().setPhoneNumber(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("Geo Code Status", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(BulkLocationAdExtension c) {
                return StringExtensions.toGeoCodeStatusBulkString(c.getLocationAdExtension().getGeoCodeStatus());
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(String v, BulkLocationAdExtension c) {
                c.getLocationAdExtension().setGeoCodeStatus(StringExtensions.parseOptional(v, new Function<String, BusinessGeoCodeStatus>(){

                    @Override
                    public BusinessGeoCodeStatus apply(String value) {
                        return BusinessGeoCodeStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("Address Line 1", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(BulkLocationAdExtension c) {
                return BulkLocationAdExtension.getAddressPart(c, new Function<Address, String>(){

                    @Override
                    public String apply(Address x) {
                        return x.getStreetAddress();
                    }
                });
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(final String v, BulkLocationAdExtension c) {
                BulkLocationAdExtension.setAddressPart(c, new Consumer<Address>(){

                    @Override
                    public void accept(Address x) {
                        x.setStreetAddress(StringExtensions.getValueOrEmptyString(v));
                    }
                });
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("Address Line 2", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(final BulkLocationAdExtension c) {
                return BulkLocationAdExtension.getAddressPart(c, new Function<Address, String>(){

                    @Override
                    public String apply(Address x) {
                        return StringExtensions.toOptionalBulkString(x.getStreetAddress2(), ((LocationAdExtension)c.getAdExtension()).getId());
                    }
                });
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(final String v, BulkLocationAdExtension c) {
                BulkLocationAdExtension.setAddressPart(c, new Consumer<Address>(){

                    @Override
                    public void accept(Address x) {
                        x.setStreetAddress2(StringExtensions.getValueOrEmptyString(v));
                    }
                });
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("City", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(BulkLocationAdExtension c) {
                return BulkLocationAdExtension.getAddressPart(c, new Function<Address, String>(){

                    @Override
                    public String apply(Address x) {
                        return x.getCityName();
                    }
                });
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(final String v, BulkLocationAdExtension c) {
                BulkLocationAdExtension.setAddressPart(c, new Consumer<Address>(){

                    @Override
                    public void accept(Address x) {
                        x.setCityName(v);
                    }
                });
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("Province Name", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(BulkLocationAdExtension c) {
                return BulkLocationAdExtension.getAddressPart(c, new Function<Address, String>(){

                    @Override
                    public String apply(Address x) {
                        return x.getProvinceName();
                    }
                });
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(final String v, BulkLocationAdExtension c) {
                BulkLocationAdExtension.setAddressPart(c, new Consumer<Address>(){

                    @Override
                    public void accept(Address x) {
                        x.setProvinceName(v);
                    }
                });
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("State Or Province Code", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(BulkLocationAdExtension c) {
                return BulkLocationAdExtension.getAddressPart(c, new Function<Address, String>(){

                    @Override
                    public String apply(Address x) {
                        return x.getProvinceCode();
                    }
                });
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(final String v, BulkLocationAdExtension c) {
                BulkLocationAdExtension.setAddressPart(c, new Consumer<Address>(){

                    @Override
                    public void accept(Address x) {
                        x.setProvinceCode(v);
                    }
                });
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("Postal Code", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(BulkLocationAdExtension c) {
                return BulkLocationAdExtension.getAddressPart(c, new Function<Address, String>(){

                    @Override
                    public String apply(Address x) {
                        return x.getPostalCode();
                    }
                });
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(final String v, BulkLocationAdExtension c) {
                BulkLocationAdExtension.setAddressPart(c, new Consumer<Address>(){

                    @Override
                    public void accept(Address x) {
                        x.setPostalCode(v);
                    }
                });
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, String>("Country Code", new Function<BulkLocationAdExtension, String>(){

            @Override
            public String apply(BulkLocationAdExtension c) {
                return BulkLocationAdExtension.getAddressPart(c, new Function<Address, String>(){

                    @Override
                    public String apply(Address x) {
                        return x.getCountryCode();
                    }
                });
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(final String v, BulkLocationAdExtension c) {
                BulkLocationAdExtension.setAddressPart(c, new Consumer<Address>(){

                    @Override
                    public void accept(Address x) {
                        x.setCountryCode(v);
                    }
                });
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, Double>("Latitude", new Function<BulkLocationAdExtension, Double>(){

            @Override
            public Double apply(BulkLocationAdExtension c) {
                return BulkLocationAdExtension.getGeoPointPart(c, new Function<GeoPoint, Double>(){

                    @Override
                    public Double apply(GeoPoint x) {
                        return (double)x.getLatitudeInMicroDegrees() / 1000000.0;
                    }
                });
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(String v, BulkLocationAdExtension c) {
                BulkLocationAdExtension.setGeoPointPart(c, new BiConsumer<GeoPoint, String>(){

                    @Override
                    public void accept(GeoPoint x, String longitude) {
                        x.setLatitudeInMicroDegrees(StringExtensions.parseLatLngInMicroDegrees(longitude));
                    }
                }, v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationAdExtension, Double>("Longitude", new Function<BulkLocationAdExtension, Double>(){

            @Override
            public Double apply(BulkLocationAdExtension c) {
                return BulkLocationAdExtension.getGeoPointPart(c, new Function<GeoPoint, Double>(){

                    @Override
                    public Double apply(GeoPoint x) {
                        return (double)x.getLongitudeInMicroDegrees() / 1000000.0;
                    }
                });
            }
        }, new BiConsumer<String, BulkLocationAdExtension>(){

            @Override
            public void accept(String v, BulkLocationAdExtension c) {
                BulkLocationAdExtension.setGeoPointPart(c, new BiConsumer<GeoPoint, String>(){

                    @Override
                    public void accept(GeoPoint x, String longitude) {
                        x.setLongitudeInMicroDegrees(StringExtensions.parseLatLngInMicroDegrees(longitude));
                    }
                }, v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

