/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v12.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v12.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v12.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignAudienceAssociation
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion biddableCampaignCriterion;
    private String campaignName;
    private String audienceName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkCampaignAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        campaignCriterion.setType(BiddableCampaignCriterion.class.getSimpleName());
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        campaignCriterion.setCriterion(audienceCriterion);
        campaignCriterion.setCriterionBid(bidMultiplier);
        this.setBiddableCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableCampaignCriterion(), "CampaignAudienceAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public BiddableCampaignCriterion getBiddableCampaignCriterion() {
        return this.biddableCampaignCriterion;
    }

    public void setBiddableCampaignCriterion(BiddableCampaignCriterion campaignCriterion) {
        this.biddableCampaignCriterion = campaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAudienceName() {
        return this.audienceName;
    }

    public void setAudienceName(String audienceName) {
        this.audienceName = audienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignAudienceAssociation, String>("Status", new Function<BulkCampaignAudienceAssociation, String>(){

            @Override
            public String apply(BulkCampaignAudienceAssociation c) {
                CampaignCriterionStatus status = c.getBiddableCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignAudienceAssociation c) {
                c.getBiddableCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAudienceAssociation, Long>("Id", new Function<BulkCampaignAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkCampaignAudienceAssociation c) {
                return c.getBiddableCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignAudienceAssociation c) {
                c.getBiddableCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAudienceAssociation, Long>("Parent Id", new Function<BulkCampaignAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkCampaignAudienceAssociation c) {
                return c.getBiddableCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignAudienceAssociation c) {
                c.getBiddableCampaignCriterion().setCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAudienceAssociation, String>("Campaign", new Function<BulkCampaignAudienceAssociation, String>(){

            @Override
            public String apply(BulkCampaignAudienceAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignAudienceAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAudienceAssociation, String>("Audience", new Function<BulkCampaignAudienceAssociation, String>(){

            @Override
            public String apply(BulkCampaignAudienceAssociation c) {
                return c.getAudienceName();
            }
        }, new BiConsumer<String, BulkCampaignAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignAudienceAssociation c) {
                c.setAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAudienceAssociation, String>("Bid Adjustment", new Function<BulkCampaignAudienceAssociation, String>(){

            @Override
            public String apply(BulkCampaignAudienceAssociation c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionBid bid = c.getBiddableCampaignCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignAudienceAssociation c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    ((BidMultiplier)c.getBiddableCampaignCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAudienceAssociation, Long>("Audience Id", new Function<BulkCampaignAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkCampaignAudienceAssociation c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableCampaignCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableCampaignCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

