/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v13.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v13.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v13.campaignmanagement.Day;
import com.microsoft.bingads.v13.campaignmanagement.DayTimeCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Minute;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignDayTimeCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion biddableCampaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignDayTimeCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        DayTimeCriterion daytimeCriterion = new DayTimeCriterion();
        campaignCriterion.setCriterion(daytimeCriterion);
        campaignCriterion.getCriterion().setType(DayTimeCriterion.class.getSimpleName());
        campaignCriterion.setCriterionBid(bidMultiplier);
        campaignCriterion.setType("BiddableCampaignCriterion");
        this.setBiddableCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getBiddableCampaignCriterion() {
        return this.biddableCampaignCriterion;
    }

    public void setBiddableCampaignCriterion(BiddableCampaignCriterion biddableCampaignCriterion) {
        this.biddableCampaignCriterion = biddableCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignDayTimeCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignDayTimeCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, String>("Status", new Function<BulkCampaignDayTimeCriterion, String>(){

            @Override
            public String apply(BulkCampaignDayTimeCriterion c) {
                CampaignCriterionStatus status = c.getBiddableCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                c.getBiddableCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, Long>("Id", new Function<BulkCampaignDayTimeCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignDayTimeCriterion c) {
                return c.getBiddableCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                c.getBiddableCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, Long>("Parent Id", new Function<BulkCampaignDayTimeCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignDayTimeCriterion c) {
                return c.getBiddableCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                c.getBiddableCampaignCriterion().setCampaignId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, String>("Campaign", new Function<BulkCampaignDayTimeCriterion, String>(){

            @Override
            public String apply(BulkCampaignDayTimeCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, String>("Bid Adjustment", new Function<BulkCampaignDayTimeCriterion, String>(){

            @Override
            public String apply(BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionBid bid = c.getBiddableCampaignCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    ((BidMultiplier)c.getBiddableCampaignCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, String>("Target", new Function<BulkCampaignDayTimeCriterion, String>(){

            @Override
            public String apply(BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Day day = ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).getDay();
                    return day == null ? null : day.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).setDay(StringExtensions.parseOptional(v, new Function<String, Day>(){

                        @Override
                        public Day apply(String s) {
                            return Day.fromValue(s);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, String>("From Hour", new Function<BulkCampaignDayTimeCriterion, String>(){

            @Override
            public String apply(BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Integer hour = ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).getFromHour();
                    return StringExtensions.toBulkString(hour);
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).setFromHour(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                        @Override
                        public Integer apply(String s) {
                            return Integer.parseInt(s);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, String>("To Hour", new Function<BulkCampaignDayTimeCriterion, String>(){

            @Override
            public String apply(BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Integer hour = ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).getToHour();
                    return StringExtensions.toBulkString(hour);
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).setToHour(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                        @Override
                        public Integer apply(String s) {
                            return Integer.parseInt(s);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, String>("From Minute", new Function<BulkCampaignDayTimeCriterion, String>(){

            @Override
            public String apply(BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Minute minute = ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).getFromMinute();
                    return minute == null ? null : StringExtensions.toMinuteBulkString(minute);
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).setFromMinute(StringExtensions.parseMinute(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDayTimeCriterion, String>("To Minute", new Function<BulkCampaignDayTimeCriterion, String>(){

            @Override
            public String apply(BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Minute minute = ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).getToMinute();
                    return minute == null ? null : StringExtensions.toMinuteBulkString(minute);
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDayTimeCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableCampaignCriterion().getCriterion()).setToMinute(StringExtensions.parseMinute(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

