/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v12.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupNegativeAudienceAssociation
extends SingleRecordBulkEntity {
    private NegativeAdGroupCriterion negativeAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String audienceName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAdGroupNegativeAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeAdGroupCriterion adGroupCriterion = new NegativeAdGroupCriterion();
        adGroupCriterion.setType(NegativeAdGroupCriterion.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        adGroupCriterion.setCriterion(audienceCriterion);
        this.setNegativeAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeAdGroupCriterion(), "AdGroupAudienceAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public NegativeAdGroupCriterion getNegativeAdGroupCriterion() {
        return this.negativeAdGroupCriterion;
    }

    public void setNegativeAdGroupCriterion(NegativeAdGroupCriterion adGroupCriterion) {
        this.negativeAdGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAudienceName() {
        return this.audienceName;
    }

    public void setAudienceName(String audienceName) {
        this.audienceName = audienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAudienceAssociation, String>("Status", new Function<BulkAdGroupNegativeAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeAudienceAssociation c) {
                AdGroupCriterionStatus status = c.getNegativeAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAudienceAssociation c) {
                c.getNegativeAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAudienceAssociation, Long>("Id", new Function<BulkAdGroupNegativeAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeAudienceAssociation c) {
                return c.getNegativeAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAudienceAssociation c) {
                c.getNegativeAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAudienceAssociation, Long>("Parent Id", new Function<BulkAdGroupNegativeAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeAudienceAssociation c) {
                return c.getNegativeAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAudienceAssociation c) {
                c.getNegativeAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAudienceAssociation, String>("Campaign", new Function<BulkAdGroupNegativeAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeAudienceAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAudienceAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAudienceAssociation, String>("Ad Group", new Function<BulkAdGroupNegativeAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeAudienceAssociation c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAudienceAssociation c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAudienceAssociation, String>("Audience", new Function<BulkAdGroupNegativeAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeAudienceAssociation c) {
                return c.getAudienceName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAudienceAssociation c) {
                c.setAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAudienceAssociation, Long>("Audience Id", new Function<BulkAdGroupNegativeAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeAudienceAssociation c) {
                if (c.getNegativeAdGroupCriterion() instanceof NegativeAdGroupCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeAdGroupCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeAdGroupCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

